/* (bbcim) d_write_cat.c: write catalogue entry in diskimage
 *
 * Copyright (C) W.H.Scholten 1996,1997
 */




/* Dit moet in write_cat_entry(image, file, file_pointer); */
int d_write_cat_entry(struct diskimage *image, struct bbcfile *file, struct bbcdisk_data *disk_data) {
    FILE *fpdisk, *fpadd;
    unsigned char filebyte,H;
    char infofile[100];
    char bbcfile_naam[15];
    unsigned char afiles=0;
    static int  addfiles;
    unsigned long loadaddress, execaddress;
    int  l,i, len_s;
    long startsector, length, j;
    unsigned char eellddss, locked;
    unsigned int  sectorsondisk;
    char *disk;



    /* file pointer struct in diskimage struct ?? */
    int  tracksize=image->sectors_per_track*image->bytes_per_sector;
    int  sides=image->sides;


    if (!(fpdisk=fopen(image->filename,"wb"))) return BBC_OPEN_FAILED;


    /* Put name in diskimage */
    filebyte=bbcfile_naam[0]+(locked<<7);
    fseek(fpdisk,15L,SEEK_SET);
    fwrite(&filebyte,1,1,fpdisk);

    fseek(fpdisk,8L,SEEK_SET);
    for(i=0; i<7; i++) {
	filebyte=bbcfile_naam[i+2];
	if (filebyte==0) {
	    filebyte=' '; bbcfile_naam[i+3]=0;
	}
	fwrite(&filebyte,1,1,fpdisk);
    }

    afiles +=8;
    fseek(fpdisk,256+5L,SEEK_SET);
    fwrite(&afiles,1,1,fpdisk);




    /* load/exec  adressen + lengte schrijven */
    fseek(fpdisk,256L+14L+tracksize*image->sides,SEEK_SET);

    eellddss=((startsector >>8) & 0x3)+((loadaddress >>14) &0xC);
    eellddss +=((execaddress >>10) &0xC0);
    eellddss +=((length >>12) &0x30);
    fwrite(&eellddss,1,1,fpdisk);

    /* STARTSECTOR */
    filebyte=startsector & 0xFF;
    fwrite(&filebyte,1,1,fpdisk);

    /* LOADADDRESS */
    fseek(fpdisk,256L+8L,0);
    filebyte=loadaddress & 0xFF;
    H=(loadaddress >>8) & 0xFF;
    fwrite(&filebyte,1,1,fpdisk);
    fwrite(&H,1,1,fpdisk);

    /* EXECADDRESS */
    filebyte=execaddress & 0xFF;
    H=(execaddress >>8) & 0xFF;
    fwrite(&filebyte,1,1,fpdisk);
    fwrite(&H,1,1,fpdisk);

    /* FILELENGTE */
    filebyte= length & 0xFF;
    H=(length >>8) & 0xFF;
    fwrite(&filebyte,1,1,fpdisk);
    fwrite(&H,1,1,fpdisk);

    fclose(fpdisk);
    return 0;
}

