/* BBCONV - converts to and from BBC BASIC files used by BBC's, and PCBBCBASIC
   (c) 1997 Andrew De Quincey - adq@tardis.ed.ac.uk
   */

#include <stdio.h>

void fromBBC(void);
void toBBC(void);
void helpPage(void);

int main(int argc, char *argv[])
{
  if (argc != 4)
    helpPage();

  freopen(argv[2], "rb", stdin);
  freopen(argv[3], "wb", stdout);

  if (!strcmp(argv[1], "-from"))
  {
    fromBBC();
    exit(1);
  }

  if (!strcmp(argv[1], "-to"))
  {
    toBBC();
    exit(1);
  }
  
  helpPage();
}
  

/* Convert from BBC BASIC format -> PC BBC BASIC format */
void fromBBC(void)
{
  char line[512];
  int count;
  int lnum1, lnum2;
  int c;

  /* ignore first byte */
  if (fgetc(stdin) != 13)
  {
    fprintf(stderr, "Input file is not a valid BBC BASIC file\n");
    exit(1);
  }


  while(!feof(stdin))
  {
    /* check for a slightly dodgy BBC BASIC file (ie missing last 0xFF byte) */
    if ((lnum1 = fgetc(stdin)) == EOF)
    {
      fprintf(stderr, "Possible error: no 255 byte at EOF\n");
      break;
    }

    /* if we get an 0xFF as the first line number byte => end of file */
    if (lnum1 == 0xff)
      break;
    
    /* get second line number part */
    lnum2 = fgetc(stdin);

    /* we're going to recalculate the line length anyway */
    fgetc(stdin);
    
    /* read in the line */
    count=0;
    while((c = fgetc(stdin)) != 13)
      line[count++] =c;
    line[count] = 0;
    
    /* output the new PCBBCbasic line header */
    fputc(strlen(line) + 4, stdout);
    fputc(lnum2, stdout);
    fputc(lnum1, stdout);

    /* output the actual line */
    count=0;
    while((c = line[count++]) != 0)
      fputc(c, stdout);
    fputc(13, stdout);
  }

  /* PCBBCBASIC trailer of file */
  fputc(0, stdout);
  fputc(0xff, stdout);
  fputc(0xff, stdout);
}




/* convert from PCBBCBASIC format -> BBCBASIC format */
void toBBC(void)
{
  char line[512];
  int count;
  int lnum1, lnum2, llen;
  int c;

  /* needed for BBC BASIC files */
  fputc(13, stdout);

  while(!feof(stdin))
  {
    /* read in PCBBCBASIC line header */
    llen = fgetc(stdin);
    lnum1 = fgetc(stdin);
    lnum2 = fgetc(stdin);

    /* check for PC BBC BASIC end of file marker */
    if ((llen == 0x00) && (lnum1 == 0xff) && (lnum2 == 0xff))
      break;

    /* read in the PCBBCBASIC line */
    count=0;
    while((c = fgetc(stdin)) != 13)
      line[count++] =c;
    line[count] = 0;
    
    /* output the new BBC BASIC line header */
    fputc(lnum2, stdout);
    fputc(lnum1, stdout);
    fputc(strlen(line) + 4, stdout);

    /* output the actual line */
    count=0;
    while((c = line[count++]) != 0)
      fputc(c, stdout);
    fputc(13, stdout);
  }

  /* BBC BASIC trailer of file */
  fputc(0xff, stdout);
}

void helpPage(void)
{
  fprintf(stderr, "bbcconv - converts BBC BASIC files to and from PCBBCBASIC\n\n");
  fprintf(stderr, "Usage: bbcconv [-from|-to] infile outfile\n");
  fprintf(stderr, "Where: -from converts FROM BBC BASIC\n");
  fprintf(stderr, "       -to converts TO BBC BASIC\n");

  exit(1);
}

