<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

  <xsl:template match="/">
    <html>
      <head>
      <title>BBC programs</title>
      <link rel="stylesheet" type="text/css" href="style.css"/>
      </head>
      <body>

        <p class="header1">BBC Programs</p>    
        <p class="header2">Page generated by BeebEF</p>    

        <xsl:for-each select="programs/publisher" order-by="publisher-name">
          <xsl:apply-templates select="publisher-name"/>
          <xsl:for-each select="program" order-by="program-name">
            <xsl:apply-templates select="program-name"/>
            <p class="normalindented">
              <xsl:apply-templates select="picture-url"/>
              <xsl:apply-templates select="boxcover-url"/>
              <xsl:apply-templates select="file-url"/>
              <xsl:apply-templates select="doclinks"/>
            </p>
            <xsl:apply-templates select="comments"/>
            <xsl:if match=".[e00dfs='true']">
              <p class="normalindented"><i>This program requires page at &amp;E00.</i></p>
            </xsl:if>
            <xsl:apply-templates select="emuwarnings"/>
          </xsl:for-each>         
        </xsl:for-each>

      </body>
    </html>
  </xsl:template>

  <xsl:template match="publisher-name">
    <p class="section1"><xsl:value-of/></p>
  </xsl:template>

  <xsl:template match="program-name">
    <p class="section2"><xsl:value-of/></p>
  </xsl:template>

  <xsl:template match="picture-url">
    <a>
      <xsl:attribute name="href"><xsl:value-of/></xsl:attribute>
      <img border="0" hspace="7" width="160" height="120" align="left" alt="Screenshot">
        <xsl:attribute name="src"><xsl:value-of/></xsl:attribute>
      </img>
    </a>      
  </xsl:template>

  <xsl:template match="boxcover-url">
    <a>
      <xsl:attribute name="href"><xsl:value-of/></xsl:attribute>
      <img border="0" hspace="7" height="120" align="left" alt="Screenshot">
        <xsl:attribute name="src"><xsl:value-of/></xsl:attribute>
      </img>
    </a>      
  </xsl:template>

  <xsl:template match="file-url">
    <font color="white"/>aa<font color="black"/>
    <a>
      <xsl:attribute name="href"><xsl:value-of/></xsl:attribute>
      Disk/rom image
    </a><br/>
  </xsl:template>

  <xsl:template match="doclinks">
    <xsl:for-each select="doclink">
      <font color="white"/>aa<font color="black"/>
      <a>
        <xsl:attribute name="href"><xsl:value-of select="doc-url"/></xsl:attribute>
        <xsl:value-of select="doc-name"/>
      </a><br/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="comments">
    <p class="normalindented">
      <xsl:for-each select="commentline">
        <xsl:value-of/>
        <br/>
      </xsl:for-each>
    </p>
  </xsl:template>

  <xsl:template match="emuwarnings">
    <p class="normalindented">
      <i>Emulator warning</i>
      <br/>
      <xsl:for-each select="emuwarning" order-by="emu-name">
        <xsl:value-of select="emu-name"/>: 
        <xsl:value-of select="warningtext"/>
        <br/>
      </xsl:for-each>
    </p>
  </xsl:template>

</xsl:stylesheet>
