#ifndef _VGA_HPP
#define _VGA_HPP

#include <dos.h>		// for geninterrupt() in the setMode() macro
#include <conio.h>

#define MAX_SCREENHEIGHT	360

class TweakMode
	{
	char *name;
	unsigned width;
	unsigned height;
public:
	void print();
	void set();
	};

// Global variables

extern char *vga;
extern int screenWidth;
extern int screenWidthBytes;
extern int screenHeight;
extern unsigned pageSize;
extern unsigned activePage, inactivePage;
//extern unsigned activePlane;
extern unsigned lineOffset[MAX_SCREENHEIGHT];

// Tweaked mode operations

extern int selectTweakMode();
extern void setTweakMode(int mode);


#define setMode(m) (_AX=m, geninterrupt(0x10))

// waitRetraceStart() suspends execution until the VGA has started a fresh
// vertical retrace.

#define IN_RETRACE (inp(0x3da)&0x8)
#define waitRetraceStart()	\
	{						\
	while (IN_RETRACE);		\
	while (!IN_RETRACE);	\
	}						\

extern void setStartAdress(unsigned adr);
extern void putPixel(int x, int y, char color);
extern void putText(int x, int y, char color, char *str);
extern int gprintf(int x, int y, char color, char *fmt, ...);
extern void hline(int, int, int, char);
extern void box(int, int, int, int, char);

// setPlane(plane) sets the Write Plane Enable register.

inline void setPlane(int plane)
	{
		outpw(0x3c4, (plane << 8) | 0x02);
//		activePlane = plane;
	}


#endif
