#ifndef _TRACE_HPP
#define _TRACE_HPP

#include "map.hpp"
#include "fixed.h"

typedef void TraceFunc(int);

extern int hY, vX, dhY, dvX;
extern Fixed hX, vY, dhX, dvY;
extern unsigned mirrorDepth;
extern TraceFunc *trace[2];
extern int hDominant;
extern int traceLevel;
extern int directTrace, mirroredX, mirroredY;
extern char *vgaBuf, *activeBuf, *tempBuf;
extern unsigned bufStepY;
void traceHorz(int);
void traceVert(int);

// Define SHOWSCAN if the wall scanning progress is to be shown on the
// screen with each frame.  The player's eye and screen will be plotted
// in world coordinates, and the points at which walls was detected will
// be highlighted.  For debugging purposes only.

//#define SHOWSCAN

#ifdef SHOWSCAN
# define SHOWMAP(x,y,c) showMap(x,y,c)
#include "fixed.h"
void showMap(Fixed, Fixed, char);
#else
# define SHOWMAP(x,y,c)
#endif


#endif
