#include <assert.h>

#include "mouse.hpp"

int Mouse::instances = 0;

Mouse mouse;

Mouse::Mouse()
	{
	++instances;
	assert(("Only one Mouse instance allowed", instances == 1));
	init();
	}

void Mouse::init()
	{
	callMouse(0x0000);		// Reset driver
	// This installation check is really too simplistic but it'll do
	// for now.
	installed = (reg.r_ax == 0xffff);
	// Enable mouse class if the driver was found.
	setState(1);
	if (enabled)
		callMouse(0x000b);	// Oddly enough, the reset doesn't reset the
							// motion counters in MS MOUSE 9.0, so make
							// sure by resetting them explicittly
	}

void Mouse::getMotion(int &x, int &y)
	{
	if (enabled)
		{
		callMouse(0x0b);
		x=reg.r_cx; y=reg.r_dx;
		}
	else
		x = y = 0;
	}

void Mouse::getPosition(int &x, int &y)
	{
	if (enabled)
		{
		callMouse(0x03);
		x=reg.r_cx; y=reg.r_dx;
		}
	else
		x = y = 0;
	}

void Mouse::setPosition(int x, int y)
	{
	if (enabled)
		{
		reg.r_cx=x; reg.r_dx=y;
		callMouse(0x04);
		}
	}

int Mouse::getButtons()
	{
	if (enabled)
		{
		callMouse(0x03);
		return reg.r_bx;
		}
	else
		return 0;
	}
