#ifndef _DIV0_H
#define _DIV0_H

/*
 * To play safe, mangle all this in C style.
 */

#ifdef __cplusplus
extern "C" {
#endif

//#include <dos.h>

extern volatile div0Flag;					// defined in DIV0.ASM
extern void interrupt div0Handler(...);		// defined in DIV0.ASM
extern void install0Handler(void);			// defined in DIV0INST.CPP
extern void deinstall0Handler(void);		// defined in DIV0INST.CPP
extern void interrupt (*old0Handler)(...);	// defined in DIV0INST.CPP

/*
 * Use div0Clear() to clear div0Flag before a division you want to
 * check for success.
 * 
 * Note that div0Error() calls div0Clear().
 */

inline void div0Clear()
	{
	div0Flag = 0;
	}

inline int div0Error()
	{
	_AX = div0Flag;
	div0Clear();
	return _AX;
	}

#ifdef __cplusplus
}
#endif

#endif
