	IDEAL
	JUMPS
	MODEL LARGE, C
	P386

	DATASEG

; The following flag is incremented by the handler so that the
; application program can check for the success of a division.  The
; program must see to that the flag is cleared before the next division
; that should be checked.  This can be accomplished by the use of a
; function like div0Error() defined in DIV0.H

div0Flag	DW	0

	CODESEG

	PUBLIC C div0Handler, div0Flag


; This is an experimental division by zero fault handler for 386 in REAL
; or VIRTUAL86 modes.  It will NOT work in protected mode without
; modifications.
;
; When an interrupt 0 occurs, this handler will clear the division result
; and remainder registers according to the size of the operation
; (8-, 16- or 32-bit).
;
; The hard part is to calculate how large the faulting (I)DIV instruction
; is, so that we can let the program execute normally from the next
; instruction upon IRET.  Because the handler only knows the address of
; the (I)DIV instruction, we must manually decode the instruction to
; find its length and operand size.
;
; This handler DOES handle:
;  - the 16/32 bit operand size toggle prefix (66h)
;
; This handler does NOT yet handle:
;  - the 16/32 bit address size toggle prefix (67h)
;  - the segment override prefices (CS:, DS:, ES:, FS:, GS:)
; None of these mean anything in front of a (I)DIV anyway.

PROC	div0Handler FAR

	sti
	push	bp
	mov		bp, sp
	push	eax
	push	edx
	push	si
	push	ds

	mov		ax, @data
	mov		ds, ax
	inc		[WORD PTR div0Flag]
	lds		si, [bp+2]
	lodsw					; get the first word of the opcode
	cmp		al, 66h			; is there a 32-bit opcode prefix?
	jne		SHORT @@not32
	xor		eax, eax
	mov		[DWORD PTR bp-4], eax	; clear eax & edx to be returned
	mov		[DWORD PTR bp-8], eax

	inc		[WORD bp+2]		; skip the prefix
	mov		ah, [ds:si]		; get the mod-r/m byte
	jmp		SHORT @@bytediv

@@not32:
	mov		[WORD PTR bp-4], 0	; clear ax to be returned
	test		al, 1			; is it a WORD divide?
	jz		SHORT @@bytediv
	mov		[WORD PTR bp-8], 0	; clear dx to be returned
@@bytediv:
	and		ah, 0c0h		; check the mod-r/m byte:
	cmp		ah, 0c0h		; is the divisor a register?
	je		SHORT @@reg16
	inc		[WORD bp+2]		; skip 4 bytes
	inc		[WORD bp+2]
@@reg16:
	inc		[WORD bp+2]		; skip 2 bytes
	inc		[WORD bp+2]

@@done:
	pop		ds			; we're done, just clean up
	pop		si			; and pray... :-)
	pop		edx
	pop		eax
	pop		bp
	iret

ENDP	div0Handler

END
