/*
 *mega2.c -- Apple ][ soft switches->UNIX emulation for Apple ][ Emulator
 *(C) 1989 Ben Koning [556498717 408/738-1763 ben@apple.com]
 */

#include <stdlib.h>
#include <stdio.h>
#include <sys/file.h>
#include "apple.h"
#import "BBCVdu.h"
#import "Memory.h"
#import "Keyboard.h"

extern id screen;
extern id memory;
extern id keyboard;
/*
 * Emulation globals:
 */


BYTE MegaQuitDetect = 0;  /* Set if user requests to quit        */

void OsByte();
void OsWord();
void Osword_0();
void OsFile();
void OsFsc();
void OsWrch();
void OsRdch();
void Interupt();
void _push_();
BYTE _pull_();

#define MegaPutMem(ADDR,VAL) [memory put:ADDR val:VAL]
#define MegaGetMem(ADDR)     [memory get:ADDR]

#define DOERROR(ERVAL,STRING) {	int i; \
				MegaPutMem(0x100,0);\
				MegaPutMem(0x101,ERVAL);\
				for(i=0;i<strlen(STRING);i++)\
				    MegaPutMem(0x102+i,STRING[i]);\
				MegaPutMem(0x102+i,0);\
				PPC=0x100;\
				}
void os(value)
BYTE value;
{
switch (value)
{ 
case 0xDD: OsFile(); break;
case 0x1E: OsFsc(); break;
case 0xEE: OsWrch(); break;
case 0xE0: OsRdch(); break;
case 0xF4: OsByte(); break;
case 0xF1: OsWord(); break;
case 0xFE: Interupt(1); break;
case 0xFF: Interupt(2); break;
default: MegaQuitDetect=1;
	 fprintf(stderr,"Unknown OS call %x\n",value);
	 break;
}
return;
}

void OsWrch()
{
[screen print:A];
}

void OsRdch()
{
A=[keyboard readChar];
if(A==-1)
	P=P-2;
}

void OsByte()
{
if (A>=166) 
	{

	}

else
	switch (A)
	{
	case 0x00: DOERROR(0,"OS1.2(ish)"); break;
	case 0x7E: X=0xFF; MegaPutMem (0xFF, 0); break;
	case 0x82: X=0; Y=0x08; break;
	case 0x83: X=0; Y=0x08; break;
	case 0x84: X=0; Y=0x80; break;
	default: fprintf(stderr,"Unknown OSBYTE call %d\n",(int)A);
	    MegaQuitDetect=1;
	    break;
	};

return;
}

void OsWord()
{
switch (A)
{
case 0: Osword_0(); break;
default: fprintf(stderr,"Unknown OSWORD call %x\n",A);
	MegaQuitDetect=1;
	break;
}
return;
}

void Osword_0()
{
int block;
int strstart;
int strl;
char temp[256];

block=X+Y*256;
strstart= MegaGetMem(block)+MegaGetMem(block+1)*0x100;

gets(temp);
for(strl=0;temp[strl]!=0; strl++)
    {
    A=temp[strl];
    OsWrch();
    MegaPutMem(strstart+strl,temp[strl]);
    }

A=13;
OsWrch();
A=10;
OsWrch();

strl=strlen((char *)temp);
Y=strl; /* +1*/
P &= ~0x01;
MegaPutMem(strstart+strl,0x0D);
}

void OsFile()
{
int block;
int FnAdr;
int LoAdr;
int ExAdr;
int StAdr;
int EnAdr;
char string[256];
int i;
char ch;
int fp;


block=X+Y*256;
   
FnAdr=MegaGetMem(block+0x00)+MegaGetMem(block+0x01)*0x100;
while(MegaGetMem(FnAdr)==' ' || MegaGetMem(FnAdr)=='\"')
    FnAdr++;	
for(i=0;i<256 && MegaGetMem(FnAdr+i)!=0x0D && MegaGetMem(FnAdr+i)!=' ' && MegaGetMem(FnAdr+i)!='\"' ;i++)
    string[i]=MegaGetMem(FnAdr+i);
string[i]=0;

LoAdr=MegaGetMem(block+0x02)+MegaGetMem(block+0x03)*0x100;
ExAdr=MegaGetMem(block+0x06)+MegaGetMem(block+0x07)*0x100;
StAdr=MegaGetMem(block+0x0A)+MegaGetMem(block+0x0B)*0x100;
EnAdr=MegaGetMem(block+0x0E)+MegaGetMem(block+0x0F)*0x100;
	

switch(A)
{
    case 0x00:
	    {
	    fp = open (string, O_WRONLY|O_CREAT,0600);
	    if(fp<=0)
		{
		DOERROR(0,"Cant open File");
		return;
		}
		
	    sprintf(string,"%x %x            ",LoAdr,ExAdr);
	    write(fp,string,12);
	    
	    for(i=StAdr;i<EnAdr;i++)
		{
		ch=MegaGetMem(i);
		write(fp,&ch,1);
		}
	    close(fp);
	    }
	    break;
    case 0xFF:
	    {
	    fp = open (string, O_RDONLY);
	    if(fp<=0)
		{
		DOERROR(0,"File Not Found");
		return;
		}

	    /* Get header Block */
	    read(fp,string,12);
	    if((ExAdr & 0xff)!=0)
		{
		sscanf(string,"%x %x",&LoAdr,&ExAdr);
		}
 
	    for (i = LoAdr;   i <= 0xffff && read(fp,&ch,1)==1; i++)
		MegaPutMem(i,ch);
	    (void)close (fp);
	    }
	    break;
default: fprintf(stderr,"Unknown OSFILE call %x\n",A);
	MegaQuitDetect=1;
	break;
}
return;
}

void OsFsc()
{
switch(A)
    {
    case 3: DOERROR(254,"Bad Command");
	break;
    case 4:
	{ /* *RUN */
	int FnAdr;
	int LoAdr;
	int ExAdr;
	char ch;
	char string[256];
	int fp;
	int i;
	
	FnAdr=X+Y*256;
   
	while(MegaGetMem(FnAdr)==' ' || MegaGetMem(FnAdr)=='\"')
	    FnAdr++;	
	for(i=0;i<256 && MegaGetMem(FnAdr+i)!=0x0D && MegaGetMem(FnAdr+i)!=' ' && MegaGetMem(FnAdr+i)!='\"' ;i++)
	    string[i]=MegaGetMem(FnAdr+i);
	string[i]=0;
	
	fp = open (string, O_RDONLY);
	if(fp<=0)
	    {
	    DOERROR(0,"File Not Found");
	    return;
	    }

	/* Get header Block */
	read(fp,string,12);
	    sscanf(string,"%x %x",&LoAdr,&ExAdr);

	for (i = LoAdr;   i <= 0xffff && read(fp,&ch,1)==1; i++)
	    MegaPutMem(i,ch);
	(void)close (fp);
	PPC=ExAdr;
	return;
	}
    case 5:
    	{ /* Catalougue */
	int p[2];
	int pid;

	pipe(p);
	pid=fork();
	if(pid==0)
	    {
	    /* Child */
	    close(stdout);
	    dup2(p[1],1);
	    execl("/bin/ls","ls","-C",0);
	    puts("Failed");
	    exit(-1);
	    }
	else
	    {
	    char ch;
	    /* Parent */
	   
	    close(p[1]);
	    
	    while(read(p[0],&ch,1)!=0)
		{
		if(ch==10)
			{
			A=13;
			OsWrch();
			}
		A=ch;
		OsWrch();
		}    
	    close(p[0]);
	    }
	return;
	}
    case 8: return;
    default:fprintf(stderr,"Unknown OSFSC call %x\n",A);
	MegaQuitDetect=1;
	break;
    }
}

void Interupt(level)
int level;
{
if(level==1)
    {
    PPC=MegaGetMem(0x206)+MegaGetMem(0x207)*0x100;
    }
else if(level==2)
    {
    int Madder;
    Madder=_pull_ ();
    Madder+=_pull_ ()*0x100;
    _push_(Madder % 0x100);
    _push_(Madder & 0xff);
    
    Madder++;
    MegaPutMem(0xfd,Madder & 0xff);
    MegaPutMem(0xfe,Madder % 0x100);
    A=MegaGetMem(0xfc);
    PPC=MegaGetMem(0x202)+MegaGetMem(0x203)*0x100;
    }
}



