/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>
#include "6845crtc.h"
#include "bbc.h"
#include "sysvia.h"
#include "main.h"
#include "speech.h"
#include "matrix.h"
#include "sound.h"
#include "modex.h"
#include "mode7c.h"
#include "modexc.h"

#define ROWTIME 128
#define EXTRAROWTIME 64

int DrawEveryXFrames=2;
int DoScanLines=0;

extern BYTE TeleTextModeOn;

extern WORD ScreenStartAddress;
extern WORD CursorStartAddress;
extern WORD ScreenStart;

extern unsigned long TotalClockCycles;
extern int    CyclesToGo,OriginalCyclesToGo;
extern BYTE   OldGraphicVideoMode,GraphicVideoMode;
extern BYTE   VerticalTotalInCharacters,VerticalSyncPosition,
              ScanLinesInACharacterRow,CharacterRowsToDisplay,
              ScreenWidthInMemoryBytes,LinesToSkipFromScreenTop;


static BYTE LastVerticalTotalInCharacters,LastVerticalSyncPosition,
            LastScanLinesInACharacterRow,LastCharacterRowsToDisplay,
            LastScreenWidthInMemoryBytes,LastLinesToSkipFromScreenTop;



// 0xffff * 2 = 0x1fffe
#define TIMERWRAPVALUE 0x20000

// only 16 regs, but 4 are different on reads
static
BYTE ORB,IRB,
     ORA,IRA,
     DDRB, // 0 bit means input, a 1 output
     DDRA, // 0 bit means input, a 1 output
     T1CL, // read = t1 low order counter
     T1CH,
     T1LL,
     T1LH,
     T2CL, // read = t2 low order counter
     T2CH,
     T2LL,
     SR,
     ACR,
     PCR,
     IFR,
     IER=0,

     PortA,PortB; // these variables contain the actual values on the lines...


extern BYTE InterruptPendingFlag;

// for 6845, updated every V-SYNC
extern BYTE CursorOnFlag,CursorBlinkCounter,DefaultCursorBlinkingCounter;
extern BYTE RegisterValues6845[NUMREGS6845];


// these values are multiplied by 2, so they can be decremented at 2MHz
static int Timer1,Timer2;
int VerticalSYNCTimer;

static BYTE SetInterruptOnTimer2;

static BYTE LatchNOTEnabled[8]={ 1,1,1,1,1,1,1,1 };
// static BYTE LatchData[8];

static WORD ScreenStartArray[]= { 0x4000,0x6000,0x3000,0x5800 };
static BYTE ScreenStartIndex= 0;
WORD ScreenStart;

static int DefaultVSYNCValue,VSYNCCount,VSYNCPhase,VerticalRowTimer;
// #define DEFAULT_VERTICALSYNC 40000
// 64 cycles to account for interlace alternately added to begining
// and end of screen timings.
// 128 cycles per screen row - giving 312 lines total including V blank

enum VBlankPhaseTypes { VSYNC_Blank, VSYNC_Drawing, VSYNC_VideoBlank };


void ResetSystemVIA()
{
  int Count;
    for (Count=0; Count<8; Count++)
      LatchNOTEnabled[Count]=1;

  DefaultVSYNCValue=40000;
  VSYNCPhase=VSYNC_VideoBlank;
  VerticalSYNCTimer=DefaultVSYNCValue; // let ROM init properly
  VSYNCCount=-1;

  Timer1=TIMERWRAPVALUE;
  Timer2=TIMERWRAPVALUE;
  T1LL=0xff;
  T1LH=0xff;

  PortB=0xf0; // fire button 0 and 1 off and no speech
  IRB=0xf0;

  InterruptPendingFlag=0;
}



BYTE ReadSystemVIA(WORD Address)
{
  BYTE Result;

// ASSUMPTION - all cycles upto the actual read have been done
  SyncClocks();  // its a slow device so sync with it

    switch (Address & 0xf) // now the correct register
    {
      case 0  : Result=ORB & DDRB;
                  if ((ACR & 0x02)==0) // latching disabled
                    Result|=((DDRB ^ 255) & PortB);
                  else // latching enabled
                    Result|=((DDRB ^ 255) & IRB);

                   if ((PCR & 0xe0)==0x20 || (PCR & 0xe0)==0x60) // independant mode
                     IFR&=0xef; // clear bit 4
                   else
                     IFR&=0xe7; // clear bits 3&4

                Result|=0xc0; // no speech frig up
                UpdateClocksAndInterrupts();
                return (Result);
                break;
      case 1  : // IRQ handshaking
                   if ((PCR & 0x0e)==2 || (PCR & 0x0e)==6) // independant mode
                     IFR&=0xfd; // clear bit 1
                   else           
                     IFR&=0xfc; // clear bits 0 & 1
                UpdateClocksAndInterrupts();
                // fall thru
      case 15 :
//                  if (!LatchNOTEnabled[LATCH_SPEECHREAD])
//                    PortA=ReadSpeech();

                  if ((ACR & 0x01)==0) // latching disabled
                    Result=PortA;
                  else // latching enabled
                    Result=IRA;
                return (Result);
                break;
      case 2  : return (DDRB);
                break;
      case 3  : return (DDRA);
                break;
      case 4  : UpdateClocksAndInterrupts();
                IFR&=0xbf; // Bit 6 cleared in IFR
                T1CL=(BYTE) (Timer1>>1);
                return (T1CL);
                break;
      case 5  : UpdateClocksAndInterrupts();
                T1CH=(BYTE) (Timer1>>9);
                return (T1CH);
                break;
      case 6  : return (T1LL);
                break;
      case 7  : return (T1LH);
                break;
      case 8  : UpdateClocksAndInterrupts();
                IFR&=0xdf; // bit 5 cleared in IFR
                T2CL=(BYTE) (Timer2>>1);
                return (T2CL);
                break;
      case 9  : UpdateClocksAndInterrupts();
                T2CH=(BYTE) (Timer2>>9);
                return (T2CH);
                break;
      case 10 : IFR&=0xfb; // clear bit 2
                UpdateClocksAndInterrupts();
                return (SR); // SR does nothing
                break;
      case 11 : return (ACR);
                break;
      case 12 : return (PCR);
                break;
      case 13 : // unset/set bit 7 before read
                  if ((IFR & IER & 0x7f)==0)
                    IFR&=0x7f;
                  else
                    IFR|=0x80;
                return (IFR);
                break;

      case 14 : return (128 | IER); // bit 7 always set on read
                break;
    }
  return 0;
}


void WriteSystemVIA(WORD Address,BYTE Value)
{
// ASSUMPTION - all cycles upto the actual write have been done
  SyncClocks();  // its a slow device so sync with it

    switch (Address & 0xf) // now the correct register
    {
      case 0   : ORB=Value;
      NewPortB :

                PortB=(PortB & (DDRB ^ 255)) + (ORB & DDRB);

                LatchNOTEnabled[PortB & 7]=PortB & 8;
                  switch (PortB & 15)
                  {
                    case 0x4 : ScreenStartIndex&=2;
                               ScreenStart=ScreenStartArray[ScreenStartIndex];
                               break;
                    case 0xc : ScreenStartIndex|=1;
                               ScreenStart=ScreenStartArray[ScreenStartIndex];
                               break;

                    case 0x5 : ScreenStartIndex&=1;
                               ScreenStart=ScreenStartArray[ScreenStartIndex];
                               break;
                    case 0xd : ScreenStartIndex|=2;
                               ScreenStart=ScreenStartArray[ScreenStartIndex];
                               break;

                    case 0x6 : CAPSLockOn();
                               break;
                    case 0xe : CAPSLockOff();
                               break;
                    case 0x7 : SHIFTLockOn();
                               break;
                    case 0xf : SHIFTLockOff();
                               break;

                    case 0x0 : // sound write enable enabled
                               WriteSound(PortA);
                               break;
                    case 0x8 : // sound write enable disabled
                               break;
                    case 0x1 : // read select on speech, on
                               break;
                    case 0x9 : // read select on speech, off
                               break;
                    case 0x2 : // write select on speech, on
                               break;
                    case 0xa : // write select on speech, off
                               break;
                    case 0x3 : // keyboard write enable, on
                               PortA=ReadKeyboard(PortA);
                               IRA=PortA;
                               break;
                    case 0xb : // keyboard write enable, off
                               break;
                    default : ;// nothing
                  }

                ModeXScreenWrapRestart=(DWORD) (&AddressSpace[ScreenStart]);
                 
                  if ((PCR & 0xe0)==0x20 || (PCR & 0xe0)==0x60) // independant mode
                    IFR&=0xef; // clear bit 4
                  else
                    IFR&=0xe7; // clear bits 3 & 4
                UpdateClocksAndInterrupts();
                break;

      case 1  : // IRQ handshaking
                   if ((PCR & 0x0e)==2 || (PCR & 0x0e)==6) // independant mode
                     IFR&=0xfd; // clear bit 1
                   else
                     IFR&=0xfc; // clear bits 0 & 1
                UpdateClocksAndInterrupts();
                // fall thru
      case 15 : // same as case 1 - no handshaking interrupt
                ORA=Value;
      NewPortA :
                PortA=(PortA & (DDRA ^ 255)) + (ORA & DDRA);
                  if (!LatchNOTEnabled[LATCH_SOUNDWRITE])
                    WriteSound(PortA);
                  if (!LatchNOTEnabled[LATCH_SPEECHWRITE])
                    WriteSpeech(PortA);
                  if (!LatchNOTEnabled[LATCH_KEYBOARDWRITE])
                  {
                    PortA=ReadKeyboard(PortA);
                    IRA=PortA;
                  }
                break;
      case 2  : DDRB=Value;
                goto NewPortB; // change line status for port
      case 3  : DDRA=Value;
                goto NewPortA; // change line status for port
      case 4  : T1LL=Value;
                break;
      case 5  :   if ((ACR & 0xc0)==0x80) // one shot mode
                  {
                    ORB|=128; // PB7 goes lo (presumably logic 0)
                    PortB=(PortB & (DDRB ^ 255)) + (ORB & DDRB);
                  }
                  else 
                    T1LH=Value;
                UpdateClocksAndInterrupts();
                T1CL=T1LL;
                T1CH=T1LH;
                IFR&=0xbf; // Bit 6 cleared in IFR

                Timer1=(T1CH*256 + T1CL)*2+2; // was +2

                break;
      case 6  : T1LL=Value;
                break;
      case 7  :   if ((ACR & 0xc0)==0x80) // one shot mode
                    return; // no effect in one shot mode
                T1LH=Value;
                break;
      case 8  : T2LL=Value;
                break;
      case 9  : UpdateClocksAndInterrupts();
                T2CH=Value;
                T2CL=T2LL;
                IFR&=0xdf; // clear bit 5

                Timer2=(T2CH*256 + T2CL)*2+2; // was +2

                SetInterruptOnTimer2=TRUE;
                break;
                
      case 10 : IFR&=0xfb; // clear bit 2
                UpdateClocksAndInterrupts();
                SR=Value;
                break;
      case 11 : ACR=Value;
                break;
      case 12 :   if ( ((PCR & 0xe0)==0xc0) && ((Value & 0xe0)==0xe0) )
                  { // pulsed LPSTB high - so fake a lightpen interrupt
                    int PenTimer;

                    UpdateClocksAndInterrupts();
                    PenTimer=DefaultVSYNCValue-VerticalSYNCTimer;

                        if (PenTimer<0x3200) //VerticalSYNCTimer<0x3200)
                          PenTimer=0;
                        else
                          PenTimer-=0x3200;

//                    SetSysCB2(); // a fix?
                    // 128 cycles per screen row...
                    RegisterValues6845[0x10]=((BYTE) (PenTimer>>7) & 0x3f);
                    RegisterValues6845[0x11]=((BYTE) (PenTimer<<1) );
                  }
                PCR=Value;
                break;
      case 13 : Value&=0x7f; // bit 7 cannot be just 'cleared'
                IFR&=(Value ^ 0x7f) ;  // clear 'set' bits
                  if (IFR)
                    IFR|=128;
                UpdateClocksAndInterrupts();
                break;
      case 14 :   if (Value>=128) // setting bits
                    IER|=(Value & 0x7f);
                  else // clearing bits
                    IER&=(Value ^ 0x7f);
                UpdateClocksAndInterrupts();
                break;
    }
}


int SysViaMinClock()
{
#ifdef DEV
  printf("VSYNC : %d, T1=%d, T2=%d\n",VerticalSYNCTimer,Timer1,Timer2);
#endif

    if (Timer1<Timer2)
    {
        if (VerticalSYNCTimer<Timer1)
          return (VerticalSYNCTimer);
        else
          return (Timer1);
    }
    else // timer2<Timer1
    {
        if (VerticalSYNCTimer<Timer2)
          return (VerticalSYNCTimer);
        else
          return (Timer2);
    }
}


void CalcSystemVia(int Cycles)
{
  // GENERATE Interrupts if necessary  
// PB7 goes hi on T1 time out (single shot mode)
// IFR bit set
  static BYTE CurrentDisplayedCharacterRows;

  //decrement Timer1
  Timer1-=Cycles;
    if (Timer1<=0)
    {
        switch (ACR & 0xc0)
        {
           case 0x80 :  // one shot mode
                        ORB&=0x7f; // PB7 goes hi (presumably logic 1)
                        PortB=(PortB & (DDRB ^ 255)) + (ORB & DDRB);
                        // fall thru
           case 0x00 :  Timer1+=TIMERWRAPVALUE;
                        break;

           case 0xc0 :  // continuous mode
                        ORB^=128; // PB7 goes toggles (square wave)
                        PortB=(PortB & (DDRB ^ 255)) + (ORB & DDRB);
                        // fall thru
           case 0x40 :  Timer1+=(((T1LH<<8) + T1LL)<<1);              
                          if (TotalClockCycles % 2==1)
                            Timer1++;
        }
      IFR|=64; // t1 interrupt flag set
    }

  // test timer2 action
    if (ACR & 0x20==0) // one shot mode
    {
     // T2 time out (1 shot mode) disables its interupt
     //decrement Timer2
      Timer2-=Cycles;
        if (Timer2<=0)
        {
          Timer2+=TIMERWRAPVALUE;
            if (SetInterruptOnTimer2)
            {
              IFR|=32; // t2 interrupt flag set
              SetInterruptOnTimer2=FALSE;
            }
        }
    }
/*
    else // pulse counting mode
    {
      // do nothing unless PB6 is pulsed
      // then decrement T2
        if (Timer2<=0 && SetInterruptOnTimer2)
        {
          Timer2+=TIMERWRAPVALUE;
          IFR|=32; // t2 interrupt flag set
          SetInterruptOnTimer2=FALSE;
        }

    }
*/

  //  Decrement VerticalSYNCTimer
  VerticalSYNCTimer-=Cycles;
    if (VerticalSYNCTimer<=0)
    {
        switch (VSYNCPhase)
        {
          case VSYNC_Blank : // calc the screen stuff for this draw
                 
                      LogicalScreen=(DWORD) 0xa0000 + (DWORD) LastLinesToSkipFromScreenTop*80;
                      ModeXScreenStart=DefaultModeXScreenStart;
                      ModeXWrap=DefaultModeXWrap;
                      OldGraphicVideoMode=GraphicVideoMode;

                      CurrentDisplayedCharacterRows=0;
                      VerticalRowTimer=(int) ScanLinesInACharacterRow * ROWTIME;

                      VerticalSYNCTimer+=VerticalRowTimer;
                      VSYNCPhase=VSYNC_Drawing;
                      break;


          case VSYNC_Drawing : // draw character rows

                        if (!TeleTextModeOn && CurrentDisplayedCharacterRows<
                            LastCharacterRowsToDisplay) // do another row
                        {
                          DisplayModeXRow();
                          CurrentDisplayedCharacterRows++;

                          VerticalSYNCTimer+=VerticalRowTimer;
                        }
                        else // start video blanking
                        {
                          VerticalSYNCTimer+=( ((int) LastVerticalSyncPosition-(int) LastCharacterRowsToDisplay) *
                                               (int) ScanLinesInACharacterRow )*ROWTIME+EXTRAROWTIME;
                          VSYNCPhase=VSYNC_VideoBlank;
                        }
                      break;


          // Actually a VSYNC, not just a 'phase' - generate CA1
          case VSYNC_VideoBlank :
                // Screen Update Frequency changed?
                        if (LastVerticalTotalInCharacters!=VerticalTotalInCharacters ||
                            LastScanLinesInACharacterRow!=ScanLinesInACharacterRow ||
                            LastLinesToSkipFromScreenTop!=LinesToSkipFromScreenTop)
                        {
                          LastVerticalTotalInCharacters=VerticalTotalInCharacters;
                          DefaultVSYNCValue=(((int) VerticalTotalInCharacters*
                                              (int) ScanLinesInACharacterRow) +
                                             (int) LinesToSkipFromScreenTop)*ROWTIME+EXTRAROWTIME;
                        }

                        if (TeleTextModeOn)
                          DefaultVSYNCValue=40000;

                // check if bits of screen need blanking (and do blanking)
                        if (LastLinesToSkipFromScreenTop!=LinesToSkipFromScreenTop ||
                            LastCharacterRowsToDisplay!=CharacterRowsToDisplay ||
                            LastScanLinesInACharacterRow!=ScanLinesInACharacterRow ||
                            LastScreenWidthInMemoryBytes!=ScreenWidthInMemoryBytes)
                        {
                          LastLinesToSkipFromScreenTop=LinesToSkipFromScreenTop;
                          LastCharacterRowsToDisplay=CharacterRowsToDisplay;
                          LastScanLinesInACharacterRow=ScanLinesInACharacterRow;
                          LastScreenWidthInMemoryBytes=ScreenWidthInMemoryBytes;

                          ModeXRowSize=80* (ScanLinesInACharacterRow-1);
                    
                          LogicalScreen=(DWORD) 0xa0000;

                            if (!TeleTextModeOn) // THIS IS VERY IMPORTANT
                              ClearModeXScreen(); // this fucks screen regs
                        }

                      VSYNCCount++;

                      if (VSYNCCount % 64==0)
                        AgePalettes();

                      CursorBlinkCounter--;
                        if (CursorBlinkCounter==0)
                        {
                          CursorOnFlag^=1; // toggles between 1(on) and 0(off)
                          CursorBlinkCounter=DefaultCursorBlinkingCounter;
                        }

                        if (TeleTextModeOn || (VSYNCCount % DrawEveryXFrames==0)) 
                        { // do not draw this frame - its interlace/T-Text

                          VerticalSYNCTimer+=DefaultVSYNCValue;
                            
                            if (TeleTextModeOn)
                            {
                                if ((VSYNCCount % DrawEveryXFrames==0))
                                  DisplayMode7Screen(&AddressSpace[ScreenStartAddress],(0x8000-ScreenStartAddress));
                            }
                        }
                        else
                        { // draw this frame
                            if (DoScanLines)
                            {
                                // check here?
                              VerticalSYNCTimer+=( ( ((int) VerticalTotalInCharacters-
                                                      (int) VerticalSyncPosition) *
                                                     (int) ScanLinesInACharacterRow )+
                                                   (int) LinesToSkipFromScreenTop)*ROWTIME;
                              VSYNCPhase=VSYNC_Blank;
                            }
                            else
                            {
                              VerticalSYNCTimer+=DefaultVSYNCValue;
                            
                              DisplayModeXScreen();
                            }
                        }

                        if (TotalClockCycles % 2==1)
                          VerticalSYNCTimer++;
                
                      // if CA1 then IRA=PortA 
                      IFR|=2; // set CA1 interrupt
                      IRA=(PortA & (DDRA ^ 255)) + (ORA & DDRA);

    // generate interrupts if occurred & enabled
    // IFR bit 7 cleared if IFR & 0x7f ==0 || IER==0
        if ((IFR & IER & 0x7f)>0)  // set interrupt flag in IFR
        {
          IFR|=128;
          InterruptPendingFlag=TRUE;
        }
        else // clear interrupt flag in IFR
          IFR&=0x7f;

                      break;
        }
    }
    else
    {

    // generate interrupts if occurred & enabled
    // IFR bit 7 cleared if IFR & 0x7f ==0 || IER==0
        if ((IFR & IER & 0x7f)>0)  // set interrupt flag in IFR
        {
          IFR|=128;
          InterruptPendingFlag=TRUE;
        }
        else // clear interrupt flag in IFR
          IFR&=0x7f;
    }
}


void SetSysCA2(BYTE PositiveFlag)
{
    switch (PCR & 0x0e)
    {
      case 0 :
      case 2 :
                 if (!PositiveFlag)
                 {
                   IFR|=0x1; // set CA2 interrupt
                   UpdateClocksAndInterrupts();
                 }
               break;
      case 4 :
      case 6 :
                 if (PositiveFlag)
                 {
                   IFR|=0x1; // set CA2 interrupt
                   UpdateClocksAndInterrupts();
                 }
               break;
    }
}

void SetSysCB1(BYTE Button1,BYTE Button2)  // EOC from ADC
{ 
  IFR|=0x10; // set CB1 interrupt
    if (Button1)
      PortB&=0xef;
    else
      PortB|=0x10;

    if (Button2)
      PortB&=0xdf;
    else
      PortB|=0x20;

  IRB=(PortB & (DDRB ^ 255)) + (ORB & DDRB);
  UpdateClocksAndInterrupts();
}

// lightpen - never occurs extenally
void SetSysCB2()
{
  IFR|=0x8; // set CB2 interrupt
  UpdateClocksAndInterrupts();
}



void DumpSysVIA(FILE * FileHandle)
{
  fprintf(FileHandle,"ORB = %.2x\n",ORB);
  fprintf(FileHandle,"IRB = %.2x\n",IRB);
  fprintf(FileHandle,"ORA = %.2x\n",ORA);
  fprintf(FileHandle,"IRA = %.2x\n",IRA);
  fprintf(FileHandle,"DDRB = %.2x\n",DDRB);
  fprintf(FileHandle,"DDRA = %.2x\n",DDRA);
  fprintf(FileHandle,"T1CL = %.2x\n",T1CL);
  fprintf(FileHandle,"T1CH = %.2x\n",T1CH);
  fprintf(FileHandle,"T1LL = %.2x\n",T1LL);
  fprintf(FileHandle,"T1LH = %.2x\n",T1LH);
  fprintf(FileHandle,"T2CL = %.2x\n",T2CL);
  fprintf(FileHandle,"T2CH = %.2x\n",T2CH);
  fprintf(FileHandle,"T2LL = %.2x\n",T2LL);
  fprintf(FileHandle,"SR   = %.2x\n",SR);
  fprintf(FileHandle,"ACR  = %.2x\n",ACR);
  fprintf(FileHandle,"PCR  = %.2x\n",PCR);
  fprintf(FileHandle,"IFR  = %.2x\n",IFR);
  fprintf(FileHandle,"IER  = %.2x\n",IER);
  fprintf(FileHandle,"Port A = %.2x  - Port B = %.2x\n",PortA,PortB);
  fprintf(FileHandle,"Timer1 = %d  - Timer2 = %d\n",Timer1,Timer2);
  fprintf(FileHandle,"VSYNC Timer = %d\n",VerticalSYNCTimer);
  fprintf(FileHandle,"DefaultVSYNCValue = %d   VSYNCPhase = %d   VerticalRowTimer = %d",
          DefaultVSYNCValue,VSYNCPhase,VerticalRowTimer);
}
