/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdio.h>
#include "bbc.h"

extern unsigned long TotalClockCycles; // used in dumping sound

// #define __DUMPSOUND__ 1

static WORD SoundFrequency[4];
static BYTE SoundVolume[4];
static BYTE WhiteNoiseEnabled; //0=Periodic noise -  other=white noise
static BYTE NoiseFrequencyControl; // 0 = low
                                   // 1 = medium
                                   // 2 = high
                                   // 3 = tone generator 1 frequency.

static BYTE LastRegisterUpdated;

// Physical sound frequency=4000000/32*frequency sent to chip
// 4000000/32=125000, therefore
// Physical sound  frequency=125000/frequency sent to chip
// range of frequencies sent to chip = 0 to 0x3fff (16383)
// look out for divide by zero

// a volume of 0, means that the sound channel is OFF!


void WriteSound(BYTE Byte)
{
    if ((Byte & 128)==128)
    { // first byte
        switch ((Byte & 0x70))
        {
            // Frequency registers changes
          case 0x00 :
                      LastRegisterUpdated=3;
                      SoundFrequency[LastRegisterUpdated]=Byte & 0xf;
                      break;
          case 0x20 :
                      LastRegisterUpdated=2;
                      SoundFrequency[LastRegisterUpdated]=Byte & 0xf;
                      break;
          case 0x40 :
                      LastRegisterUpdated=1;
                      SoundFrequency[LastRegisterUpdated]=Byte & 0xf;
                      break;

            // noise control;
          case 0x60 : WhiteNoiseEnabled=(Byte & 4); 
                      NoiseFrequencyControl=(Byte & 3);
                      break;

            // Volume registers
          case 0x10 :
                      SoundVolume[3]=(Byte & 0xf)^0xf;
                      break;
          case 0x30 :
                      SoundVolume[2]=(Byte & 0xf)^0xf;
                      break;
          case 0x50 :
                      SoundVolume[1]=(Byte & 0xf)^0xf;
                      break;
          case 0x70 :
                      SoundVolume[0]=(Byte & 0xf)^0xf;
                      break;

		}
    }
    else
    { // second byte
      SoundFrequency[LastRegisterUpdated]&=0xf;
      SoundFrequency[LastRegisterUpdated]|=((Byte & 0x3f)<<4);
    }
#ifdef __DUMPSOUND__
    {
      FILE * FH=fopen("SOUND.TXT","at");
      fprintf(FH,"Byte : %.2x ---> Cycles elapsed %ld",Byte,TotalClockCycles);
      DumpSound(FH);
      fclose(FH);
    }
#endif
}


/* to be called at regular intervals - possibily every 10 V SYNCS?
void OutputSound()
{
    if (WhiteNoiseEnabled) // white noise
    {
      SoundFrequency[0]=rand(0x3fff);
    }
    else // periodic noise - pulses on/off ???
    {
        switch (NoiseFrequencyControl)
        {
          case 0 : SoundFrequency[0]=0;
                   break;
          case 1 : SoundFrequency[0]=0x1ff;
                   break;
          case 2 : SoundFrequency[0]=0x3ff;
                   break;
          case 3 : SoundFrequency[0]=SoundFrequency[3];
                   break;
        }
    }
    // add ADLIB shit here
}
*/

void DumpSound(FILE * FileHandle)
{
  char FreqType[4][12]={ "LOW","MEDIUM","HIGH","LINKED TO 3" };

    if (SoundVolume[3]+SoundVolume[2]+SoundVolume[1]+SoundVolume[0]==0)
    {
      fprintf(FileHandle," **** NO SOUND ****\n");
      return;
    }

  fprintf(FileHandle,"\nChannel 3 frequency %d (%x), Volume %d\n",SoundFrequency[3],SoundFrequency[3],SoundVolume[3]);
  fprintf(FileHandle,"Channel 2 frequency %d (%x), Volume %d\n",SoundFrequency[2],SoundFrequency[2],SoundVolume[2]);
  fprintf(FileHandle,"Channel 1 frequency %d (%x), Volume %d\n",SoundFrequency[1],SoundFrequency[1],SoundVolume[1]);
  fprintf(FileHandle,"Channel 0 frequency %s, Volume %d, Type %s\n",FreqType[NoiseFrequencyControl],
          SoundVolume[0],WhiteNoiseEnabled ? "WHITE NOISE" : "PERIODIC NOISE");
}

