/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include "bbc.h"
#include "6502.h"
#include "sysvia.h"
#include "uservia.h"
#include "key.h"

#include "matrix.h"
#include "mode7c.h"
#include "modexc.h"

extern volatile BYTE Paused;


// debug only
#include "videoula.h"
#include "6502.h"
#include "sound.h"
#include "6845crtc.h"

// below profiles code if uncommented
// #define PROFILECLOCKS 1

// #define __STOP_RAM_CLEARANCE_ON_BREAK__ 1 


unsigned long TotalClockCycles; // lo byte used for random ADC values :)
                                // lo bit used in timer calculations
BYTE InterruptPendingFlag;


int OriginalCyclesToGo=0,CyclesToGo=0;

extern volatile BYTE Running;
extern volatile BYTE Reset;
extern WORD ScreenStartAddress;
extern WORD CursorStartAddress;
extern WORD ScreenStart;

extern BYTE TeleTextModeOn;
extern BYTE GraphicVideoMode;
extern int DrawEveryXFrames;
extern int DoScanLines;


#ifdef PROFILECLOCKS
  static FILE * FileHandle;
#endif


void ResetMachine()
{
    if (TotalClockCycles % 2==1)
      TotalClockCycles--; // remove to lo bit
  ResetVideoULA();
  Reset6502();
  ResetUserVIA();
  ResetSystemVIA();
//  ResetKeyboard();
}

// read/write to slow 1Mhz device takes 2 cycles instead of one
// but an extra cycle may be needed to synchronise the two to start with
// (they may be out of phase - wont both change at the next clock pulse)
void SyncClocks()
{ 
    if (TotalClockCycles % 2==0)
      CyclesToGo-=2;
    else
      CyclesToGo--;
}


void UpdateClocksAndInterrupts()
{ 
  int ExpiredCycles=OriginalCyclesToGo-CyclesToGo;

#ifdef PROFILECLOCKS
  fprintf(FileHandle,"Expired = %d\n",ExpiredCycles);
#endif

  TotalClockCycles+=(unsigned long) ExpiredCycles;
  InterruptPendingFlag=0;
  CalcSystemVia(ExpiredCycles);
  CalcUserVia(ExpiredCycles);

  CyclesToGo=0; // if read/write via timer, force recalculation of cycles to go
  OriginalCyclesToGo=0;
}


static void CalculateCyclesToGo()
{
  int C2=UserViaMinClock();
  CyclesToGo=SysViaMinClock();

    if (C2<CyclesToGo)
      CyclesToGo=C2;

  OriginalCyclesToGo=CyclesToGo;
}


void main(int argc,const char *argv[])
{
  int Ch,Count=1;
    while (Count<=argc)
    {
        if (stricmp(argv[Count],"-scanlines")==0)
          DoScanLines=1;
        else if (strnicmp(argv[Count],"-frameskip",10)==0)
        {
          DrawEveryXFrames=atoi(argv[Count]+10);
            if (DrawEveryXFrames<1)
              DrawEveryXFrames=1;
            else if (DrawEveryXFrames>25)
              DrawEveryXFrames=25;
          DrawEveryXFrames<<=1;
        }
      Count++;
    }

  printf("BBC Model 'B' Emulator - Alpha Version 0.6\n"
         "------------------------------------------\n"
         "(C) 1997 D.C.Devenport\n"
         "Email : DDevenp666@aol.com\n"
         "Snail : 40 High Street\n        Belper\n        Derbyshire\n"
         "        DE56 1GF\n        England\n"
         "---------------------------------------------------------------------\n"
         "Please report any bugs to me (note the problems listed in README.TXT)\n"
         "Updating the screen every %d frames\nScanline drawing %s\n"
         "This might run a wee bit fast on a pentium. (Especially in mode7!)\n\n"
         "For the latest version of this program, check out 'The BBC Lives!' at :\n"
         "www.nvg.unit.no/bbc/bbc.html\n",DrawEveryXFrames,
         DoScanLines ? "Enabled" : "Disabled");


  InitialiseMachine();
  ResetMachine();

  printf("Press any key to go BBC...\n\n");
  Ch=getch();
    while (kbhit()); // release the key

#ifdef PROFILECLOCKS
  FileHandle=fopen("CLOCKS.LOG","wt");
#endif

StillRunning:
  InitKeyboard();

    if (TeleTextModeOn)
      InitMode7();
    else
      InitModeX();

    do
    {
        do
        {
          UpdateClocksAndInterrupts();
          CalculateCyclesToGo();
          Do6502Instructions();
        } while (Running);

        if (Reset>0)
        {
#ifdef __STOP_RAM_CLEARANCE_ON_BREAK__
          // stop memory clearance
          AddressSpace[0x258]=0;
          AddressSpace[0x287]=0;
          WriteShiela(0xfe4e,0xf2);
#endif
          ResetMachine();
          Reset=0;
          Running=1;
        }

        if (Paused)
        {
          while (Paused); // do nothing till released
          Running=1;
        }

    } while (Running);

  TextMode();

// just debugging shite below
//  DumpSysVIA(stdout);
//  DumpSound(stdout);
//  DumpCRTC(stdout);
//  DumpMode2();
//  DumpVideoULA(stdout);
//  Dump6502(stdout);
//  printf("Video Mode %d\n",GraphicVideoMode);

  RemoveKeyboard();  // allow getche to work
  printf("\n(Q)uit or *(L)oad or *(S)ave (any other key returns to the emulator) ? ");
  fflush(stdout);
  Running=TRUE;

  Ch=toupper(getche());
    switch (Ch)
    {
      case 'L' : LoadFile();
                 break;
      case 'S' : SaveFile();
                 break;

    }

    if (Ch!='Q')
      goto StillRunning;


#ifdef PROFILECLOCKS
  fclose(FileHandle);
#endif

 printf("\n\n6502 Processor cycles elapsed = %ld\n\n"
        "BBC 'seconds' elapsed = %ld\n\n",
        TotalClockCycles,TotalClockCycles/2000000);
}

void LoadFile()
{
  FILE * Handle;
  char FName[255];
  WORD StartAddress=0,BytesToRead;

  printf("\nLoad which file ?\n");
  gets(FName);
  Handle=fopen(FName,"rb");
    if (Handle==NULL)
    {
      strcat(FName,".BBC");
      Handle=fopen(FName,"rb");
        if (Handle==NULL)
          printf("\nCould not open file %s\n",FName);
    }

    if (Handle!=NULL)
    {
      printf("\nAt what address (hexadecimal)?\n");
      
      sscanf(gets(FName),"%x",&StartAddress);
        if (StartAddress>0x7fff)
          printf("\nCan't load over a ROM\n");
        else if (StartAddress==0 && strlen(FName)==0)
          printf("\nNot loading at zero page\n");
        else
        {
          BytesToRead=0x7fff-StartAddress;
          printf("\n&%.4x bytes read at &%.4x",
                 fread(&AddressSpace[StartAddress],1,BytesToRead,Handle),
                 StartAddress);
        }
      fclose(Handle);
    }
  printf("\nHit any key..\n");
  fflush(stdout);
  getch();
}


void SaveFile()
{
  FILE * Handle;
  char FName[255];
  WORD StartAddress=0,BytesToSave=0;

  printf("\nSave which file ?\n");
  gets(FName);
  Handle=fopen(FName,"wb");

    if (Handle!=NULL)
    {
      printf("\nFrom what address (hexadecimal)?\n");
      sscanf(gets(FName),"%x",&StartAddress);
      printf("\nHow many bytes (hexadecimal)?\n");
      sscanf(gets(FName),"%x",&BytesToSave);

      fwrite(&AddressSpace[StartAddress],1,BytesToSave,Handle);
      fclose(Handle);
      printf("\nSaved!..\n");
    }
  printf("\nHit any key..\n");
  fflush(stdout);
  getch();
}
