/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <dos.h>
#include <conio.h>
#include "key.h"
#include "bbc.h"
#include "matrix.h"


volatile BYTE Running=1;
volatile BYTE Reset=0;
volatile BYTE Paused=0;

void (__interrupt __far * old_Keyboard_handler) ();


volatile BYTE ScanAdd=0;

/* Check the scancodes for INT 9 interrupt and change keyboard struct flags */
void __interrupt __far Keyboard_handler(void)
{
  register char x;
  register unsigned char ScanCode;
  char BBC_Key=0x90;


  // read keyboard data port
  ScanCode = inp(0x60); // read data port
  x = inp(0x61); // read control port

  outp(0x61, (x | 0x80)); // pulse bit 8 in control port to clear keyboard
  outp(0x61, (x & 0x7f));

  outp(0x20, 0x20); // interrupt ACK

    if (ScanCode==0xe0)
    {
      ScanAdd=128;
      return;
    }
//    else if (ScanCode==0xfa) // ACK (from changing LEDs probably)
//      return;

  x=(ScanCode & 0x80) ^ 0x80; // either 0 or 0x80, 0=released
  ScanCode=(ScanCode & 0x7f) + ScanAdd;
  ScanAdd=0;

    switch (ScanCode)
    {
      case ESCAPEKEY       : BBC_Key=ESC;
                             break;
      case NUMBER1KEY      : BBC_Key=NUM_1;
                             break;
      case NUMBER2KEY      : BBC_Key=NUM_2;
                             break;
      case NUMBER3KEY      : BBC_Key=NUM_3;
                             break;
      case NUMBER4KEY      : BBC_Key=NUM_4;
                             break;
      case NUMBER5KEY      : BBC_Key=NUM_5;
                             break;
      case NUMBER6KEY      : BBC_Key=NUM_6;
                             break;
      case NUMBER7KEY      : BBC_Key=NUM_7;
                             break;
      case NUMBER8KEY      : BBC_Key=NUM_8;
                             break;
      case NUMBER9KEY      : BBC_Key=NUM_9;
                             break;
      case NUMBER0KEY      : BBC_Key=NUM_0;
                             break;
      case MINUSKEY        : BBC_Key=MINUS;
                             break;
      case EQUALSKEY       : BBC_Key=TILDE;
                             break;

      case BACKSPACEKEY    : BBC_Key=DEL;
                             break;
    
      case TABKEY          : BBC_Key=TAB;
                             break;
      case QKEY            : BBC_Key=LET_Q;
                             break;
      case WKEY            : BBC_Key=LET_W;
                             break;
      case EKEY            : BBC_Key=LET_E;
                             break;
      case RKEY            : BBC_Key=LET_R;
                             break;
      case TKEY            : BBC_Key=LET_T;
                             break;
      case YKEY            : BBC_Key=LET_Y;
                             break;
      case UKEY            : BBC_Key=LET_U;
                             break;
      case IKEY            : BBC_Key=LET_I;
                             break;
      case OKEY            : BBC_Key=LET_O;
                             break;
      case PKEY            : BBC_Key=LET_P;
                             break;
      case LBRACEKEY       : BBC_Key=LBRAC;
                             break;
      case RBRACEKEY       : BBC_Key=RBRAC;
                             break;
      case RETURNKEY       : BBC_Key=RET;
                             break;
      case KEYPADENTERKEY  : BBC_Key=RET;
                             break;

      case LEFTALTKEY      :
      case KEYPAD8KEY      :
      case LEFTCTRLKEY     : BBC_Key=CTRL;
                             break;
    
      case AKEY            : BBC_Key=LET_A;
                             break;
      case SKEY            : BBC_Key=LET_S;
                             break;
      case DKEY            : BBC_Key=LET_D;
                             break;
      case FKEY            : BBC_Key=LET_F;
                             break;
      case GKEY            : BBC_Key=LET_G;
                             break;
      case HKEY            : BBC_Key=LET_H;
                             break;
      case JKEY            : BBC_Key=LET_J;
                             break;
      case KKEY            : BBC_Key=LET_K;
                             break;
      case LKEY            : BBC_Key=LET_L;
                             break;
      case SEMICOLONKEY    : BBC_Key=SEMI;
                             break;
      case LQUOTEKEY       : BBC_Key=COLON;
                             break;
      case RQUOTEKEY       : BBC_Key=AT;
                             break;
    
      case LEFTSHIFTKEY    : BBC_Key=SHIFT;
                             break;
      case HASHKEY         : BBC_Key=POUND;
                             break;
    
      case ZKEY            : BBC_Key=LET_Z;
                             break;
      case XKEY            : BBC_Key=LET_X;
                             break;
      case CKEY            : BBC_Key=LET_C;
                             break;
      case VKEY            : BBC_Key=LET_V;
                             break;
      case BKEY            : BBC_Key=LET_B;
                             break;
      case NKEY            : BBC_Key=LET_N;
                             break;
      case MKEY            : BBC_Key=LET_M;
                             break;
      case COMMAKEY        : BBC_Key=COMMA;
                             break;
      case FULLSTOPKEY     : BBC_Key=FSTOP;
                             break;
      case SLASHKEY        : BBC_Key=SLASH;
                             break;
    
      case RIGHTSHIFTKEY   : BBC_Key=SHIFT;
                             break;
      case SPACEKEY        : BBC_Key=SPACE;
                             break;
      case KEYPAD7KEY      :
      case CAPSKEY         : BBC_Key=CLOCK;
                             break;
    
      case F1KEY           : BBC_Key=F1;
                             break;
      case F2KEY           : BBC_Key=F2;
                             break;
      case F3KEY           : BBC_Key=F3;
                             break;
      case F4KEY           : BBC_Key=F4;
                             break;
      case F5KEY           : BBC_Key=F5;
                             break;
      case F6KEY           : BBC_Key=F6;
                             break;
      case F7KEY           : BBC_Key=F7;
                             break;
      case F8KEY           : BBC_Key=F8;
                             break;
      case F9KEY           : BBC_Key=F9;
                             break;
      case F10KEY          : BBC_Key=F0;
                             break;
    
      case NUMLOCKKEY      : BBC_Key=SLOCK;
                             break;

      case KEYPAD0KEY      : BBC_Key=COPY;
                             break;

      case BACKSLASHKEY    : BBC_Key=BSLAS;
                             break;
      case F12KEY          : Reset=x;
                               if (Reset)
                                 Running=0;
                             break;
    
      case UPARROWKEY      : BBC_Key=UARR;
                             break;
      case LEFTARROWKEY    : BBC_Key=LARR;
                             break;
      case RIGHTARROWKEY   : BBC_Key=RARR;
                             break;
      case DOWNARROWKEY    : BBC_Key=DARR;
                             break;

      case RIGHTCTRLKEY    : BBC_Key=CTRL;
                             break;

      case F11KEY          : Running=0;
                             return;

      case SCROLLLOCKKEY   : Paused=x;
                               if (Paused)
                                 Running=0;
                             return;
/*
      case KEYPADSTARKEY   :
      case KEYPAD7KEY      :
      case KEYPAD8KEY      :
      case KEYPAD9KEY      :
      case KEYPADMINUSKEY  :
      case KEYPAD4KEY      :
      case KEYPAD5KEY      :
      case KEYPAD6KEY      :
      case KEYPADPLUSKEY   :
      case KEYPAD1KEY      :
      case KEYPAD2KEY      :
      case KEYPAD3KEY      :
      case KEYPADDELETEKEY :


      case KEYPADSLASHKEY  :
      case RIGHTALTKEY     :
      case HOMEKEY         :
      case PAGEUPKEY       :
      case ENDKEY          :
      case PAGEDOWNKEY     :
      case INSERTKEY       :
      case DELETEKEY       :
*/
      default : return;
    }

    if (BBC_Key!=BREAK)
      BBCKey(x,BBC_Key);

  return;
}

/*
void SetLEDS(BYTE LEDs)
{
//  _disable();
    if (ScanAdd==0)// && (inp(0x61) & 2!=2))
    {
      outp(0x60,0xed);
//        while (inp(0x61) & 2==2) ; // read control port
      outp(0x60,LEDs);
//  _enable();
    }
}
*/

void InitKeyboard()
{
  // set the keyboard interrupt handler / save the old one
  old_Keyboard_handler = _dos_getvect(0x09);
  _dos_setvect(0x09, Keyboard_handler);
}


void RemoveKeyboard()
{
  // set the keyboard interrupt handler / save the old one //
    if (old_Keyboard_handler!=0)
      _dos_setvect(0x09, old_Keyboard_handler);
  old_Keyboard_handler=0;
}
