/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include "bbc.h"
#include "sysvia.h"

//BYTE ADCConversionOn;
//int  ADCTimer;

static BYTE ADCRegs[3];

void WriteADC(WORD Address,BYTE Byte)
{
  BYTE Button1,Button2;
  Address &= 3;
//    if (Address!=0)
//      FatalError("Write only register, Read attempt ADC %4x",Address);

  ADCRegs[0]=(Byte & 0xf);

  ADCRegs[0]|=128; //conversion complete , not busy

  // read joystick here
  // plonk values in reg 1 and 2

  Button1=0; // not pressed
  Button2=0;

  ADCRegs[0]|=((ADCRegs[1] & 0xc0)>>2); // set bits 4 & 5 in status

  SetSysCB1(Button1,Button2); // EOC from ADC
}



BYTE ReadADC(WORD Address)
{
  Address &= 3;
    switch (Address)
    {
      case 0 : return (ADCRegs[0]);
      case 1 : return (ADCRegs[1]);
      case 2 : return (ADCRegs[2] & 0xf0);
    }  
//  FatalError("Read ADC fe%.2x",Address);
  return (0xc0); // some programs read register 3 - which doesn't exist?!
}
