/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <dos.h>
#include <i86.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include "bbc.h"
#include "sb.h"
#include "sinetab.dat"
#include "sbtab.dat"

int SoundBlasterExists=0;

// changing this will need to alter lookup table also
#define PLAYBACK_FREQ 16000
// BUFFERLEN is equal to 16000/50 which gives me a 100Hz interrupt
// very useful - 100 times a second!
#define BUFFERLEN 160

// defaults
static short PortBase=0x220;
static short DMAChannel=1,IRQNumber=7;
static short IRQVectors[] = { -1, -1, 0xa, 0xb, -1, 0xd, -1, 0xf };  // only allow irq 2,3,5 or 7

static char DMAMasking1Register[] = { 0xa, 0xa, 0xa, 0xa };
static char DMAMasking1On[]       = { 0x0 ,0x1, 0x2, 0x3 };  // Port 0xa or 0xd4
static char DMAMasking1Off[]      = { 0x4 ,0x5, 0x6, 0x7 };  // Port 0xa or 0xd4
static char DMAStartRegister[]    = { 0x0 ,0x2, 0x4, 0x6 };
static char DMALengthRegister[]   = { 0x1 ,0x3, 0x5, 0x7 };
static char DMAPageRegister[]     = { 0x87,0x83,0x81,0x82};
static char DMAByteWordFlipFlop[] = { 0xc, 0xc, 0xc, 0xc };
static char DMAMODERegister[]     = { 0xb, 0xb, 0xb, 0xb  };
static char MODERegisterRead[]    = { 0x58,0x59,0x5a,0x5b }; // DMA auto init
static char DMARemaining[]        = { 0x1, 0x3, 0x5, 0x7, 0xc2,0xc6,0xca,0xce };  // Remaing len-1 of DMA xfer

static void (__interrupt * old_IRQ_handler) ();
static BYTE OldIRQMask;

static char * SoundBuffer; // DOS Memory buffer for DMA playback
static char BufferHi,BufferLo;

unsigned int ChannelOn[4],Vol[4]={ 15,0,0,0 },
             Freq[4]={ 1,0x3ff,0x3ff,0x3ff },Periodic=WHITE_NOISE;
WORD SineOff[4];





#define DSP_MIXERADDRESS      (PortBase+0x4)
#define DSP_MIXERDATA         (PortBase+0x5)
#define DSP_RESET             (PortBase+0x6)
#define DSP_ADLIB_STATUS      (PortBase+0x8)
#define DSP_ADLIB_INDEX       (PortBase+0x8)
#define DSP_ADLIB_DATA        (PortBase+0x9)
#define DSP_READDATA          (PortBase+0xa)
#define DSP_COMMAND           (PortBase+0xc)
#define DSP_WRITEDATA         (PortBase+0xc)
#define DSP_WRITEBUFFERSTATUS (PortBase+0xc)
#define DSP_READBUFFERSTATUS  (PortBase+0xe)

#define SBFINDLOOP 1000

static void __interrupt __far IRQ_Handler();


static short htoi(char * S)
{
  char NumStr[]="0123456789ABCDEF";
  short Num=0;

  S++; // skip the letter

    while ( strchr(NumStr,*S)!=NULL && *S!=0)
    {
      Num=(Num<<4)+((long) strchr(NumStr,*S)-(long) &NumStr);
      S++;
    }
  return (Num);
}


static char * AllocateDOSMem(int Size)
{
  union  REGS  regs;
  struct SREGS sregs;

  // DPMI call 100h allocates DOS memory
  memset(&sregs,0,sizeof(sregs));
  regs.w.ax=0x0100;
  regs.w.bx=(Size>>4); //allocates in 16 byte chunks
  int386x( 0x31, &regs, &regs, &sregs);

  return ((char *) ((regs.w.ax)<<4));
}

static void LockDOSMem(char * Ptr,unsigned int Size)
{
  union  REGS  regs;
  struct SREGS sregs;

  // DPMI call 600h locks memory
  memset(&sregs,0,sizeof(sregs));
  regs.w.ax=0x0600;
  regs.w.bx=(((unsigned int) Ptr)>>16) & 0xffff;
  regs.w.cx=((unsigned int)Ptr) & 0xffff;

  regs.w.si=(Size>>16) & 0xffff;
  regs.w.di=(Size) & 0xffff;
  int386x( 0x31, &regs, &regs, &sregs);


}


void InitSoundBlaster()
{
  char * BlasterStr=getenv("BLASTER");

  printf("Looking for sound blaster.\n");
    if (BlasterStr==NULL)
    {
      printf("BLASTER environment variable not found.\n");
      return;
    }
  printf("BLASTER STRING = %s\n",BlasterStr);

  strupr(BlasterStr);

  PortBase =    htoi( strchr(BlasterStr, 'A'));
  DMAChannel  = htoi( strchr(BlasterStr, 'D'));
  IRQNumber =   htoi( strchr(BlasterStr, 'I'));

  printf("BLASTER Port=%.4x DMA=%.2x IRQ=%.2x\n",PortBase,DMAChannel,IRQNumber);

    if (DMAChannel<0 || DMAChannel>3)
    {
      printf("ILLEGAL DMA CHANNEL\n");
      return;
    }
    
    if (IRQNumber<0 || IRQNumber>7 || IRQVectors[IRQNumber]==-1)
    {
      printf("ILLEGAL INTERRUPT NUMBER\n");
      return;
    }

  SoundBuffer=AllocateDOSMem(65536*2); // two 64K pages (I know its wasteful!)
  LockDOSMem(SoundBuffer,65536*2); // two 64K pages (I know its wasteful!)
    if (SoundBuffer==NULL)
    {
      printf("Can't create sound buffer\n");
      return;      
    }
  SoundBuffer=(char *) (((unsigned long) SoundBuffer+0xffff) & 0xf0000);
  // SoundBuffer is now at beginning of 64K page now

  printf("Sound buffer at %.x\n",SoundBuffer);

  BufferLo=((BUFFERLEN-1) & 0xff);
  BufferHi=(((BUFFERLEN-1)>>8) & 0xff);

  memset(SoundBuffer,128,BUFFERLEN*2);// fill buffer with no sound...

  ResetDSP();

  // set the IRQ handler / save the old one //
  old_IRQ_handler = _dos_getvect(IRQVectors[IRQNumber]);
  _dos_setvect(IRQVectors[IRQNumber],  IRQ_Handler);

  // Save old interrupt status and unmask mine
  OldIRQMask = inp(0x21);
  outp(0x21,OldIRQMask & ((1 << IRQNumber)^0xff));

  // start playing the sample - till the program quits
   StartSample();
}


static void StartSample()
{
  outp(DMAMasking1Register[DMAChannel],DMAMasking1Off[DMAChannel]);

  // ready DMA for value setup
  outp(DMAByteWordFlipFlop[DMAChannel], 0x00); // BYTEWORD flipflop to zero

  // set DMA values
  outp(DMAMODERegister[DMAChannel],   MODERegisterRead[DMAChannel]);
  outp(DMAStartRegister[DMAChannel],  (unsigned char) ((int)SoundBuffer & 0xff));
  outp(DMAStartRegister[DMAChannel],  (unsigned char) (((int)SoundBuffer>>8) & 0xff));
  outp(DMAPageRegister[DMAChannel],   (unsigned char) (((int)SoundBuffer>>16) & 0xff));
  outp(DMALengthRegister[DMAChannel], (unsigned char) ((BUFFERLEN*2)-1) & 0xff);
  outp(DMALengthRegister[DMAChannel], (unsigned char) (((BUFFERLEN*2)-1)>>8) & 0xff);

  // DMA on
  outp(DMAMasking1Register[DMAChannel],DMAMasking1On[DMAChannel]);

  // set buffer size
  DSPWrite(0x48);
  DSPWrite(BufferLo);
  DSPWrite(BufferHi);

  // DSP auto init DMA mode on!
  DSPWrite(0x1c);
}


static void __interrupt __far IRQ_Handler()
{
  inp(DSP_READBUFFERSTATUS); // ack 8-bit SB interrupt

  MixSounds(1);

  outp( 0x20,0x20); // re-enable lower level interrupts
}


void RemoveSoundBlaster()
{
  char IRQ;

    if (!SoundBlasterExists) 
      return;                // nothing to remove!

  // stop the sample
  _disable();
  DSPWrite(0xd0); // Turn off DSP DMA

  DSPWrite(0xda); // Exit DMA

  DSPWrite(0xd0); // Turn off DSP DMA

  DSPWrite(0xd3); // Turn off speaker

  IRQ = inp(0x21); // Restore interrupt mask bit
    if (OldIRQMask & (1 << IRQNumber))
      IRQ|=(1 << IRQNumber);
    else
      IRQ&=((1 << IRQNumber)^0xff);
    outp(0x21,IRQ);
    _dos_setvect(IRQVectors[IRQNumber],  old_IRQ_handler);
  _enable();

}


static void ResetDSP()
{
  int C;
  int Major,Minor;
  unsigned long Rate;

  outp(DSP_RESET,1);
    for (C=0;C<16;C++) // repeat for a delay of at least 3usec
      inp (DSP_RESET);
  outp(DSP_RESET,0);

    for(C=0;C<SBFINDLOOP;C++) // hang around for about 100usec to allow reset
    {
        if (ReadDSP()==0xAA)
          break;
    }
    if(C==SBFINDLOOP)
    { // Either no sound blaster/wrong IO port
      printf("Sound Blaster hardware not found\n");
      return;
    }

  printf("Sound Blaster hardware OK\n");

  DSPWrite(0xd1);  // DAC Speaker on for output

  // Should be number of channels * Frequency below
//  Rate=65536UL - (256000000UL/PLAYBACK_FREQ);
  Rate=256 - (1000000/PLAYBACK_FREQ);

  // set sampling rate
  DSPWrite(0x40);
  DSPWrite((char) (Rate & 0xff));

  // Get SB version number
  DSPWrite(0xe1);
  Major=ReadDSP();
  Minor=ReadDSP();
  printf("Sound Blaster Version %d.%d\n",Major,Minor);
    if (Major<2)
    {
      printf("You need at least a version 2 Sound Blaster for sound");
      return;
    }

  SoundBlasterExists=1;
}


static void DSPWrite(const char Value)
{
  // wait for DSP buffer to be empty
    while ( (inp(DSP_WRITEBUFFERSTATUS) & 0x80) ) ;

  outp(DSP_COMMAND,Value);
}


static int ReadDSP()
{
  // wait for data to read
    while ( (inp(DSP_READBUFFERSTATUS) & 0x80)==0 ) ;

  return ( inp(DSP_READDATA) );
}


void MixSounds(int WriteToNotPlaying)
{
  unsigned int Pos;
  int C,Channel,Offset;
  WORD Value,Off,Volume,BufferLen;
  char * P;

  // mix sound channels into the buffer half just played
  Pos=inp(DMARemaining[DMAChannel]);
  Pos+=(inp(DMARemaining[DMAChannel])<<8);
    if (Pos<BUFFERLEN)
    {
      BufferLen=BUFFERLEN-Pos;
      Offset=0;
    }
    else
    {
      BufferLen=(BUFFERLEN<<1)-Pos;
      Offset=BUFFERLEN;
    }

    if (WriteToNotPlaying)
      BufferLen=BUFFERLEN;
    else
      Offset=BUFFERLEN-Offset;


  memset(SoundBuffer+Offset,128,BufferLen);// fill buffer with no sound...

  Channel=0;

    if (ChannelOn[Channel])
    {
       WORD OldOff=(Off>>8)+1;
       BYTE Data;

       P=(char *)((unsigned int) SoundBuffer+Offset);
       Value=SBSampleOffsetTable[Freq[Channel]];
       Off=SineOff[Channel];
       Volume=Vol[Channel];

         if (ChannelOn[Channel]==WHITE_NOISE)
         {
             for (C=0; C<BufferLen; C++)
             {
//                if (OldOff!=(Off>>8))
                {
                  Data=SineDataTable[Volume][(rand() % 256) & 0xAA];
//                  OldOff=(Off>>8);
                }

               *P=*P+Data;
               P++;
               Off+=Value;
             }
         }
         else // Periodic noise
         {
             for (C=0; C<BufferLen; C++)
             {
/*
                if (OldOff!=(Off>>8))
                {
                  Data=SineDataTable[Volume][(rand() % 128) & 0xf0];
                  OldOff=(Off>>8);
                }

               *P=*P+Data;
*/
               *P=*P+SineDataTable[Volume][(Off>>8) & 0x7f];
               P++;
               Off+=Value;
             }
         }
       SineOff[Channel]=Off;
    }


    for (Channel=1; Channel<4; Channel++)
    {
        if (ChannelOn[Channel])
        {
           P=(char *)((unsigned int) SoundBuffer+Offset);
           Value=SBSampleOffsetTable[Freq[Channel]];
           Off=SineOff[Channel];
           Volume=Vol[Channel];
             for (C=0; C<BufferLen; C++)
             {
               *P=*P+SineDataTable[Volume][(Off>>8)];
               P++;
               Off+=Value;
             }
          SineOff[Channel]=Off;
        }
    }
}
