/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>

#include "bbc.h"
#include "modex.h"

static struct Mode03PaletteType
{
  const char * PaletteAddress;
  int Age;
  BYTE CurrentPalette[NUMCOLS];
} Mode03PalTable[TABLESIZE]=
{
  { (char *) 0xaa600, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaa700, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaa800, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaa900, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaaa00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaab00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaac00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaad00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaae00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xaaf00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } }
};

static int    Mode03TableOffset=0;

void ClearMode03Colours()
{
  int CountX,CountY;

    for (CountY=0; CountY<TABLESIZE; CountY++)
    {
        for (CountX=0; CountX<16; CountX++)
          Mode03PalTable[CountY].CurrentPalette[CountX]=17;
      Mode03PalTable[CountY].Age=0;
    }
  Mode03TableOffset=0;
}


void AgeMode03()
{
  int CountY;
    for (CountY=0; CountY<TABLESIZE; CountY++)
       Mode03PalTable[CountY].Age>>=1;
}


void DisplayMode0Screen()
{
// mode1, 0xff mask, access to all planes

    if (OldColoursChanged)
      Mode03ChangeColours();

  Mode03PalTable[Mode03TableOffset].Age++;
  ModeXLookup=(DWORD) Mode03PalTable[Mode03TableOffset].PaletteAddress;
  Plot20K();
}


void DisplayMode0Row()
{
// mode1, 0xff mask, access to all planes

    if (OldColoursChanged)
      Mode03ChangeColours();

  Mode03PalTable[Mode03TableOffset].Age++;
  ModeXLookup=(DWORD) Mode03PalTable[Mode03TableOffset].PaletteAddress;
  Plot80Row();
}


void DisplayMode3Screen()
{
// mode1, 0xff mask, access to all planes

    if (OldColoursChanged)
      Mode03ChangeColours();

  Mode03PalTable[Mode03TableOffset].Age++;
  ModeXLookup=(DWORD) Mode03PalTable[Mode03TableOffset].PaletteAddress;
  PlotMode3();
}



void Mode03ChangeColours() // mode 0
{
  char * ScreenPtr;
  int CountY,Count,MinAge,OldestOffset;

  MinAge=512;
  OldestOffset=0;
    for (CountY=0; CountY<TABLESIZE; CountY++)
    {
        if (Mode03PalTable[CountY].CurrentPalette[0]==LogicalColours[0] &&
            Mode03PalTable[CountY].CurrentPalette[8]==LogicalColours[8])
        {
          Mode03TableOffset=CountY;
          return;
        }

        if (Mode03PalTable[CountY].Age<MinAge)
        {
          MinAge=Mode03PalTable[CountY].Age;
          OldestOffset=CountY;
        }
    }

  Mode03TableOffset=OldestOffset;
// ScreenPtr now points the to screen table
  ScreenPtr=Mode03PalTable[Mode03TableOffset].PaletteAddress;
  Mode03PalTable[Mode03TableOffset].CurrentPalette[0]=LogicalColours[0];
  Mode03PalTable[Mode03TableOffset].CurrentPalette[8]=LogicalColours[8];

  outpw(0x03ce,0x0205); //  write mode 2

  *ScreenPtr=LogicalColours[0]; // first byte=colour 0

  Byte=*(ScreenPtr++);// load latches with colour 0
                      // (they stay the same thru out)

  outp(0x3ce,8); // bit mask index

    for (Count=1;Count<256;Count++)
    {
      outp(0x03cf,Count); // bit mask data
      *ScreenPtr=LogicalColours[8]; // stick values in other pixels
      ScreenPtr++;
    }
  // bit mask already 0xff
  outpw(0x03ce,0x0105); // write mode 1
  OldColoursChanged=FALSE;
}
