/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1997. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (DDevenp666@aol.com)                          */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include "sb.h"
#include "bbc.h"
#include "6502.h"
#include "sysvia.h"
#include "uservia.h"
#include "key.h"
#include "pcx.h"

#include "matrix.h"
#include "mode7c.h"
#include "modexc.h"
#include "sound.h"

// debug only
#include "videoula.h"
#include "6502.h"
#include "sound.h"
#include "6845crtc.h"

// below profiles code if uncommented
// #define PROFILECLOCKS 1

// #define __STOP_RAM_CLEARANCE_ON_BREAK__ 1 


int InterruptPendingFlag;
int OriginalCyclesToGo=0,CyclesToGo=0;

unsigned long TotalClockCycles; // lo byte used for random ADC values :)
                                // lo bit used in timer calculations


#ifdef PROFILECLOCKS
  static FILE * FileHandle;
#endif


void ResetMachine()
{
    if (TotalClockCycles % 2==1)
      TotalClockCycles--; // remove to lo bit
  ResetVideoULA();
  ResetUserVIA();
  ResetSystemVIA();
  Reset6502();
//  ResetKeyboard();
}

// read/write to slow 1Mhz device takes 2 cycles instead of one
// but an extra cycle may be needed to synchronise the two to start with
// (they may be out of phase - wont both change at the next clock pulse)
void SyncClocks()
{ 
    if (TotalClockCycles % 2==0)
      CyclesToGo-=2;
    else
      CyclesToGo--;
}



void UpdateClocksAndInterrupts()
{ 
  int ExpiredCycles=OriginalCyclesToGo-CyclesToGo;

#ifdef PROFILECLOCKS
  fprintf(FileHandle,"Expired = %d\n",ExpiredCycles);
#endif

    if (ExpiredCycles>0)
    {
      TotalClockCycles+=(unsigned long) ExpiredCycles;
    
      CalcSystemVia(ExpiredCycles);
      CalcUserVia(ExpiredCycles);
      InterruptPendingFlag=UserInterruptPendingFlag+SystemInterruptPendingFlag;
    }
   // if read/write via timer, force recalculation of cycles to go
   // ALSO, if I flag becomes zero
  CyclesToGo=0;
  OriginalCyclesToGo=0;
}


static void CalculateMinimumCyclesToGo()
{
  int C2=UserViaMinClock();

  CyclesToGo=SysViaMinClock();

    if (C2<CyclesToGo)
      CyclesToGo=C2;

  OriginalCyclesToGo=CyclesToGo;
}


void main(int argc,const char *argv[])
{
  int Ch,Count=1,UseSound=0;
  int DontClearRAM=0;

    while (Count<=argc)
    {
        if (stricmp(argv[Count],"-scanlines")==0)
          DoScanLines=1;
        else if (strnicmp(argv[Count],"-frameskip",10)==0)
        {
          DrawEveryXFrames=atoi(argv[Count]+10);
            if (DrawEveryXFrames<1)
              DrawEveryXFrames=1;
            else if (DrawEveryXFrames>25)
              DrawEveryXFrames=25;
          DrawEveryXFrames<<=1;
        }
        else if (stricmp(argv[Count],"-sb")==0)
          UseSound=1;
        else if (stricmp(argv[Count],"-noclear")==0)
          DontClearRAM=1;
        else if (stricmp(argv[Count],"-doublebuffer")==0)
          DoubleBuffering=1;

      Count++;
    }

  printf("BBC Model 'B' Emulator - Alpha Version 0.99\n"
         "-------------------------------------------\n"
         "(C) 1997 D.C.Devenport\n"
         "Email : DDevenp666@aol.com\n"
         "Snail : 40 High Street\n        Belper\n        Derbyshire\n"
         "        DE56 1GF\n        England\n"
         "---------------------------------------------------------------------\n"
         "Please report any bugs to me (note the problems listed in README.TXT)\n"
         "Updating the screen every %d frames\n"
         "Scanline drawing %s\n"
         "Double buffering %s\n"
         "This might run a wee bit fast on a pentium. (Especially in mode7!)\n\n"
         "For the latest version of this program, check out 'The BBC Lives!' at :\n"
         "members.aol.com/ddevenp666/bbc.html and also\n"
         "www.nvg.unit.no/bbc/bbc.html\n"
         "Press any key\n",DrawEveryXFrames,
         DoScanLines ? "Enabled" : "Disabled",
         DoubleBuffering ? "Enabled" : "Disabled");
  Ch=getch();
    if (UseSound)
       InitSoundBlaster();
  InitialiseMachine();
  ResetMachine();
  printf("Press any key to go BBC...\n\n");
  Ch=getch();

  while (kbhit()); // release the key
    if (UseSound)
      ResetSound(); // do noise

#ifdef PROFILECLOCKS
  FileHandle=fopen("CLOCKS.LOG","wt");
#endif

StillRunning:
//    while (kbhit()); // release the key

  UpdateSound();

    if (TeleTextModeOn)
      InitMode7();
    else
      InitModeX();
  InitKeyboard();

    do
    {
        do
        {
          CalculateMinimumCyclesToGo();
          Do6502Instructions();
          UpdateClocksAndInterrupts();
        } while (Running);

        if (Reset>0)
        {
            if (DontClearRAM!=0)
            {
              // stop memory clearance
              AddressSpace[0x258]=0;
              AddressSpace[0x287]=0;
              WriteShiela(0xfe4e,0xf2);
            }
          ResetMachine();
          Reset=0;
          Running=1;
        }

        if (Paused)
        {
          while (Paused); // do nothing till released
            if (!TeleTextModeOn)
              SavePCX();
            else
              SavePCXMode7();
          Running=1;
        }

    } while (Running);

  TextMode();
  StopSound();

  RemoveKeyboard();  // allow getche to work

GetAnotherInput:
  printf("\n(Q)uit, (K)ill sounds (any other key returns to the emulator) ? ");
  fflush(stdout);
  Running=TRUE;

  Ch=toupper(getche()); printf("\n");
    switch (Ch)
    {
      case 'K' : KillSounds();
                 break;
      case 'L' : LoadFile();
                 break;
      case 'S' : SaveFile();
                 break;
      case '1' : DumpSysVIA(stdout);
                 goto GetAnotherInput;
      case '2' : DumpUserVIA(stdout);
                 goto GetAnotherInput;
      case '3' : DumpCRTC(stdout);
                 goto GetAnotherInput;
      case '4' : DumpVideoULA(stdout);
                 goto GetAnotherInput;
      case '5' : Dump6502(stdout);
                 goto GetAnotherInput;
      case '6' : DumpSound(stdout);
                 goto GetAnotherInput;
      case '7' : DumpMatrix(stdout);
                 goto GetAnotherInput;
                 
    }

    if (Ch!='Q')
      goto StillRunning;


#ifdef PROFILECLOCKS
  fclose(FileHandle);
#endif

  printf("\n\n6502 Processor cycles elapsed = %ld\n\n"
         "BBC 'seconds' elapsed = %ld\n\n",
         TotalClockCycles,TotalClockCycles/2000000);
  RemoveSoundBlaster();
}


static void LoadFile()
{
  FILE * Handle;
  char FName[255];
  WORD StartAddress=0,BytesToRead;

  printf("\nLoad which file ?\n");
  gets(FName);
  Handle=fopen(FName,"rb");
    if (Handle==NULL)
    {
      strcat(FName,".BBC");
      Handle=fopen(FName,"rb");
        if (Handle==NULL)
          printf("\nCould not open file %s\n",FName);
    }

    if (Handle!=NULL)
    {
      printf("\nAt what address (hexadecimal)?\n");
      
      sscanf(gets(FName),"%x",&StartAddress);
        if (StartAddress>0x7fff)
          printf("\nCan't load over a ROM\n");
        else if (StartAddress==0 && strlen(FName)==0)
          printf("\nNot loading at zero page\n");
        else
        {
          BytesToRead=0x7fff-StartAddress;
          printf("\n&%.4x bytes read at &%.4x",
                 fread(&AddressSpace[StartAddress],1,BytesToRead,Handle),
                 StartAddress);
        }
      fclose(Handle);
    }
  printf("\nHit any key..\n");
  fflush(stdout);
  getch();
}


static void SaveFile()
{
  FILE * Handle;
  char FName[255];
  WORD StartAddress=0,BytesToSave=0;

  printf("\nSave which file ?\n");
  gets(FName);
  Handle=fopen(FName,"wb");

    if (Handle!=NULL)
    {
      printf("\nFrom what address (hexadecimal)?\n");
      sscanf(gets(FName),"%x",&StartAddress);
      printf("\nHow many bytes (hexadecimal)?\n");
      sscanf(gets(FName),"%x",&BytesToSave);

      fwrite(&AddressSpace[StartAddress],1,BytesToSave,Handle);
      fclose(Handle);
      printf("\nSaved!..\n");
    }
  printf("\nHit any key..\n");
  fflush(stdout);
  getch();
}
