/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <stdio.h>
#include "bbc.h"

#define __LOG1770__ 1

// only 5 have effect
#define REGS1770 8

enum { STATUS=0,COMMAND=0,TRACK,SECTOR,DATA };

static BYTE Regs1770[REGS1770];


void Write1770(WORD Address,BYTE Byte)
{
#ifdef __LOG1770__
    FILE * FH=fopen("1770.LOG","at+");
    Dump6502(FH);
    fprintf(FH,"Write %4x = %2x\n\n",Address,Byte);
    fclose(FH);
#endif

  Address&=7; // now the correct register
  Regs1770[Address]=Byte;
    if (Address==0)
    {
//      FatalError("Write 1770, address %2x=%2x",Address,Byte);
    }
}


BYTE  Read1770(WORD Address)
{
#ifdef __LOG1770__
{
    FILE * FH=fopen("1770.LOG","at+");
    Dump6502(FH);
    fprintf(FH,"Read %4x  (%2x)\n\n",Address,Regs1770[Address & 7]);
    fclose(FH);
}
#endif
  Address&=7; // now the correct register


    if (Address==0)
    {
//      FatalError("Read 1770, address %2x",Address);
    }
  return (Regs1770[Address]);
}


void Dump1770(FILE * FileHandle)
{
  short C;
  fprintf(FileHandle,"1770 registers:\n");
    for (C=0; C<REGS1770; C++)
      fprintf(FileHandle,"R%2d = %x\n",C,Regs1770[C]);
}

