/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include "6845crtc.h"
#include "timer.h"

// Each video row scanline takes 128, 2Mhz clock cycles to complete
#define ROWTIME 128
// Length of time the VSYNC signal is 'held'
#define HARDWARE_LAG (3*ROWTIME)

//#define DEFAULT_VSYNC 40000
#define DEFAULT_VSYNC 39936

DWORD VSYNCLineOffset; // for ASM routine
int DrawEveryXFrames=2;
int DoScanLines=SCAN_NONE;
int DoubleBuffering=0;
int Exact_Speed=0;
static int InterlaceTime=0;

static int DefaultVSYNCValue,VSYNCPhase,VerticalRowTimer,VSYNCCount;
// 64 cycles to account for interlace alternately added to begining
// and end of screen timings.
// 128 cycles per screen row - giving 312 lines total including V blank

enum VBlankPhaseTypes { VSYNC_EndOfBlank, VSYNC_RowDrawing,
                        VSYNC_LineDrawing0,
                        VSYNC_LineDrawing1,
                        VSYNC_LineDrawing2,
                        VSYNC_LineDrawing3,
                        VSYNC_LineDrawing4,
                        VSYNC_LineDrawing5,
                        VSYNC_LineDrawing6,
                        VSYNC_LineDrawing7,
                        VSYNC_LineDrawing8,
                        VSYNC_VSyncStart,VSYNC_VideoBlankStart };

// If not drawing by scanlines, VSYNCPhase will only every equal
// VSYNC_VSyncStart and VSYNC_VideoBlankStart


static int CurrentDisplayedCharacterRows,
           CurrentDisplayedCharacterLines,
           LastScanLinesInACharacterRow;


int GetScanLineValue()
{
  int PenTimer;
    if (!DoScanLines)
    {
      PenTimer=DefaultVSYNCValue-VerticalSYNCTimer;

          if (PenTimer<0x3200) //VerticalSYNCTimer<0x3200)
            PenTimer=0;
          else
            PenTimer-=0x3200;
    }
    else
    {
      PenTimer=0;
        switch (VSYNCPhase) 
        {
          case VSYNC_EndOfBlank :
            break;

          case VSYNC_LineDrawing8 :
            PenTimer+=ROWTIME;
          case VSYNC_LineDrawing7 :
            PenTimer+=ROWTIME;
          case VSYNC_LineDrawing6 :
            PenTimer+=ROWTIME;
          case VSYNC_LineDrawing5 :
            PenTimer+=ROWTIME;
          case VSYNC_LineDrawing4 :
            PenTimer+=ROWTIME;
          case VSYNC_LineDrawing3 :
            PenTimer+=ROWTIME;
          case VSYNC_LineDrawing2 :
            PenTimer+=ROWTIME;
          case VSYNC_LineDrawing1 :
            PenTimer+=ROWTIME;
          case VSYNC_LineDrawing0 : // fall thru
          case VSYNC_RowDrawing :
          case VSYNC_VSyncStart :
          case VSYNC_VideoBlankStart :
            PenTimer+=CurrentDisplayedCharacterRows*
                     LastScanLinesInACharacterRow*ROWTIME;
            break;
        }
    }
  return (PenTimer);
}





#define TEST_SCANHEIGHT_END \
    LogicalScreen+=(DWORD) 80; \
    CurrentDisplayedCharacterLines++;\
      if (CurrentDisplayedCharacterLines>=LastScanLinesInACharacterRow) \
      { \
        CurrentDisplayedCharacterLines=0; \
        VSYNCPhase=VSYNC_LineDrawing0; \
        ModeXScreenStart=StoredModeXScreenStart; \
        ModeXWrap=StoredModeXWrap; \
        CurrentDisplayedCharacterRows++;  \
          if (TeleTextModeOn || \
             (CurrentDisplayedCharacterRows>=LastCharacterRowsToDisplay)) \
          { \
            VerticalSYNCTimer+=( (LastVerticalSyncPosition- \
                                  LastCharacterRowsToDisplay) * \
                                  LastScanLinesInACharacterRow )*ROWTIME; \
            VSYNCPhase=VSYNC_VSyncStart; \
          } \
          else \
            VerticalSYNCTimer+=ROWTIME; \
      } \
      else \
        VerticalSYNCTimer+=ROWTIME;


void DoVideoStuff()
{
  static int ClearScreenCount,
             LastVerticalTotalInCharacters,LastVerticalSyncPosition,
             LastCharacterRowsToDisplay,
             LastScreenWidthInMemoryBytes,LastLinesToSkipFromScreenTop,
             StoredModeXScreenStart,StoredModeXWrap;


    switch (VSYNCPhase) 
    {
      case VSYNC_EndOfBlank : // calc the screen stuff for this draw
             
        LogicalScreen=(DWORD) LogicalScreenBase + (DWORD) LastLinesToSkipFromScreenTop*80;
        ModeXScreenStart=DefaultModeXScreenStart;
        ModeXWrap=DefaultModeXWrap;
        VSYNCLineOffset=0;

        CurrentDisplayedCharacterRows=0;
        VerticalRowTimer=LastScanLinesInACharacterRow * ROWTIME;

          if (DoScanLines==SCAN_EVERY)
          {
            CurrentDisplayedCharacterLines=0;
            VerticalSYNCTimer+=ROWTIME;
            VSYNCPhase=VSYNC_LineDrawing0;
          }
          else // DoScanlines *MUST* be SCAN_EVERY_8 in this case
          {
            VerticalSYNCTimer+=VerticalRowTimer;
            VSYNCPhase=VSYNC_RowDrawing;
          }

        break;


      case VSYNC_LineDrawing0 : // draw scanline 0, in character row
        VSYNCLineOffset=0;
        DisplayModeXLine();
        StoredModeXScreenStart=NextModeXScreenStart;
        StoredModeXWrap=NextModeXWrap;
        VSYNCPhase=VSYNC_LineDrawing1;
        TEST_SCANHEIGHT_END;
        break;

      case VSYNC_LineDrawing1 : // draw scanline 1, in character row
        DisplayModeXLine();
        VSYNCPhase=VSYNC_LineDrawing2;
        TEST_SCANHEIGHT_END;
        break;

      case VSYNC_LineDrawing2 : // draw scanline 2, in character row
        DisplayModeXLine();
        VSYNCPhase=VSYNC_LineDrawing3;
        TEST_SCANHEIGHT_END;
        break;

      case VSYNC_LineDrawing3 : // draw scanline 3, in character row
        DisplayModeXLine();
        VSYNCPhase=VSYNC_LineDrawing4;
        TEST_SCANHEIGHT_END;
        break;

      case VSYNC_LineDrawing4 : // draw scanline 4, in character row
        DisplayModeXLine();
        VSYNCPhase=VSYNC_LineDrawing5;
        TEST_SCANHEIGHT_END;
        break;

      case VSYNC_LineDrawing5 : // draw scanline 5, in character row
        DisplayModeXLine();
        VSYNCPhase=VSYNC_LineDrawing6;
        TEST_SCANHEIGHT_END;
        break;

      case VSYNC_LineDrawing6 : // draw scanline 6, in character row
        DisplayModeXLine();
        VSYNCPhase=VSYNC_LineDrawing7;
        TEST_SCANHEIGHT_END;
        break;

      case VSYNC_LineDrawing7 : // draw scanline 7, in character row
        DisplayModeXLine();
        VSYNCPhase=VSYNC_LineDrawing8;
        TEST_SCANHEIGHT_END;
        break;

      case VSYNC_LineDrawing8 : // scanlines 8+ onwards, in character row
        TEST_SCANHEIGHT_END;    // don't display!!
        break; 


      case VSYNC_RowDrawing : // draw character rows

        DisplayModeXRow();
        CurrentDisplayedCharacterRows++;
          if (!TeleTextModeOn && CurrentDisplayedCharacterRows<LastCharacterRowsToDisplay)
          {  // do another row
            VerticalSYNCTimer+=VerticalRowTimer;
          }
          else // start video blanking
          {
            VerticalSYNCTimer+=( (LastVerticalSyncPosition-
                                  LastCharacterRowsToDisplay) *
                                LastScanLinesInACharacterRow )*ROWTIME;
            VSYNCPhase=VSYNC_VSyncStart;
          }
        break;


      // Start of a VSYNC, not just a 'phase'
      case VSYNC_VSyncStart :
        VerticalSYNCTimer+=HARDWARE_LAG;
        VSYNCPhase=VSYNC_VideoBlankStart;
          if (DoScanLines<SCAN_EVERY)
            VSYNC_HOLD=2;
        break;


      case VSYNC_VideoBlankStart :
        DisplaySplitLEDs();
        InterlaceTime^=ROWTIME;
        VSYNCCount++;

        {
          static BYTE OldTeleTextModeOn=4;
            if (OldTeleTextModeOn!=TeleTextModeOn)
            {
              OldTeleTextModeOn=TeleTextModeOn;
                if (TeleTextModeOn)
                  InitMode7();
                else
                  InitModeX();
              CalcNewCRTC();
            }
        }



          if (Exact_Speed>0) // sync 'virtual' system clock with PC clock
          {
              while (Timer_50Hertz==0) ; // do nothing             
            Timer_50Hertz=0;
          }

        // Screen Update Frequency changed?
        // check if bits of screen need blanking (and do blanking)
          if (LastVerticalTotalInCharacters!=VerticalTotalInCharacters ||
              LastScanLinesInACharacterRow!=ScanLinesInACharacterRow ||
              LastVerticalSyncPosition!=VerticalSyncPosition ||
              LastCharacterRowsToDisplay!=CharacterRowsToDisplay ||
              LastLinesToSkipFromScreenTop!=LinesToSkipFromScreenTop ||
              LastScanLinesInACharacterRow!=ScanLinesInACharacterRow ||
              LastScreenWidthInMemoryBytes!=ScreenWidthInMemoryBytes)
          {
              if (LastLinesToSkipFromScreenTop!=LinesToSkipFromScreenTop ||
                  LastCharacterRowsToDisplay!=CharacterRowsToDisplay ||
                  LastScanLinesInACharacterRow!=ScanLinesInACharacterRow ||
                  LastScreenWidthInMemoryBytes!=ScreenWidthInMemoryBytes)
                {
                  ModeXRowSize=80* (int)(ScanLinesInACharacterRow-1);
                  // clear both pages if double buffering!!
                  ClearScreenCount=1+DoubleBuffering;
                }

            LastLinesToSkipFromScreenTop= (int) LinesToSkipFromScreenTop;
            LastCharacterRowsToDisplay=   (int) CharacterRowsToDisplay;
            LastScanLinesInACharacterRow= (int) ScanLinesInACharacterRow;
            LastScreenWidthInMemoryBytes= (int) ScreenWidthInMemoryBytes;
            LastVerticalSyncPosition=     (int) VerticalSyncPosition;
            LastVerticalTotalInCharacters=(int) VerticalTotalInCharacters;

            DefaultVSYNCValue=( ( VerticalTotalInCharacters*
                                  ScanLinesInACharacterRow ) +
                                ((int) RegisterValues6845[5]))*ROWTIME;
          }

          if ((VSYNCCount % 64)==0)
            AgePalettes();
          
        CursorBlinkCounter--;
          if (CursorBlinkCounter==0)
          {
            CursorOnFlag^=1; // toggles between 1(on) and 0(off)
            CursorBlinkCounter=DefaultCursorBlinkingCounter;
          }

          if (TeleTextModeOn || (VSYNCCount % DrawEveryXFrames!=0))
          { // do not draw this frame - its interlace/T-Text

              if (TeleTextModeOn)
                DefaultVSYNCValue=DEFAULT_VSYNC;

            VerticalSYNCTimer+=DefaultVSYNCValue+InterlaceTime;
            VSYNCPhase=VSYNC_VSyncStart; // default
              
              if (TeleTextModeOn && ((VSYNCCount % DrawEveryXFrames)==0))
                DisplayMode7Screen(&AddressSpace[ScreenStartAddress],
                                   (0x8000-ScreenStartAddress));
          }
          else
          { // draw this frame

              if (DoubleBuffering>0)
              { // swap display pages
                DWORD Temp=PhysicalScreenBase;
                PhysicalScreenBase=LogicalScreenBase;
                LogicalScreenBase=Temp;
                SwapScreenPage(); // display physicalscreen
              }

              if (ClearScreenCount>0)
              {
                ClearScreenCount--;
                LogicalScreen=(DWORD) LogicalScreenBase;
                ClearModeXScreen(); // this fucks screen regs
              }

              if (DoScanLines)
              {
                VerticalSYNCTimer+=( ( (LastVerticalTotalInCharacters-
                                        LastVerticalSyncPosition) *
                                      LastScanLinesInACharacterRow)+
                                   ((int) RegisterValues6845[5]))*ROWTIME+
                                   InterlaceTime;
                VSYNCPhase=VSYNC_EndOfBlank;
              }
              else
              {
                DisplayModeXScreen();
                VerticalSYNCTimer+=DefaultVSYNCValue;                
                VSYNCPhase=VSYNC_VSyncStart; // default
              }
          }

        VerticalSYNCTimer-=HARDWARE_LAG;

        // if CA1 then IRA=PortA
        IFR|=2; // set CA1 interrupt
        IRA=(PortA & (DDRA ^ 255)) + (ORA & DDRA);
        VSYNC_HOLD=0; // NOT LONGER HELD

        break;
    }
}
