/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <conio.h>
#include <i86.h>
#include <stdio.h>
#include <string.h>
#include "6845crtc.h"
#include "bbc.h"
#include "modex.h"

extern BYTE TeleTextModeOn;
extern int DoubleBuffering;

static struct pcx
{
        char     manufact;               // const 10 
        char     version;                // should be 5 
        char     encoding;
        char     BitsPerPixel;
        unsigned short   XMin;                   
        unsigned short   YMin;
        unsigned short   XMax;
        unsigned short   YMax;
        unsigned short   hdpi;           // horizontal dots per inch 
        unsigned short   vdpi;           // vertical dots per inch 
        char     ColourMap[16][3];
        char     reserved;
        char     NPlanes;                
        unsigned short   BytesPerLine;           
        unsigned short   paletteinfo;
        unsigned short   hsize;          // not used 
        unsigned short   vsize;          // not used
        char     filler[54];
} PCXHeader;

extern char Colours[16][3];

static unsigned short ReadPlaneWord[] =  { 0x0004,0x0104,0x0204,0x0304 };
static unsigned char  WritePlaneByte[] = { 1,     2,     4,     8      };

enum PCXActionType {PCX_INIT,PCX_LAST,PCX_WRITE,PCX_ADD};

static FILE * FileHandle;
static char FileName[256];

static void OutputByte(unsigned char Ch,int Action)
{
  static unsigned char LastByte,ICount;

// isn't re-entrant code great?

    switch (Action)
    {
        case PCX_LAST  : if (ICount==0)
                           break;
                           // if all bytes are written then break,
                           // else fall through to write

        case PCX_WRITE : if ((ICount>1) || (LastByte>=0xc0))
                           fputc((ICount | 0xc0),FileHandle); // write count number
                         fputc(LastByte,FileHandle);          // write just byte
                         // fall through

        case PCX_INIT  : ICount=0;
                         break;
      
        case PCX_ADD   : if (ICount==0)
                           LastByte=Ch;
                         if (Ch==LastByte)  // same byte as last time
                         {
                           ICount++;  // just count bytes
                             if (ICount==0x3f) // force output
                               OutputByte(0,PCX_WRITE);
                         }
                         else               // new byte, so output old byte
                         {
                           OutputByte(0,PCX_WRITE); // write last byte
                           OutputByte(Ch,PCX_ADD);   // start counting new byte
                         }
                         break;
        default:
                 FatalError("PCX broken");
    }                     
}



void SavePCX()
{
  int YOffset,XI,Planes,W=640,H;
  unsigned char * ScreenMap;

  H=ScanLinesInACharacterRow*CharacterRowsToDisplay+LinesToSkipFromScreenTop;

  InitHeader(W,H);

  FileHandle=fopen(FileName,"wb");
    if ( FileHandle==NULL ) 
      FatalError("Can't create PCX file : %s",FileName);

    if ( fwrite(&PCXHeader,sizeof(PCXHeader),1,FileHandle)!=1 )
      FatalError("Error writing PCX : %s",FileName);
  
  //Screen Memory To PCX
  outpw(0x03ce,5); // read / write mode 0
  outp(0x03c4,2);  // set up index for mask register

  OutputByte(0,PCX_INIT);

    for (YOffset=0; YOffset<H; YOffset++)
    {
        for (Planes=0; Planes<4; Planes++)
        {
          outp (0x03c5,WritePlaneByte[Planes]); // write access plane X
          outpw(0x03ce,ReadPlaneWord[Planes]); // set up for read access

          ScreenMap=(char *) PhysicalScreenBase+ YOffset*80;
 
            for (XI=0 ; XI<PCXHeader.BytesPerLine; XI++)
             OutputByte(*ScreenMap++,PCX_ADD);
        }
      OutputByte(0,PCX_LAST);
    }
  fclose(FileHandle);

  // stick regs back to how emulator expects them
  outp(0x03c5,15); // allow access to all 4 planes again!
  outpw(0x03ce,0x0003); //  replace
  outpw(0x03ce,0xff08); // bit mask register
  outpw(0x03ce,0x0105); // write mode 1

}


void SavePCXMode7()
{
  int YOffset,XI,W=240,H=250;
  unsigned char * ScreenMap=(char *) 0xa0000;

  InitHeader(W,H);

  PCXHeader.BitsPerPixel=8;
  PCXHeader.NPlanes=1;
  PCXHeader.BytesPerLine=W;

  FileHandle=fopen(FileName,"wb");
    if ( FileHandle==NULL ) 
      FatalError("Can't create PCX file : %s",FileName);

    if ( fwrite(&PCXHeader,sizeof(PCXHeader),1,FileHandle)!=1 )
      FatalError("Error writing PCX : %s",FileName);
  
  //Screen Memory To PCX
  outpw(0x03ce,5); // read / write mode 0

  OutputByte(0,PCX_INIT);

    for (YOffset=0; YOffset<H; YOffset++)
    {
        for (XI=0 ; XI<W; XI++)
         OutputByte(*ScreenMap++,PCX_ADD);
      OutputByte(0,PCX_LAST);
    }

  fputc(0x0c,FileHandle);  // palette marker
    for (XI=0; XI<16; XI++)
      fwrite(&PCXHeader.ColourMap[0][0],3,16,FileHandle);  //palette 16 times

  fclose(FileHandle);

  outpw(0x03ce,0x4005); // regs back for emulator
}



static void InitHeader(int W,int H)
{
  union REGS regs;
  int Count=0,Searching=1;
 
    while (Searching)
    {
      sprintf(FileName,"SNAP%.4d.PCX",Count);
      FileHandle=fopen(FileName,"rb");
        if (FileHandle!=NULL)
        {
          fclose(FileHandle);
          Count++;
        }
        else
          Searching=0;
    }

  PCXHeader.manufact=0x0a;
  PCXHeader.version=5;
  PCXHeader.encoding=1;
  PCXHeader.BitsPerPixel=1;
  PCXHeader.XMin=0;
  PCXHeader.YMin=0;
  PCXHeader.XMax=W-1;
  PCXHeader.YMax=H-1;
  PCXHeader.NPlanes=4;
  PCXHeader.paletteinfo=2;
  PCXHeader.BytesPerLine=(W+7)/8;

  strcpy(PCXHeader.filler,"PCX produced by BeebInC, (C) 1998 D.C.Devenport");

    for ( Count=0; Count<16 ; Count++ )
    {
      regs.w.ax=0x01015;
      regs.w.bx=Count;
      int386(0x10,&regs,&regs);

      PCXHeader.ColourMap[Count][0]=(regs.h.dh<<2)+3; //red
      PCXHeader.ColourMap[Count][1]=(regs.h.ch<<2)+3; //green
      PCXHeader.ColourMap[Count][2]=(regs.h.cl<<2)+3; //blue
    }
}
