/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#include <i86.h>
#include <conio.h>

#include <stdio.h>

#include "bbc.h"
#include "modex.h"

static struct Mode2PaletteType
{
  const char * PaletteAddress;
  int Age;
  BYTE CurrentPalette[NUMCOLS];
} Mode2PalTable[TABLESIZE]=
{
  { (char *) 0xaba00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xabb00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xabc00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xabd00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xabe00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xabf00, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xac000, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xac100, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xac200, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } },
  { (char *) 0xac300, 0, { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } }
};

static int    Mode2TableOffset=0;


void ClearMode2Colours()
{
  int CountX,CountY;
    for (CountY=0; CountY<TABLESIZE; CountY++)
    {
        for (CountX=0; CountX<16; CountX++)
          Mode2PalTable[CountY].CurrentPalette[CountX]=17;
      Mode2PalTable[CountY].Age=0;
    }
  Mode2TableOffset=0;
}


void AgeMode2()
{
  int CountY;
    for (CountY=0; CountY<TABLESIZE; CountY++)
       Mode2PalTable[CountY].Age>>=1;
}


void DisplayMode2Screen()
{
// write mode1, 0xff mask, access to all planes

    if (ColoursChanged)
      Mode2ChangeColours();

  Mode2PalTable[Mode2TableOffset].Age+=256;
  ModeXLookup=(DWORD) Mode2PalTable[Mode2TableOffset].PaletteAddress;
  Plot20K();
}

void DisplayMode2Row()
{
// write mode1, 0xff mask, access to all planes

    if (ColoursChanged)
    {
      Mode2ChangeColours();
      ModeXLookup=(DWORD) Mode2PalTable[Mode2TableOffset].PaletteAddress;
    }
  Mode2PalTable[Mode2TableOffset].Age+=4;
  Plot80Row();
}


void DisplayMode2Line()
{
// write mode1, 0xff mask, access to all planes

    if (ColoursChanged)
    {
      Mode2ChangeColours();
      ModeXLookup=(DWORD) Mode2PalTable[Mode2TableOffset].PaletteAddress;
    }
  Mode2PalTable[Mode2TableOffset].Age++;
  Plot80Line();
}


const struct MODE2 // A byte is ABABABAB
{
  char Colours1[0x10]; // Right pixels , screen mask = 0x0f
  char Colours2[0x10]; // Left pixels  , screen mask = 0xf0
} Mode2Table[]=
{
  { // colour 0
     // every combination of 0 as Right pixels
      { 0x00, 0x02, 0x08, 0x0a,
        0x20, 0x22, 0x28, 0x2a,
        0x80, 0x82, 0x88, 0x8a,
        0xa0, 0xa2, 0xa8, 0xaa },
     // every combination of 0 as Left pixels 
      { 0x00, 0x01, 0x04, 0x05,
        0x10, 0x11, 0x14, 0x15,
        0x40, 0x41, 0x44, 0x45,
        0x50, 0x51, 0x54, 0x55 }
  },

  { // colour 1
    // every combination of 1 as Right pixels
      { 0x01, 0x03, 0x09, 0x0b,
        0x21, 0x23, 0x29, 0x2b,
        0x81, 0x83, 0x89, 0x8b,
        0xa1, 0xa3, 0xa9, 0xab },
    // every combination of 1 as Left pixels
      { 0x02, 0x03, 0x06, 0x07,
        0x12, 0x13, 0x16, 0x17,
        0x42, 0x43, 0x46, 0x47,
        0x52, 0x53, 0x56, 0x57 }
  },

  { // colour 2
    // every combination of 2 as Right pixels
      { 0x04, 0x06, 0x0c, 0x0e,
        0x24, 0x26, 0x2c, 0x2e,
        0x84, 0x86, 0x8c, 0x8e,
        0xa4, 0xa6, 0xac, 0xae },
    // every combination of 2 as Left pixels
      { 0x08, 0x09, 0x0c, 0x0d,
        0x18, 0x19, 0x1c, 0x1d,
        0x48, 0x49, 0x4c, 0x4d,
        0x58, 0x59, 0x5c, 0x5d }
  },

  { // colour 3
    // every combination of 3 as Right pixels
      { 0x05, 0x07, 0x0d, 0x0f,
        0x25, 0x27, 0x2d, 0x2f,
        0x85, 0x87, 0x8d, 0x8f,
        0xa5, 0xa7, 0xad, 0xaf },
    // every combination of 3 as Left pixels
      { 0x0a, 0x0b, 0x0e, 0x0f,
        0x1a, 0x1b, 0x1e, 0x1f,
        0x4a, 0x4b, 0x4e, 0x4f,
        0x5a, 0x5b, 0x5e, 0x5f }
  },

  { // colour 4
    // every combination of 4 as Right pixels
      { 0x10, 0x12, 0x18, 0x1a,
        0x30, 0x32, 0x38, 0x3a,
        0x90, 0x92, 0x98, 0x9a,
        0xb0, 0xb2, 0xb8, 0xba },
    
      { 0x20, 0x21, 0x24, 0x25,
        0x30, 0x31, 0x34, 0x35,
        0x60, 0x61, 0x64, 0x65,
        0x70, 0x71, 0x74, 0x75 }
  },

  { // colour 5
    // every combination of 5 as Right pixels
      { 0x11, 0x13, 0x19, 0x1b,
        0x31, 0x33, 0x39, 0x3b,
        0x91, 0x93, 0x99, 0x9b,
        0xb1, 0xb3, 0xb9, 0xbb },
    
      { 0x22, 0x23, 0x26, 0x27,
        0x32, 0x33, 0x36, 0x37,
        0x62, 0x63, 0x66, 0x67,
        0x72, 0x73, 0x76, 0x77 }
  },

  { // colour 6
    // every combination of 6 as Right pixels
      { 0x14, 0x16, 0x1c, 0x1e,
        0x34, 0x36, 0x3c, 0x3e,
        0x94, 0x96, 0x9c, 0x9e,
        0xb4, 0xb6, 0xbc, 0xbe },
    
      { 0x28, 0x29, 0x2c, 0x2d,
        0x38, 0x39, 0x3c, 0x3d,
        0x68, 0x69, 0x6c, 0x6d,
        0x78, 0x79, 0x7c, 0x7d }
  },

  { // colour 7
    // every combination of 7 as Right pixels
      { 0x15, 0x17, 0x1d, 0x1f,
        0x35, 0x37, 0x3d, 0x3f,
        0x95, 0x97, 0x9d, 0x9f,
        0xb5, 0xb7, 0xbd, 0xbf },
    
      { 0x2a, 0x2b, 0x2e, 0x2f,
        0x3a, 0x3b, 0x3e, 0x3f,
        0x6a, 0x6b, 0x6e, 0x6f,
        0x7a, 0x7b, 0x7e, 0x7f },
  },

  { // colour 8
    // every combination of 8 as Right pixels
      { 0x40, 0x42, 0x48, 0x4a,
        0x60, 0x62, 0x68, 0x6a,
        0xc0, 0xc2, 0xc8, 0xca,
        0xe0, 0xe2, 0xe8, 0xea },

      { 0x80, 0x81, 0x84, 0x85,
        0x90, 0x91, 0x94, 0x95,
        0xc0, 0xc1, 0xc4, 0xc5,
        0xd0, 0xd1, 0xd4, 0xd5 }
  },

  { // colour 9
    // every combination of 9 as Right pixels
      { 0x41, 0x43, 0x49, 0x4b,
        0x61, 0x63, 0x69, 0x6b,
        0xc1, 0xc3, 0xc9, 0xcb,
        0xe1, 0xe3, 0xe9, 0xeb },

      { 0x82, 0x83, 0x86, 0x87,
        0x92, 0x93, 0x96, 0x97,
        0xc2, 0xc3, 0xc6, 0xc7,
        0xd2, 0xd3, 0xd6, 0xd7 }
  },

  { // colour a
    // every combination of A as Right pixels
      { 0x44, 0x46, 0x4c, 0x4e,
        0x64, 0x66, 0x6c, 0x6e,
        0xc4, 0xc6, 0xcc, 0xce,
        0xe4, 0xe6, 0xec, 0xee },

      { 0x88, 0x89, 0x8c, 0x8d,
        0x98, 0x99, 0x9c, 0x9d,
        0xc8, 0xc9, 0xcc, 0xcd,
        0xd8, 0xd9, 0xdc, 0xdd }
  },

  { // colour b
    // every combination of B as Right pixels
      { 0x45, 0x47, 0x4d, 0x4f,
        0x65, 0x67, 0x6d, 0x6f,
        0xc5, 0xc7, 0xcd, 0xcf,
        0xe5, 0xe7, 0xed, 0xef },

      { 0x8a, 0x8b, 0x8e, 0x8f,
        0x9a, 0x9b, 0x9e, 0x9f,
        0xca, 0xcb, 0xce, 0xcf,
        0xda, 0xdb, 0xde, 0xdf }
  },

  { // colour c
    // every combination of C as Right pixels
      { 0x50, 0x52, 0x58, 0x5a,
        0x70, 0x72, 0x78, 0x7a,
        0xd0, 0xd2, 0xd8, 0xda,
        0xf0, 0xf2, 0xf8, 0xfa },
    
      { 0xa0, 0xa1, 0xa4, 0xa5,
        0xb0, 0xb1, 0xb4, 0xb5,
        0xe0, 0xe1, 0xe4, 0xe5,
        0xf0, 0xf1, 0xf4, 0xf5 }
  },
  { // colour d
    // every combination of D as Right pixels
      { 0x51, 0x53, 0x59, 0x5b,
        0x71, 0x73, 0x79, 0x7b,
        0xd1, 0xd3, 0xd9, 0xdb,
        0xf1, 0xf3, 0xf9, 0xfb },

      { 0xa2, 0xa3, 0xa6, 0xa7,
        0xb2, 0xb3, 0xb6, 0xb7,
        0xe2, 0xe3, 0xe6, 0xe7,
        0xf2, 0xf3, 0xf6, 0xf7 }
  },

  { // colour e
    // every combination of E as Right pixels
      { 0x54, 0x56, 0x5c, 0x5e,
        0x74, 0x76, 0x7c, 0x7e,
        0xd4, 0xd6, 0xdc, 0xde,
        0xf4, 0xf6, 0xfc, 0xfe },

      { 0xa8, 0xa9, 0xac, 0xad,
        0xb8, 0xb9, 0xbc, 0xbd,
        0xe8, 0xe9, 0xec, 0xed,
        0xf8, 0xf9, 0xfc, 0xfd }
  },

  { // colour f
    // every combination of F as Right pixels
      { 0x55, 0x57, 0x5d, 0x5f,
        0x75, 0x77, 0x7d, 0x7f,
        0xd5, 0xd7, 0xdd, 0xdf,
        0xf5, 0xf7, 0xfd, 0xff },

      { 0xaa, 0xab, 0xae, 0xaf,
        0xba, 0xbb, 0xbe, 0xbf,
        0xea, 0xeb, 0xee, 0xef,
        0xfa, 0xfb, 0xfe, 0xff }
  }
};

#define MODE2NUMCOLS 16

void Mode2ChangeColours()
{
  char * ScreenPtr;
  int TableOffset,Count,MinAge,OldestOffset,Colour,MatchOffset,MatchCount,
      NumberMatched;

  MinAge=512;
  OldestOffset=0;
  MatchOffset=0;
  MatchCount=0;
    for (TableOffset=0; TableOffset<TABLESIZE; TableOffset++)
    {
      NumberMatched=0;
        for (Colour=0; Colour<MODE2NUMCOLS; Colour++)
        {
            if (Mode2PalTable[TableOffset].CurrentPalette[Colour]==
                                           LogicalColours[Colour])
              NumberMatched++;
        }

        if (NumberMatched==MODE2NUMCOLS)
        {
          Mode2TableOffset=TableOffset; // table exists, cool!
          return;
        }
        else if (NumberMatched>MatchCount)
        {
          MatchCount=NumberMatched;
          MatchOffset=TableOffset;
        }

        if (Mode2PalTable[TableOffset].Age<MinAge)
        {
          MinAge=Mode2PalTable[TableOffset].Age;
          OldestOffset=TableOffset;
        }
    }

// ScreenPtr now points the to screen table
  Mode2TableOffset=OldestOffset;
  ScreenPtr=Mode2PalTable[Mode2TableOffset].PaletteAddress;

    if (MatchCount>0 && Mode2TableOffset!=MatchOffset) // copy a palette across
    {
      char * To, * From;

      To=ScreenPtr;
      From=Mode2PalTable[MatchOffset].PaletteAddress;
        for (Count=0; Count<256; Count++)
          *(To++)=*(From++);

        for (Colour=0; Colour<MODE2NUMCOLS; Colour++)
        {
          Mode2PalTable[Mode2TableOffset].CurrentPalette[Colour]=
                  Mode2PalTable[MatchOffset].CurrentPalette[Colour];
        }
    }


  outpw(0x03ce,0x0205); // write mode 2
  outp(0x03ce,0x08); // bit mask index

    for (Colour=0; Colour<MODE2NUMCOLS; Colour++)
    {
        if (LogicalColours[Colour]!=Mode2PalTable[Mode2TableOffset].CurrentPalette[Colour])
        {
          Mode2PalTable[Mode2TableOffset].CurrentPalette[Colour]=LogicalColours[Colour];
          outp(0x03cf,0x0f); // bit mask register
            for (Count=0;Count<0x10;Count++)
            {
              Byte=*(ScreenPtr+  Mode2Table[Colour].Colours1[Count]);
              (*(ScreenPtr+  Mode2Table[Colour].Colours1[Count]))=LogicalColours[Colour];
            }
          outp(0x03cf,0xf0); // bit mask register
            for (Count=0;Count<0x10;Count++)
            {
              Byte=*(ScreenPtr+  Mode2Table[Colour].Colours2[Count]);
              (*(ScreenPtr+  Mode2Table[Colour].Colours2[Count]))=LogicalColours[Colour];
            }
        }
    }

  outp(0x03cf,0xff); // bit mask data
  outpw(0x03ce,0x0105); // write mode 1
  ColoursChanged=FALSE;
}

/*
void DumpMode2()
{
  int Count;
    for (Count=0;Count<10; Count++)
    {
      printf("Age %d, %x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,%x\n",
             Mode2PalTable[Count].Age,
             Mode2PalTable[Count].CurrentPalette[0],
             Mode2PalTable[Count].CurrentPalette[1],
             Mode2PalTable[Count].CurrentPalette[2],
             Mode2PalTable[Count].CurrentPalette[3],
             Mode2PalTable[Count].CurrentPalette[4],
             Mode2PalTable[Count].CurrentPalette[5],
             Mode2PalTable[Count].CurrentPalette[6],
             Mode2PalTable[Count].CurrentPalette[7],
             Mode2PalTable[Count].CurrentPalette[8],
             Mode2PalTable[Count].CurrentPalette[9],
             Mode2PalTable[Count].CurrentPalette[10],
             Mode2PalTable[Count].CurrentPalette[11],
             Mode2PalTable[Count].CurrentPalette[12],
             Mode2PalTable[Count].CurrentPalette[13],
             Mode2PalTable[Count].CurrentPalette[14],
             Mode2PalTable[Count].CurrentPalette[15]);

    }
}
*/
