/* -------------------------------------------------------------------------- */
/*                                                                            */
/* (C) Copyright D.C.Devenport 1998. All right reserved.                      */
/*                                                                            */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY      */
/* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE        */
/* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR      */
/* PURPOSE.                                                                   */
/*                                                                            */
/* This code, and no part of this code, may not be used in any                */
/* commercial or for-profit venture without the express written               */
/* permission of D.C.Devenport. (BeebInC@aol.com)                             */
/*                                                                            */
/* Credit must be given within any program that uses any of this code         */
/* OR in the accompanying documentation. (And mail me a copy :) )             */
/*                                                                            */
/*----------------------------------------------------------------------------*/
#ifndef KEYTABLE

#include <stdio.h>

enum KEYTABLE
{
  SHIFT=0x00, CTRL , LINK8, LINK7, LINK6, LINK5, LINK4, LINK3, LINK2, LINK1,
  LET_Q=0x10, NUM_3, NUM_4, NUM_5, F4   , NUM_8, F7   , MINUS, TILDE, LARR ,
  F0   =0x20, LET_W, LET_E, LET_T, NUM_7, LET_I, NUM_9, NUM_0, POUND, DARR ,
  NUM_1=0x30, NUM_2, LET_D, LET_R, NUM_6, LET_U, LET_O, LET_P, LBRAC, UARR ,
  CLOCK=0x40, LET_A, LET_X, LET_F, LET_Y, LET_J, LET_K, AT   , COLON, RET  ,
  SLOCK=0x50, LET_S, LET_C, LET_G, LET_H, LET_N, LET_L, SEMI , RBRAC, DEL  ,
  TAB  =0x60, LET_Z, SPACE, LET_V, LET_B, LET_M, COMMA, FSTOP, SLASH, COPY ,
  ESC  =0x70, F1   , F2   , F3   , F5   , F6   , F8   , F9   , BSLAS, RARR ,
  BREAK=0x80
};

// num lock=bit 1, caps lock=bit 2, scroll lock=bit 0

#define MOTOR_ON  2
#define MOTOR_OFF 0
#define CAPS_ON   4
#define CAPS_OFF  0
#define SHIFT_ON  1
#define SHIFT_OFF 0

#endif

extern BYTE SHIFTLock,CAPSLock,MotorLED;

//                  Normal keys         SHIFT + CTRL
extern volatile int NumberOfKeysPressed,ExtraKeysPressed;

void ResetKeyboard();

BYTE ReadKeyboard(BYTE Key);


void BBCKey(BYTE Flag,BYTE Key);

void InsertKey(BYTE Key);

void ReleaseKey(BYTE Key);


void CAPSLockOn();

void CAPSLockOff();

void SHIFTLockOn();

void SHIFTLockOff();

void DumpMatrix(FILE * FileHandle);

// void UpdateLEDs();

