/****************************************************************************/
/*              Beebem - (c) David Alan Gilbert 1994                        */
/*              ------------------------------------                        */
/* This program may be distributed freely within the following restrictions:*/
/*                                                                          */
/* 1) You may not charge for this program or for any part of it.            */
/* 2) This copyright message must be distributed with all copies.           */
/* 3) This program must be distributed complete with source code.  Binary   */
/*    only distribution is not permitted.                                   */
/* 4) The author offers no warrenties, or guarentees etc. - you use it at   */
/*    your own risk.  If it messes something up or destroys your computer   */
/*    thats YOUR problem.                                                   */
/* 5) You may use small sections of code from this program in your own      */
/*    applications - but you must acknowledge its use.  If you plan to use  */
/*    large sections then please ask the author.                            */
/*                                                                          */
/* If you do not agree with any of the above then please do not use this    */
/* program.                                                                 */
/* Please report any problems to the author at gilbertd@cs.man.ac.uk        */
/****************************************************************************/
/* The window which the beeb emulator displays stuff in */
#ifndef BEEBWIN_HEADER
#define BEEBWIN_HEADER

#include <string.h>

#include <X11/Xlib.h>

#include "dagXCL/shmImage.h"
#include "dagXCL/TopLevelWindow.h"

#include "port.h"

typedef union {
	unsigned char data[8];
  EightByteType eightbyte;
} EightUChars;

typedef union {
	unsigned char data[16];
  EightByteType eightbytes[2];
} SixteenUChars;

class BeebWin : private TopWin {
  virtual void eventKeyDown(XKeyEvent xkey);
  virtual void eventKeyUp(XKeyEvent xkey);
  virtual void eventExpose(XExposeEvent xexpose);
	virtual void eventFocusIn(XFocusChangeEvent xfocus);
	virtual void eventFocusOut(XFocusChangeEvent xfocus);

	int OldAutoRepeat; /* -1 means we don't know, 0 and 1 are as returned from XGetKeyboardControl */
	int DataSize;
  dagShmImage si; /* display */
  GC gc;
	Colormap colormap; /* Yuch! But I'm not bouncing between spellings! */
public:
	unsigned char cols[8]; /* Beeb colour lookup */
  BeebWin();
	~BeebWin();
	char *imageData();
	int bytesPerLine();
	void updateLines(int starty, int nlines);

	inline void doHorizLine(unsigned long Col, int y, int sx, int width) {
		if (y>255) return;
	  memset(si.imageData()+y*si.ximage->bytes_per_line+sx,Col,width);
  }; /* doHorizLine */

	inline void doHorizLine(unsigned long Col, int offset, int width) {
		if ((offset+width)<DataSize) return;
		memset(si.imageData()+offset,Col,width);
	}; /* BeebWin::doHorizLine */
	EightUChars *GetLinePtr(int y);
	SixteenUChars *GetLinePtr16(int y);
}; /* BeebWin */

#endif
