
/****************************************************************************/
/*              Beebem - (c) David Alan Gilbert 1994                        */
/*              ------------------------------------                        */
/* This program may be distributed freely within the following restrictions:*/
/*                                                                          */
/* 1) You may not charge for this program or for any part of it.            */
/* 2) This copyright message must be distributed with all copies.           */
/* 3) This program must be distributed complete with source code.  Binary   */
/*    only distribution is not permitted.                                   */
/* 4) The author offers no warrenties, or guarentees etc. - you use it at   */
/*    your own risk.  If it messes something up or destroys your computer   */
/*    thats YOUR problem.                                                   */
/* 5) You may use small sections of code from this program in your own      */
/*    applications - but you must acknowledge its use.  If you plan to use  */
/*    large sections then please ask the author.                            */
/*                                                                          */
/* If you do not agree with any of the above then please do not use this    */
/* program.                                                                 */
/* Please report any problems to the author at gilbertd@cs.man.ac.uk        */
/****************************************************************************/
/* Create and (possibly map) an X window */
/* David Alan Gilbert 5/11/94 */
#include "X11/Xlib.h"
#include "X11/Xutil.h"

#include "dagCL/AssocArray.h"
#include "dagXCL/DispServerConnection.h"
#include "dagXCL/XErr.h"
#include "dagXCL/Window.h"

dagXWindow::dagXWindow(dagXDispServerConnection* con, Window parent, int x, int y,
                   unsigned int width, unsigned int height,
		   unsigned int border_width,
		   int depth,
		   unsigned int xClass,
		   Visual *visual,
		   unsigned long valuemask,
		   XSetWindowAttributes *attributes) :
    firstChild(NULL), nextWindow(NULL), myParent(NULL) {
  myHandle=XCreateWindow(con->getXDisplay(),parent,x,y,width,height,
   border_width,depth,xClass,visual,valuemask,attributes);
  myDisplay=con->getXDisplay();
  myScreen=con->getXScreen();
  allWinList.add(myHandle,this);
}

void dagXWindow::bindSubWindow(dagXWindow* subWindow) {
  /* Add the new window into the parent's list */
  subWindow->nextWindow=firstChild;
  firstChild=subWindow;

  subWindow->myParent=this;
} /* bindSubWindow */

void dagXWindow::Map() {
  XMapWindow(myDisplay, myHandle);
}

void dagXWindow::SetName(char *newName) {
  /* Based on code from rxvt in its change_window_name routine */
  XTextProperty name;

  if (XStringListToTextProperty(&newName,1,&name) ==0)
    throw dagErr("No Memory","Can't allocate window name");

  XSetWMName(myDisplay,myHandle,&name);
  XFree(name.value);
} /* SetName */

void dagXWindow::SetEventTypeMask(long event_mask) {
  XSelectInput(myDisplay,myHandle, event_mask);
} /* SetEventTypeMask */

virtual void dagXWindow::Background(unsigned long background_pixel) {
  XSetWindowBackground(myDisplay,myHandle,1);
} /* background */

dagXWindow::~dagXWindow() {
  dagXWindow* toDestroy=firstChild;
  dagXWindow* next;
  XDestroyWindow(myDisplay,myHandle);

  /* got to destroy all the children without actually calling X stuff! */
  while (toDestroy) {
    next=toDestroy->nextWindow;

    delete toDestroy;

    toDestroy=next;
  } /* Child destroy loop */

  /* Remove the window from the x-handle to object translation list */
  allWinList.remove(this);
}

virtual void dagXWindow::eventKeyDown(XKeyEvent xkey) {
  if (myParent) myParent->eventKeyDown(xkey);
}; /* KeyDown */

virtual void dagXWindow::eventKeyUp(XKeyEvent xkey) {
  if (myParent) myParent->eventKeyUp(xkey);
}; /* KeyUp */

virtual void dagXWindow::eventButtonDown(XButtonEvent xbutton) {
  if (myParent) myParent->eventButtonDown(xbutton);
}; /* ButtonDown */

virtual void dagXWindow::eventButtonUp(XButtonEvent xbutton) {
  if (myParent) myParent->eventButtonUp(xbutton);
}; /* ButtonUp */

virtual void dagXWindow::eventMotion(XMotionEvent xmotion) {
  if (myParent) myParent->eventMotion(xmotion);
}; /* Motion */

virtual void dagXWindow::eventPtrEnter(XCrossingEvent xcrossing) {
  if (myParent) myParent->eventPtrEnter(xcrossing);
}; /* PtrEnter */

virtual void dagXWindow::eventPtrLeave(XCrossingEvent xcrossing) {
  if (myParent) myParent->eventPtrLeave(xcrossing);
}; /* PtrLeave */

virtual void dagXWindow::eventFocusIn(XFocusChangeEvent xfocus) {
  if (myParent) myParent->eventFocusIn(xfocus);
}; /* FocusIn */

virtual void dagXWindow::eventFocusOut(XFocusChangeEvent xfocus) {
  if (myParent) myParent->eventFocusOut(xfocus);
}; /* FocusOut */

virtual void dagXWindow::eventKeymapNotify(XKeymapEvent xkeymap) {
  if (myParent) myParent->eventKeymapNotify(xkeymap);
}; /* KeymapNotify */

virtual void dagXWindow::eventExpose(XExposeEvent xexpose) {
  if (myParent) myParent->eventExpose(xexpose);
}; /* Expose */

virtual void dagXWindow::eventGraphicExpose(XGraphicsExposeEvent xgraphicsexpose) {
  if (myParent) myParent->eventGraphicExpose(xgraphicsexpose);
}; /* GraphicExpose */

virtual void dagXWindow::eventNoExpose(XNoExposeEvent xnoexpose) {
  if (myParent) myParent->eventNoExpose(xnoexpose);
}; /* NoExpose */

virtual void dagXWindow::eventVisibilityNotify(XVisibilityEvent xvisibility) {
  if (myParent) myParent->eventVisibilityNotify(xvisibility);
}; /* VisibilityNotify */

virtual void dagXWindow::eventCreateNotify(XCreateWindowEvent xcreatewindow) {
  if (myParent) myParent->eventCreateNotify(xcreatewindow);
}; /* CreateNotify */

virtual void dagXWindow::eventDestroyNotify(XDestroyWindowEvent xdestroywindow) {
  if (myParent) myParent->eventDestroyNotify(xdestroywindow);
}; /* DestroyNotify */

virtual void dagXWindow::eventUnmapNotify(XUnmapEvent xunmap) {
  if (myParent) myParent->eventUnmapNotify(xunmap);
}; /* UnmapNotify */

virtual void dagXWindow::eventMapNotify(XMapEvent xmap) {
  if (myParent) myParent->eventMapNotify(xmap);
}; /* MapNotify */

virtual void dagXWindow::eventMapRequest(XMapRequestEvent xmaprequest) {
  if (myParent) myParent->eventMapRequest(xmaprequest);
}; /* MapRequest */

virtual void dagXWindow::eventReparentNotify(XReparentEvent xreparent) {
  if (myParent) myParent->eventReparentNotify(xreparent);
}; /* ReparentNotify */

virtual void dagXWindow::eventConfigureNotify(XConfigureEvent xconfigure) {
  if (myParent) myParent->eventConfigureNotify(xconfigure);
}; /* ConfigureNotify */

virtual void dagXWindow::eventConfigureRequest(XConfigureRequestEvent xconfigurerequest) {
  if (myParent) myParent->eventConfigureRequest(xconfigurerequest);
}; /* ConfigureRequest */

virtual void dagXWindow::eventGravityNotify(XGravityEvent xgravity) {
  if (myParent) myParent->eventGravityNotify(xgravity);
}; /* GravityNotify */

virtual void dagXWindow::eventResizeRequest(XResizeRequestEvent xresizerequest) {
  if (myParent) myParent->eventResizeRequest(xresizerequest);
}; /* ResizeRequest */

virtual void dagXWindow::eventCirculateNotify(XCirculateEvent xcirculate) {
  if (myParent) myParent->eventCirculateNotify(xcirculate);
}; /* CirculateNotify */

virtual void dagXWindow::eventCirculateRequest(XCirculateRequestEvent xcirculaterequest) {
  if (myParent) myParent->eventCirculateRequest(xcirculaterequest);
}; /* CirculateRequest */

virtual void dagXWindow::eventPropertyNotify(XPropertyEvent xproperty) {
  if (myParent) myParent->eventPropertyNotify(xproperty);
}; /* PropertyNotify */

virtual void dagXWindow::eventSelectionClear(XSelectionClearEvent xselectionclear) {
  if (myParent) myParent->eventSelectionClear(xselectionclear);
}; /* SelectionClear */

virtual void dagXWindow::eventSelectionRequest(XSelectionRequestEvent xselectionrequest) {
  if (myParent) myParent->eventSelectionRequest(xselectionrequest);
}; /* SelectionRequest */

virtual void dagXWindow::eventSelectionNotify(XSelectionEvent xselection) {
  if (myParent) myParent->eventSelectionNotify(xselection);
}; /* SelectionNotify */

virtual void dagXWindow::eventColourmapNotify(XColormapEvent xcolormap) {
  if (myParent) myParent->eventColourmapNotify(xcolormap);
}; /* ColourmapNotify */

virtual void dagXWindow::eventClientMessage(XClientMessageEvent xclient) {
  if (myParent) myParent->eventClientMessage(xclient);
}; /* ClientMessage */

virtual void dagXWindow::eventMappingNotify(XMappingEvent xmapping) {
  if (myParent) myParent->eventMappingNotify(xmapping);
}; /* MappingNotify */

/* Declaration of static members */
dagAssocArray<Window, dagXWindow> dagXWindow::allWinList(0 /* No cleanup */);
