/*******************************************************************************************


      modified for DOS MHG feb 96


*******************************************************************************************/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "main.h"
#include "xvid.h"
#include "6502core.h"
#include "disc8271.h"
#include "sysvia.h"


#pragma aux masm "*" parm caller [];

#pragma	aux (masm) SwapModeX_ \
parm [eax]


extern	char	dummy[4*320*256*2];

BeebWin::BeebWin()
{
	for(int i=0;i<8;i++)
	  	cols[i]=i;							// if you aren't using wing (hence no palettes)

	m_screen=(char *)&dummy;
//	InitClass();
//	CreateBeebWindow();
}

BeebWin::~BeebWin()
{
}

char * BeebWin::imageData()
{
	return m_screen;
}

int BeebWin::bytesPerLine() const
{
//	return 320;
	return(320);
}

//extern   int   SCTOP;

//#define	DOWN	56
#define	DOWN	0

typedef struct {
  int Addr;       /* Address of start of next visible character line in beeb memory  - raw */
  int PixmapLine; /* Current line in the pixmap */
  int PreviousFinalPixmapLine; /* The last pixmap line on the previous frame */
  int IsTeletext; /* This frame is a teletext frame - do things differently */
  char *DataPtr;  /* Pointer into host memory of video data */

  int CharLine;   /* 6845 counts in characters vertically - 0 at the top , incs by 1 - -1 means we are in the bit before the actual display starts */
  int InCharLine; /* Scanline within a character line - counts down*/
  int InCharLineUp; /* Scanline within a character line - counts up*/
  int VSyncState; // Cannot =0 in MSVC $NRM; /* When >0 VSync is high */
} VideoStateT;

extern	VideoStateT VideoState;

void BeebWin::updateLines(int starty, int nlines)
{
	char	*dest=(char *)0xa0000;
   char  *scr=&dummy[0];
	int	i;
	int	lines=256;

	if (VideoState.IsTeletext)
	{
		lines=25*9;
		scr=&dummy[0];
		memset(scr+320*lines,0,(256-lines)*320);
	}

//	memcpy(dest,scr,320*240);
	SwapModeX_((char *)scr);
}



EightUChars * BeebWin::GetLinePtr(int y)
{
    if(y > 255) y=255;
	return((EightUChars *)(m_screen + ( y * bytesPerLine() )) );

}

SixteenUChars * BeebWin::GetLinePtr16(int y)
{
    if(y > 255) y=255;
	return((SixteenUChars *)(m_screen + ( y * bytesPerLine() )) );

}

//BOOL BeebWin::InitClass(void)
//{
//}

//void BeebWin::CreateBeebWindow(void)
//{
//}

