//
// my_view.cc
//

#include "sysvia.h"
#include "my_view.h"
#include <stdio.h>

extern bool break_pressed;


my_view::my_view(BRect frame) : BView(frame, "Hello", B_FOLLOW_ALL, B_WILL_DRAW),
	y_offset(0)
{

}

//
// Draw from BitmapView bitmap to deestination view...
//
void my_view::Draw(BRect update)
{
	//puts("my_view->Draw");
//	DrawBitmap(the_bitmap, update, update);
}


//
// Handle key events...
//
void my_view::KeyDown(const char *bytes, int32 numBytes)
{
	if (numBytes == 1) {
		int row, col;
		char key = switch_key(bytes, row, col);

		if (key != -1) {
			BeebKeyDown(row, col);
		}
	}
}

void my_view::KeyUp(const char *bytes, int32 numBytes)
{
	if (numBytes == 1) {
	int row, col;
		char key = switch_key(bytes, row, col);

		if (row == -2 && col == -2) {
			puts("BREAK!!");
			break_pressed = true;
		} else {
			if (key != -1) {
				BeebKeyUp(row, col);
			}
		}
	}
}

char my_view::switch_key(const char *bytes, int &row, int &col)
{
	switch (bytes[0]) {
		case B_ENTER:	row = 4;	col = 9;	break;
		case B_TAB:		row = 6;	col = 0;	break;
		case B_ESCAPE:	row = 7;	col = 0;	break;
		case B_BACKSPACE:
		case B_DELETE:	row = 5;	col = 9;	break;

		case ';': case ':':		row = 5;	col = 7;	break;
		case '-': case '_':		row = 1;	col = 7;	break;
		case '=': case '+':		row = 1;	col = 8;	break;
		case '\'': case '@':	row = 4;	col = 8;	break;
		case '/': case '?':		row = 6;	col = 8;	break;
		case ',': case '<':		row = 6;	col = 6;	break;
		case '.': case '>':		row = 6;	col = 7;	break;
		case ' ':				row = 6;	col = 2;	break;

		// Editing keys...
		case B_UP_ARROW:		row = 3;	col = 9;	break;
		case B_DOWN_ARROW:		row = 2;	col = 9;	break;
		case B_LEFT_ARROW:		row = 1;	col = 9;	break;
		case B_RIGHT_ARROW:		row = 7;	col = 9;	break;
		case B_INSERT:			row = 6;	col = 9;	break;

		// Adjust screen
		case B_PAGE_UP:			if (y_offset) y_offset--;		return -1; break;
		case B_PAGE_DOWN:		if (y_offset < 20) y_offset++;	return -1; break;

		// Alpha...
		case 'a': case 'A':		row = 4;	col = 1;	break;
		case 'b': case 'B':		row = 6;	col = 4;	break;
		case 'c': case 'C':		row = 5;	col = 2;	break;
		case 'd': case 'D':		row	= 3;	col = 2;	break;
		case 'e': case 'E':		row = 2;	col = 2;	break;
		case 'f': case 'F':		row = 4;	col = 3;	break;
		case 'g': case 'G':		row = 5;	col = 3;	break;
		case 'h': case 'H':		row = 5;	col = 4;	break;
		case 'i': case 'I':		row = 2;	col = 5;	break;
		case 'j': case 'J':		row = 4;	col = 5;	break;
		case 'k': case 'K':		row = 4;	col = 6;	break;
		case 'l': case 'L':		row = 5;	col = 6;	break;
		case 'm': case 'M':		row = 6;	col = 5;	break;
		case 'n': case 'N':		row = 5;	col = 5;	break;
		case 'o': case 'O':		row = 3;	col = 6;	break;
		case 'p': case 'P':		row = 3;	col = 7;	break;
		case 'q': case 'Q':		row = 1;	col = 0;	break;
		case 'r': case 'R':		row = 3;	col = 3;	break;
		case 's': case 'S':		row = 5;	col = 1;	break;
		case 't': case 'T':		row = 2;	col = 3;	break;
		case 'u': case 'U':		row = 3;	col = 5;	break;
		case 'v': case 'V':		row = 6;	col = 3;	break;
		case 'w': case 'W':		row = 2;	col = 1;	break;
		case 'x': case 'X':		row = 4;	col = 2;	break;
		case 'y': case 'Y':		row = 4;	col = 4;	break;
		case 'z': case 'Z':		row = 6;	col = 1;	break;

		// Numeric...
		case '1': case '!':		row = 3;	col = 0;	break;
		case '2': case '"':		row = 3;	col = 1;	break;
		case '3': 				row = 1;	col = 1;	break;
		case '4': case '$':		row = 1;	col = 2;	break;
		case '5': case '%':		row = 1;	col = 3;	break;
		case '6': case '^':		row = 3;	col = 4;	break;
		case '7': case '&':		row = 2;	col = 4;	break;
		case '8': case '*':		row = 1;	col = 5;	break;
		case '9': case '(':		row = 2;	col = 6;	break;
		case '0': case ')':		row = 2;	col = 7;	break;

		case B_FUNCTION_KEY: {
			BMessage *m = Window()->CurrentMessage();
			if (m) {
				int32 k;
				m->FindInt32("key", &k);
				switch (k) {
					case B_F1_KEY:	row = 7;	col = 1;	break;
					case B_F2_KEY:	row = 7;	col = 2;	break;
					case B_F3_KEY:	row = 7;	col = 3;	break;
					case B_F4_KEY:	row = 1;	col = 4;	break;
					case B_F5_KEY:	row = 7;	col = 4;	break;
					case B_F6_KEY:	row = 7;	col = 5;	break;
					case B_F7_KEY:	row = 1;	col = 6;	break;
					case B_F8_KEY:	row = 7;	col = 8;	break;
					case B_F9_KEY:	row = 7;	col = 7;	break;
					case B_F10_KEY:	row = 2;	col = 0;	break;
					case B_F12_KEY:	row = -2;	col = -2;	break;
					default:
						puts("Dunno");
						; // Beats me
				}
			}
			break;
		}

		default:	return -1;
	}
	return 0;
}


void my_view::MessageReceived(BMessage *message)
{
	if (message->what == B_MODIFIERS_CHANGED) {
		int32	modifiers;

		if (message->FindInt32("modifiers", &modifiers) == B_OK) {
			if (modifiers & B_SHIFT_KEY) {
				BeebKeyDown(0, 0);
			} else {
				BeebKeyUp(0, 0);
			}
			// Control key plus an alias
			if (modifiers & B_CONTROL_KEY || modifiers & B_COMMAND_KEY) {
				puts("CTRL");
				BeebKeyDown(0, 1);
			} else {
				BeebKeyUp(0, 1);
			}
			if (modifiers & B_CAPS_LOCK) {
				BeebKeyDown(4, 0);
			} else {
				BeebKeyUp(4, 0);
			}

			if (modifiers & B_OPTION_KEY) {
				puts("B_OPTION_KEY");
				BeebKeyDown(4, 0);
			} else {
				BeebKeyUp(4, 0);
			}
			if (modifiers & B_MENU_KEY) {
				puts("B_MENU_LEY");
				//BeebKeyDown(0, 1);
			}
		}
	}
}


