;                                 X86IOPIX.ASM
.MODEL TINY
.STACK 040h
.CODE
.386
;****************************************************************************
;**                   EXEMPLE DE MODULE X86 POUR CpcALive                  **
;**                   AVEC INTGRATION DE COMMANDES RSX                    **
;****************************************************************************
; fonctionnement:
; sur prsence du vecteur MnemoTb  l'adresse 0210h, l'mulateur gnre
; une rom Z80 intgrant la table de mnmoniques (MnemoTb).
; Le premier vecteur de la table "X86Vec" est le vecteur d'initialisation qui
; qui est appel  chaque initialisation du systme Cpc. Chaque mnmonique
; correspond  un vecteur de cette table (dans l'ordre). La fin de chaque
; mnmonique est indique grce  la prsence du bit 7 sur la dernire lettre
; de la mnmonique. La table ne doit pas dpasser 128 mnmoniques et doit
; tre termine par un octet nul.
;****************************************************************************
; Assemblage: A86 X86IOPix.asm     -> cre le fichier X86IOPix.com
; chargement dans l'mulateur, 3 solutions:
; 1-  partir de la ligne de commande Dos: ! X86IOPix.com
; 2-  partir d'un fichier de commande CpcAlive: X86IOPix.com
; 3-  partir de l'interprteur basic du Cpc: |input,"X86IOPix.com":call 0
; commandes  partir de l'interprteur basic du Cpc:
; |OPIX,X,Y,pen                              = OUTPUT PIXEL
; |IPIX,X,Y,@pen                             = INPUT PIXEL
; (X et Y sont relatifs au coin en haut  gauche de l'cran)
;****************************************************************************

START:          push cs
                pop ds
                mov dx,offset Mes
                mov ah,9
                int 021H
                mov ax,04C00h
                int 021h

Mes             db "Ce fichier est un module CpcAlive.",13,10
                db "This file is a CpcAlive module.",13,10
                db "http://cpcalive.com.",13,10,"$"

;UTILIS PAR LE SYSTEME CpcAlive
org 0200h
                db 'X86CPC'             ; 0200h marque
                dw 0                    ; 0206h version
                dw offset X86Vec        ; 0208h adresse table vecteurs d'entre
                dw 0                    ; 020Ah rserv systme CpcAlive
                dw 0                    ; 020Ch rserv systme CpcAlive
                dw 0                    ; 020Eh rserv systme CpcAlive
                dw offset MnemoTb       ; 0210h offset mnmoniques
                db -1                   ; 0212h reoit le numro de module X86
                db -1                   ; 0213h rserv systme CpcAlive
                db -1                   ; 0214h reoit le numro de la rom Z80 associe
                db -1                   ; 0215h rserv systme CpcAlive
                dw 0                    ; 0216h 1ere adresse Cpc accessible
                                        ;       (0=aucune adresse accessible)
                db 0100h-018h dup (0)   ; 0218h rserv systme CpcAlive
;*****************************************************************************

MnemoTb         db "PIXIN","I" or 080h          ; |PIXINI
                db "OPI","X" or 080h            ; |OPIX
                db "IPI","X" or 080h            ; |IPIX
                db 0

X86Vec          dw offset PixIni        ; 00 ** |PIXINI - INIT **
                dw offset OPix          ; 01 ** |OPIX   - SORTIE PIXEL A TRAVERS INT 010H **
                dw offset IPix          ; 02 ** |IPIX   - LECTURE PIXEL A TRAVERS INT 010H **
                ;... 128 vecteurs maximum

PixIni proc far

                pusha
                mov dx,offset IniMes
                mov ah,9
                int 021H
                popa
                stc             ; carry="ok"
                retf

IniMes          db " X86IOPix (c) 2006",13,10
                db "$"

PixIni endp

; ** SORTIE PIXEL A TRAVERS INT 010H **
; < conditions d'entre ds:[SI+0] = numro de pinceau (pen)
;                       ds:[SI+2] = y
;                       ds:[SI+4] = x
OPix proc far

                mov dx,ds:[si+2]        ; coordonne Y
                mov cx,ds:[si+4]        ; coordonne X
                mov al,ds:[si+0]        ; couleur demande
                mov ah,0Ch              ; FONCTION 0CH = ECRIRE UN POINT GRAPHIQUE
                INT 010h                ; APPEL INTERRUPTION BIOS 010H
                retf                    ; RETOUR "FAR"

OPix endp

; ** LECTURE PIXEL A TRAVERS INT 010H **
; < conditions d'entre ds:[SI+2] = y
;                       ds:[SI+4] = x
; > condition de sortie ds:[SI+0] = numro de pinceau (pen)
IPix proc far
                mov dx,ds:[si+2]        ; coordonne Y
                mov cx,ds:[si+4]        ; coordonne X
                mov ah,0Dh              ; FONCTION 0DH = LIRE UN POINT GRAPHIQUE
                INT 010h                ; APPEL INTERRUPTION BIOS 010H
                xor ah,ah
                mov ds:[si+0],ax        ; couleur pixel
                retf                    ; RETOUR "FAR"

IPix endp


end start
