/*	filecomp.c

	Converts a HEX file into a binary file.
	Can be used to generate a COM file for CP/M if it is ORGed to 0x0100.

	(C) 2007 Miguel I. Garcia Lopez.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the
	Free Software Foundation; either version 2 of the License, or (at your
	option) any later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

	Compiled with MESCC.

	Revisions:

	11 May 2007 : v1.00
	16 May 2007 : v1.01 / Minor changes.
*/

#include <mescc.h>
#include <printf.h>
#include <fileio.h>

#define VERSION "1.01 / 16 May 2007"

FILE *fp1, *fp2;

unsigned filepos;

unsigned char byte1, byte2;

int flag_eq;

main(argc, argv)
int argc, argv[];
{
	printf("FileComp v%s\n\n", VERSION);

	if(argc!=3)
	{
		printf("Usage: filecomp file1 file2\n");
		exit(0);
	}

	if((fp1=fopen(argv[1], "rb"))==NULL)
		Error("Opening file 1");

	if((fp2=fopen(argv[2], "rb"))==NULL)
		Error("Opening file 2");

	filepos=0;
	flag_eq=1;

	while(1)
	{
		byte1=fgetc(fp1);
		byte2=fgetc(fp2);

		if(ferror(fp1))
			Error("Reading file 1");
		if(ferror(fp2))
			Error("Reading file 2");

		if(feof(fp1))
		{
			if(!feof(fp2))
			{
				printf("File 2 is bigger than file 1\n");
				flag_eq=0;
			}
			break;
		}

		if(feof(fp2))
		{
			printf("File 1 is bigger than file 2\n");
			flag_eq=0;
			break;
		}

		if(byte1!=byte2)
		{
			printf("%04x : file 1 = %02x / file 2 = %02x\n",
				filepos, byte1, byte2);
			flag_eq=0;
		}

		++filepos;
	}

	if(flag_eq)
		printf("No differences encountered.\n");

	fclose(fp1);
	fclose(fp2);
}

Error(txt)
char *txt;
{
	printf("ERROR: %s.\n", txt);
	exit(1);
}

