/*****************************************************************************
 *****************************************************************************
 Copyright (c) 2001 - 2002, VIA Technologies, Inc.

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of VIA Technologies, Inc. nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/
#ifndef FET_CONFIG_H
#define FET_CONFIG_H

#include <linux/config.h>

typedef __u8	UCHAR,	*PUCHAR;
typedef __u16	U16,	*PU16;
typedef __u8	UINT8,	*PUINT8;
typedef __u32	U32,	*PU32;
typedef __u32	UINT32, *PUINT32;
typedef __u32	UINT, 	*PUINT;
typedef __u8	BYTE,	*PBYTE;
typedef __u8	U8,		*PU8;
typedef __u32	BOOL,	*PBOOL;
typedef __u16  	WORD,	*PWORD;
typedef __u32	DWORD,	*PDWORD;
typedef unsigned long	ULONG,	*PULONG;

typedef
struct _version {
	UINT8	major;
	UINT8	minor;
	UINT8	build;
} version_t, *pversion_t;

#ifndef	FALSE
#define	FALSE	(0)
#endif

#ifndef	TRUE
#define	TRUE	(!(FALSE))
#endif

#define VID_TABLE_SIZE		64
#define MCAST_TABLE_SIZE	64
#define MCAM_SIZE			32
#define VCAM_SIZE			32
#define TX_QUEUE_NO			8

#define RHINE_NAME			"rhinefet"
#define RHINE_FULL_DRV_NAM "D-Link DFE-530TX PCI Fast Ethernet Adapter Driver"

#ifndef MAJOR_VERSION
#define MAJOR_VERSION		4
#endif

#ifndef MINOR_VERSION
#define MINOR_VERSION		16
#endif

#ifndef RHINE_VERSION
#define RHINE_VERSION		"4.16"
#endif

#define PKT_BUF_SZ			1540

#define MALLOC(x,y)			kmalloc((x),(y))
#define FREE(x)				kfree((x))
#define MAX_UINTS			8
#define	OPTION_DEFAULT		{ [0 ... MAX_UINTS-1] = -1}



typedef enum  _chip_type{
	VT86C100A=1,
	VT6102=2,
	VT6105=3,
	VT6105M=4
} CHIP_TYPE, *PCHIP_TYPE;

#endif
