#include "cmaudio.h"

/* revision numbers */
#define VIA_REV_PRE_8233	0x10	/* not in market */
#define VIA_REV_8233C		0x20	/* 2 rec, 4 pb, 1 multi-pb */
#define VIA_REV_8233		0x30	/* 2 rec, 4 pb, 1 multi-pb, spdif */
#define VIA_REV_8233A		0x40	/* 1 rec, 1 multi-pb, spdf */
#define VIA_REV_8235		0x50	/* 2 rec, 4 pb, 1 multi-pb, spdif */

#define VIAREG(via, x) ((via)->opbase + VIA_REG_##x)

/* offsets */
#define VIA_REG_OFFSET_STATUS		0x00	/* byte - channel status */
#define   VIA_REG_STAT_ACTIVE		0x80	/* RO */
#define   VIA_REG_STAT_TRIGGER_QUEUED	0x08	/* RO */
#define   VIA_REG_STAT_STOPPED		0x04	/* RWC */
#define   VIA_REG_STAT_EOL		0x02	/* RWC */
#define   VIA_REG_STAT_FLAG		0x01	/* RWC */
#define VIA_REG_OFFSET_CONTROL		0x01	/* byte - channel control */
#define   VIA_REG_CTRL_START		0x80	/* WO */
#define   VIA_REG_CTRL_TERMINATE	0x40	/* WO */
#define   VIA_REG_CTRL_AUTOSTART	0x20
#define   VIA_REG_CTRL_PAUSE		0x08	/* RW */
#define   VIA_REG_CTRL_INT_STOP		0x04
#define   VIA_REG_CTRL_INT_EOL		0x02
#define   VIA_REG_CTRL_INT_FLAG		0x01
#define   VIA_REG_CTRL_INT (VIA_REG_CTRL_INT_FLAG | VIA_REG_CTRL_INT_EOL | VIA_REG_CTRL_AUTOSTART)
#define VIA_REG_OFFSET_TABLE_PTR	0x04	/* dword - channel table pointer */
#define VIA_REG_OFFSET_CURR_PTR		0x04	/* dword - channel current pointer */
#define VIA_REG_OFFSET_STOP_IDX		0x08	/* dword - stop index, channel type, sample rate */
#define   VIA_REG_TYPE_16BIT		0x00200000	/* RW */
#define   VIA_REG_TYPE_STEREO		0x00100000	/* RW */
#define VIA_REG_OFFSET_CURR_COUNT	0x0c	/* dword - channel current count (24 bit) */
#define VIA_REG_OFFSET_CURR_INDEX	0x0f	/* byte - channel current index */

#define VIA_NUM_OF_DMA_CHANNELS	2

/* playback block (VT8233/8233C) - channels 0-3 (0-0x3f) */
#define VIA_REG_PLAYBACK_STATUS		0x00	/* byte - channel status */
#define VIA_REG_PLAYBACK_CONTROL	0x01	/* byte - channel control */
#define VIA_REG_PLAYBACK_VOLUME_L	0x02	/* byte */
#define VIA_REG_PLAYBACK_VOLUME_R	0x03	/* byte */
#define VIA_REG_PLAYBACK_TABLE_PTR	0x04	/* dword - channel table pointer */
#define VIA_REG_PLAYBACK_CURR_PTR	0x04	/* dword - channel current pointer */
#define VIA_REG_PLAYBACK_STOP_IDX	0x08    /* dword - stop index, channel type, sample rate */
#define VIA_REG_PLAYBACK_CURR_COUNT	0x0c	/* dword - channel current count (24 bit) */
#define VIA_REG_PLAYBACK_CURR_INDEX	0x0f	/* byte - channel current index */

#define VIA_REG_PLAYBACK_CHANNEL_STATUS		0x10	
#define VIA_REG_PLAYBACK_CHANNEL_CTRL		0x11	
#define VIA_REG_PLAYBACK_CHANNEL_TYPE		0x12	
#define VIA_REG_PLAYBACK_CHANNEL_TABLE_PTR	0x14	
#define VIA_REG_PLAYBACK_CHANNEL_CURR_COUNT	0x1c	/* dword - channel current count (24 bit) */

/* multi-channel playback */
#define VIA_REG_MULTPLAY_STATUS		0x40	/* byte - channel status */
#define VIA_REG_MULTPLAY_CONTROL	0x41	/* byte - channel control */
#define VIA_REG_MULTPLAY_FORMAT		0x42	/* byte - format and channels */
#define   VIA_REG_MULTPLAY_FMT_8BIT	0x00
#define   VIA_REG_MULTPLAY_FMT_16BIT	0x80
#define   VIA_REG_MULTPLAY_FMT_CH_MASK	0x70	/* # channels << 4 (valid = 1,2,4,6) */
#define VIA_REG_MULTPLAY_SCRATCH	0x43	/* byte - nop */
#define VIA_REG_MULTPLAY_TABLE_PTR	0x44	/* dword - channel table pointer */
#define VIA_REG_MULTPLAY_CURR_PTR	0x44	/* dword - channel current pointer */
#define VIA_REG_MULTPLAY_STOP_IDX	0x48    /* dword - stop index, slots */
#define VIA_REG_MULTPLAY_CURR_COUNT	0x4c	/* dword - channel current count (24 bit) */
#define VIA_REG_MULTIPLAY_CURR_INDEX	0x4f	/* byte - channel current index */

/* capture block */
#define VIA_REG_CAPTURE_STATUS		0x60	/* byte - channel status */
#define VIA_REG_CAPTURE_CONTROL		0x61	/* byte - channel control */
#define VIA_REG_CAPTURE_FIFO		0x62	/* byte - bit 6 = fifo  enable */
#define   VIA_REG_CAPTURE_FIFO_ENABLE	0x40
#define VIA_REG_CAPTURE_CHANNEL		0x63	/* byte - input select */
#define   VIA_REG_CAPTURE_CHANNEL_MIC	0x4
#define   VIA_REG_CAPTURE_CHANNEL_LINE	0
#define   VIA_REG_CAPTURE_SELECT_CODEC	0x03	/* recording source codec (0 = primary) */
#define VIA_REG_CAPTURE_TABLE_PTR	0x64	/* dword - channel table pointer */
#define VIA_REG_CAPTURE_CURR_PTR	0x64	/* dword - channel current pointer */
#define VIA_REG_CAPTURE_STOP_IDX	0x68	/* dword - stop index */
#define VIA_REG_CAPTURE_CURR_COUNT	0x6c	/* dword - channel current count (24 bit) */
#define VIA_REG_CAPTURE_CURR_INDEX	0x6f	/* byte - channel current index */
/* AC'97 */
#define VIA_REG_AC97			0x80	/* dword */
#define   VIA_REG_AC97_CODEC_ID_MASK	(3<<30)
#define   VIA_REG_AC97_CODEC_ID_SHIFT	30
#define   VIA_REG_AC97_SECONDARY_VALID	(1<<27)
#define   VIA_REG_AC97_PRIMARY_VALID	(1<<25)
#define   VIA_REG_AC97_ANY_VALID	(VIA_REG_AC97_PRIMARY_VALID | VIA_REG_AC97_SECONDARY_VALID | (1<<28)| (1<<29))
#define   VIA_REG_AC97_BUSY		(1<<24)
#define   VIA_REG_AC97_READ		(1<<23)
#define   VIA_REG_AC97_CMD_SHIFT	16
#define   VIA_REG_AC97_CMD_MASK		0x7e
#define   VIA_REG_AC97_DATA_SHIFT	0
#define   VIA_REG_AC97_DATA_MASK	0xffff
#define VIA_REG_SGD_SHADOW		0x84	/* dword */

void RequestRegion_VIA_82cxxx(struct cmedia_card *card)
{
    request_region(card->opbase, 256, card_names[card->driver_data]);
}

void ReleaseRegion_VIA_82cxxx(struct cmedia_card *card)
{
    release_region(card->opbase, 256);
}

int Initial_VIA_82cxxx(struct cmedia_card *card)
{
    u16 wValue, wValue1, wValue2, i, eid;

    // enable I/O space
    pci_read_config_word(card->pci_dev, 0x04, &wValue);
    wValue |= 0x01;
    pci_write_config_word(card->pci_dev, 0x04, wValue);

    // clear Function Enable
    pci_read_config_word(card->pci_dev, 0x42, &wValue);
    wValue &= 0xff00;
    pci_write_config_word(card->pci_dev, 0x42, wValue);

    // judge ACLink should be reset
    pci_read_config_word(card->pci_dev, 0x40, &wValue);
    wValue &= 0xff03;

    // test to see if ACLink need reset
    if(wValue != 0xcc01)
    {
        // ACLink interface status
        wValue = 0x00ff;
        pci_write_config_word(card->pci_dev, 0x40, wValue);
        udelay(10);

        // ACLink interface status and control
        wValue = 0x40ff;
        pci_write_config_word(card->pci_dev, 0x40, wValue);
        udelay(10);

        // ACLink interface status and control
        wValue = 0x60ff;
        pci_write_config_word(card->pci_dev, 0x40, wValue);
        udelay(10);

        // ACLink interface status and control
        wValue = 0xccff;
        pci_write_config_word(card->pci_dev, 0x40, wValue);
        udelay(10);
    }

    pci_read_config_word(card->pci_dev, 0x02, &wValue);

    if(wValue == 0x3059) // VT8233
    {   
        outb(0x00, card->opbase+VIA_REG_MULTPLAY_CONTROL);
        udelay(10);

        outb(0x40, card->opbase+VIA_REG_MULTPLAY_CONTROL);
        outb(0x07, card->opbase+VIA_REG_MULTPLAY_STATUS);

        // DXS channel 0 SGD table pointer base
        outl(0x00000000, card->opbase+VIA_REG_MULTPLAY_TABLE_PTR);
        
        outb(0x00, card->opbase+VIA_REG_CAPTURE_CONTROL);
        udelay(10);
        outb(0x40, card->opbase+VIA_REG_CAPTURE_CONTROL);

        outb(0x07, card->opbase+VIA_REG_CAPTURE_STATUS);
        outb(0x00, card->opbase+VIA_REG_CAPTURE_FIFO);

        // SGD write channel table pointer base
        outl(0x00000000, card->opbase+VIA_REG_CAPTURE_TABLE_PTR);
    }   
    else  // 82C686A/82C686B
    {   
        outb(0x49, card->opbase+VIA_REG_PLAYBACK_CONTROL);
        udelay(10);
        outb(0x00, card->opbase+VIA_REG_PLAYBACK_CONTROL);

        outb(0xff, card->opbase+VIA_REG_PLAYBACK_STATUS);
        outb(0x00, card->opbase+VIA_REG_PLAYBACK_VOLUME_L);

        // DXS channel 0 SGD table pointer base
        outl(0x00000000, card->opbase+VIA_REG_PLAYBACK_TABLE_PTR);

        outb(0x49, card->opbase+VIA_REG_PLAYBACK_CHANNEL_CTRL);
        udelay(10);
        outb(0x00, card->opbase+VIA_REG_PLAYBACK_CHANNEL_CTRL);
        outb(0xff, card->opbase+VIA_REG_PLAYBACK_CHANNEL_STATUS);
        outb(0x00, card->opbase+VIA_REG_PLAYBACK_CHANNEL_TYPE);

        // DXS channel 1 SGD table pointer base
        outl(0x00000000, card->opbase+VIA_REG_PLAYBACK_CHANNEL_TABLE_PTR);
    }   
    
    pci_read_config_word(card->pci_dev, 0x40, &wValue);

    // Codec Cold Reset
    card->WriteRegisterWord(card, AC97REG_RESET, 0x00);

    // AC Link interface status
    pci_read_config_word(card->pci_dev, 0x40, &wValue1);
    wValue2 = wValue1;

    if((unsigned char)(wValue2) != 0)
    {
        // bit 14 set to "0"
        wValue2 &= 0xbfff;
        pci_write_config_word(card->pci_dev, 0x40, wValue2);
        udelay(10);

        // bit 14 pull back to "1"
        wValue1 |= 0x4000;
        pci_write_config_word(card->pci_dev, 0x40, wValue1);
        udelay(10);
    }
    
    wValue = 0xc400;
    pci_write_config_word(card->pci_dev, 0x40, wValue);
    udelay(10);

    /* power up everything, modify this when implementing power saving */
    card->WriteRegisterWord(card, AC97_POWER_CONTROL, 
        card->ReadRegisterWord(card, AC97_POWER_CONTROL) & ~0x7f00);

    /* wait for analog ready */
    for (i=10; i && ((card->ReadRegisterWord(card, AC97_POWER_CONTROL) & 0xf) != 0xf); i--)
    {
        current->state = TASK_UNINTERRUPTIBLE;
        schedule_timeout(HZ/20);
    }

    /* Don't attempt to get eid until powerup is complete */
    eid = card->ReadRegisterWord(card, AC97_EXTENDED_ID);
		
    if(eid==0xFFFFFF)
    {
        printk(KERN_WARNING "CMedia Audio: no codec attached ?\n");
        return 0;
    }
		
    card->ac97_features = eid;
				
    /* Now check the codec for useful features to make up for
       the dumbness of the 810 hardware engine */

    if(eid&0x0001)
    {
        printk(KERN_WARNING "CMedia Audio: Codec refused to allow VRA, using 48Khz only.\n");
        card->ac97_features&=~1;
    }

    card->ac97_vender_id1 = card->ReadRegisterWord(card, AC97REG_VENDOR_ID1);   		
    printk(KERN_INFO "CMedia Audio: AC97REG_VENDOR_ID1=%x\n", card->ac97_vender_id1);
    card->ac97_vender_id2 = card->ReadRegisterWord(card, AC97REG_VENDOR_ID2);   		
    printk(KERN_INFO "CMedia Audio: AC97REG_VENDOR_ID2=%x\n", card->ac97_vender_id2);

    if (card->ac97_vender_id1 != 0x434d)
    {
        printk(KERN_ERR "CMedia Audio: CMedia codec not found.\n");
        return 0;
    }

    return 1;
}

u16 ReadRegisterWord_VIA_82cxxx(struct cmedia_card *card, u8 reg)
{
    unsigned char Temp;
    unsigned long Count=0;
    unsigned char bRegIndex = reg|0x80; // the offset of codec register is word

    // to see if codec is ready for taking a register access command
    Temp = inb(card->opbase+0x0083);
    while ((Temp&0x01) && (Count<100)) { Temp = inb(card->opbase+0x0083); Count++; udelay(10); }

    // select codec ID = 00
    outb(inb(card->opbase+0x0083)&0x3f, card->opbase+0x0083);

    // AC97 controller codec register index --- write codec index first
    outb(bRegIndex, card->opbase+0x0082);

    // to see if codec data is ready
    Temp = inb(card->opbase+0x0083);
    Count=0;
    while (!(Temp&0x02) && (Count<256)) { Temp = inb(card->opbase+0x0083); Count++; udelay(10); }

    // AC97 controller codec register data --- Read the data second
    return inw(card->opbase+0x0080);
}

void WriteRegisterWord_VIA_82cxxx(struct cmedia_card *card, u8 reg, u16 data)
{
    unsigned char Temp;
    unsigned long Count=0;
    unsigned char bRegIndex = reg&0x7f; // the offset of codec register is word

    // to see if codec is ready for taking a register access command
    Temp = inb(card->opbase+0x0083);
    while ((Temp&0x01) && (Count<100)) { Temp = inb(card->opbase+0x0083); Count++; udelay(10); }

    // select codec ID = 00
    outb(inb(card->opbase+0x0083)&0x3f, card->opbase+0x0083);

    Temp = inb(card->opbase+0x0083);
    Count=0;
    while ((Temp&0x01) && Count < 100) { Temp = inb(card->opbase+0x0083); Count++; udelay(10); }
    
    // AC97 controller codec register data --- Write the data first
    outw(data, card->opbase+0x0080);

    Temp = inb(card->opbase+0x0083);
    Count=0;
    while ((Temp&0x01) && (Count<100)) { Temp = inb(card->opbase+0x0083); Count++; udelay(10); }
    
    // AC97 controller codec register index --- write codec index second
    outb(bRegIndex, card->opbase+0x0082);
}

void StartADC_VIA_82cxxx(struct cmedia_card *card)
{
    unsigned long flags;
    unsigned char Temp;
    unsigned long Count=0;

    if (!(card->dma_state & ADC_RUNNING)) 
    {
        spin_lock_irqsave(&card->lock, flags);
        card->dma_state |= ADC_RUNNING;

        if(card->driver_data == VIA8233) // VT8233
        {   
            Temp = inb(card->opbase+VIA_REG_CAPTURE_STATUS);
            if (Temp & 0x80)
            {
                outb(0x00, card->opbase+VIA_REG_CAPTURE_CONTROL);
                outb(0x40, card->opbase+VIA_REG_CAPTURE_CONTROL);
                outb(0x07, card->opbase+VIA_REG_CAPTURE_STATUS);
            }
            outb(0x27, card->opbase+VIA_REG_CAPTURE_CONTROL);

            Temp = inb(card->opbase+VIA_REG_CAPTURE_STATUS);
            Count=0;
            while ((Temp&0x03) && Count < 100)
            {
                outb(0xff, card->opbase+VIA_REG_CAPTURE_STATUS);
                udelay(10);
                Temp = inb(card->opbase+VIA_REG_CAPTURE_STATUS);
                Count++;
            }

            outb(0xa0, card->opbase+VIA_REG_CAPTURE_CONTROL);
        }
        else // VT82C686
        {   
            Temp = inb(card->opbase+VIA_REG_PLAYBACK_CHANNEL_STATUS);
            if (Temp & 0x80)
            {
                outb(0x00, card->opbase+VIA_REG_PLAYBACK_CHANNEL_CTRL);
                outb(0x40, card->opbase+VIA_REG_PLAYBACK_CHANNEL_CTRL);
                outb(0x07, card->opbase+VIA_REG_PLAYBACK_CHANNEL_STATUS);
            }
            outb(0x27, card->opbase+VIA_REG_PLAYBACK_CHANNEL_CTRL);

            Temp = inb(card->opbase+VIA_REG_PLAYBACK_CHANNEL_STATUS);
            Count=0;
            while ((Temp&0x03) && Count < 100)
            {
                outb(0xff, card->opbase+VIA_REG_PLAYBACK_CHANNEL_STATUS);
                udelay(10);
                Temp = inb(card->opbase+VIA_REG_PLAYBACK_CHANNEL_STATUS);
                Count++;
            }

            outb(0xb0, card->opbase+VIA_REG_PLAYBACK_CHANNEL_TYPE);
            outb(0x80, card->opbase+VIA_REG_PLAYBACK_CHANNEL_CTRL);
        }

        spin_unlock_irqrestore(&card->lock, flags);
    }
}

/* Stop recording (lock held) */
void StopADC_VIA_82cxxx(struct cmedia_card *card)
{
    card->dma_state &= ~ADC_RUNNING;

    if(card->driver_data == VIA8233) // VT8233
    {   
        outb(0x40, card->opbase+0x61);
    }
    else // VT82C686
    {   
        outb(0x40, card->opbase+0x11);
    }

    memset(card->pcmin_rawbuf, 0, PCMIN_DMABUF_SIZE);
}

void StartDAC_VIA_82cxxx(struct cmedia_card *card)
{
    u16 val;
    unsigned long flags;
    unsigned char Temp;
    unsigned long Count=0;

    if (!(card->dma_state & DAC_RUNNING)) 
    {
        spin_lock_irqsave(&card->lock, flags);
        card->dma_state |= DAC_RUNNING;

        if(card->driver_data == VIA8233) // VT8233
        {   
            Temp = inb(card->opbase+VIA_REG_MULTPLAY_STATUS);
            if (Temp & 0x80)
            {
                outb(0x00, card->opbase+VIA_REG_MULTPLAY_CONTROL);
                outb(0x40, card->opbase+VIA_REG_MULTPLAY_CONTROL);
                outb(0x07, card->opbase+VIA_REG_MULTPLAY_STATUS);
            }
            outb(0x20, card->opbase+VIA_REG_MULTPLAY_CONTROL);

            Temp = inb(card->opbase+VIA_REG_MULTPLAY_STATUS);
            Count=0;
            while ((Temp&0x03) && Count < 100)
            {
                outb(0xff, card->opbase+VIA_REG_MULTPLAY_STATUS);
                udelay(10);
                Temp = inb(card->opbase+VIA_REG_MULTPLAY_STATUS);
                Count++;
            }

            outb(0xa0, card->opbase+VIA_REG_MULTPLAY_CONTROL);
        }
        else // VT82C686
        {   
            Temp = inb(card->opbase+VIA_REG_PLAYBACK_STATUS);
            Count=0;
            while ((Temp&0x03) && Count < 100)
            {
                outb(0xff, card->opbase+VIA_REG_PLAYBACK_STATUS);
                udelay(10);
                Temp = inb(card->opbase+VIA_REG_PLAYBACK_STATUS);
                Count++;
            }

            outb(0xb0, card->opbase+VIA_REG_PLAYBACK_VOLUME_L);
            outb(0x80, card->opbase+VIA_REG_PLAYBACK_CONTROL);
        }
        spin_unlock_irqrestore(&card->lock, flags);
    }

    if (card->ac97_vender_id2==0x4961 && card->bMonitorSPDIF)
    {
        val = card->ReadRegisterWord(card, AC97REG_SPDIF_FUNCTION);
        card->WriteRegisterWord(card , AC97REG_SPDIF_FUNCTION, val&(~0x08));
    }
}

/* stop playback (lock held) */
static inline void __StopDAC_VIA_82cxxx(struct cmedia_card *card)
{
    u16 val;
    card->dma_state &= ~DAC_RUNNING;

    if(card->driver_data == VIA8233) // VT8233
    {   
        outb(0x40, card->opbase+0x41);
    }
    else // VT82C686
    {   
        outb(0x40, card->opbase+0x01);
    }

    memset(card->pcmout_rawbuf, 0, PCMOUT_DMABUF_SIZE);
    memset(card->dmaout_rawbuf, 0, PCMOUT_DMABUF_SIZE);

    if (card->ac97_vender_id2==0x4961 && card->bMonitorSPDIF)
    {
        val = card->ReadRegisterWord(card, AC97REG_SPDIF_FUNCTION);
        card->WriteRegisterWord(card , AC97REG_SPDIF_FUNCTION, val|0x08);
    }
}

/* update buffer manangement pointers */
void UpdatePtr_VIA_82cxxx(struct cmedia_card *card)
{
    int port; 
    if(!card->dma_state) return;

    port = card->opbase;

    if(card->driver_data == VIA8233) // VT8233
    {
        if (card->dma_state & ADC_RUNNING) 
        {
            card->pcmin_hwptr = PCMIN_DMABUF_SIZE-(inl(port+VIA_REG_CAPTURE_CURR_COUNT)&0x00ffffff);
            card->pcmin_hwptr -= card->pcmin_hwptr%4;

            outb(inb(port+VIA_REG_CAPTURE_STATUS), port+VIA_REG_CAPTURE_STATUS);
        }

        if (card->dma_state & DAC_RUNNING) 
        {
            if (output_channels == 2)
            {
                card->pcmout_hwptr = (PCMOUT_DMABUF_SIZE/3)-(inl(port+VIA_REG_MULTPLAY_CURR_COUNT)&0x00ffffff);
                card->pcmout_hwptr -= card->pcmout_hwptr%4;
                card->pcmout_hwptr = card->pcmout_hwptr*3;
            }
            else if (output_channels == 4)
            {
                card->pcmout_hwptr = (PCMOUT_DMABUF_SIZE*2/3)-(inl(port+VIA_REG_MULTPLAY_CURR_COUNT)&0x00ffffff);
                card->pcmout_hwptr -= card->pcmout_hwptr%8;
                card->pcmout_hwptr = card->pcmout_hwptr*3/2;
            }
            else 
            {
                card->pcmout_hwptr = PCMOUT_DMABUF_SIZE-(inl(port+VIA_REG_MULTPLAY_CURR_COUNT)&0x00ffffff);
                card->pcmout_hwptr -= card->pcmout_hwptr%12;
            }

            outb(inb(port+VIA_REG_MULTPLAY_STATUS), port+VIA_REG_MULTPLAY_STATUS);
        }
    }
    else
    {
        if (card->dma_state & ADC_RUNNING) 
        {
            card->pcmin_hwptr = 
                PCMIN_DMABUF_SIZE-(inl(port+VIA_REG_PLAYBACK_CHANNEL_CURR_COUNT)&0x00ffffff);
            card->pcmin_hwptr -= card->pcmin_hwptr%4;

            outb(inb(port+VIA_REG_PLAYBACK_CHANNEL_STATUS), port+VIA_REG_PLAYBACK_CHANNEL_STATUS);
        }

        if (card->dma_state & DAC_RUNNING) 
        {
            if (output_channels == 2)
            {
                card->pcmout_hwptr = 
                    (PCMOUT_DMABUF_SIZE/3)-(inl(port+VIA_REG_PLAYBACK_CURR_COUNT)&0x00ffffff);
                card->pcmout_hwptr -= card->pcmout_hwptr%4;
                card->pcmout_hwptr = card->pcmout_hwptr*3;
            }
            else if (output_channels == 4)
            {
                card->pcmout_hwptr = 
                    (PCMOUT_DMABUF_SIZE*2/3)-(inl(port+VIA_REG_PLAYBACK_CURR_COUNT)&0x00ffffff);
                card->pcmout_hwptr -= card->pcmout_hwptr%8;
                card->pcmout_hwptr = card->pcmout_hwptr*3/2;
            }
            else
            {
                card->pcmout_hwptr = 
                    PCMOUT_DMABUF_SIZE-(inl(port+VIA_REG_PLAYBACK_CURR_COUNT)&0x00ffffff);
                card->pcmout_hwptr -= card->pcmout_hwptr%12;
            }

            outb(inb(port+VIA_REG_PLAYBACK_STATUS), port+VIA_REG_PLAYBACK_STATUS);
        }
    }
}

int DrainDAC_VIA_82cxxx(struct cmedia_card *card)
{
    __StopDAC_VIA_82cxxx(card);

    return 0;
}

int ProgramDMABuffer_VIA_82cxxx(struct cmedia_card *card)
{
    struct sg_item *sg;
    unsigned long flags=0;
    int i;
    u32 busaddr, dwTemp;

    spin_lock_irqsave(&card->lock, flags);
    card->pcmout_count = card->pcmin_count = 0;
    card->pcmout_swptr = card->pcmout_hwptr = card->pcmin_swptr = card->pcmin_hwptr = 0;

    memset(card->pcmout_rawbuf, 0, PCMOUT_DMABUF_SIZE);
    memset(card->dmaout_rawbuf, 0, PCMOUT_DMABUF_SIZE);
    memset(card->pcmin_rawbuf, 0, PCMIN_DMABUF_SIZE);

    if(card->driver_data == VIA82686) output_channels = 2;

    // Playback
    sg=&card->pcmout_buffer_descriptor.sg[0];
    busaddr=virt_to_bus(card->dmaout_rawbuf);
    for(i=0; i<SG_LEN; i++) 
    {
        sg->busaddr=busaddr;
        if (output_channels == 2)
        {
            if (i == (SG_LEN-1)) sg->control=0x80000000|(PCMOUT_DMABUF_SIZE/3);
            else sg->control=0x00000000|(PCMOUT_DMABUF_SIZE/3);
        }
        else if (output_channels == 4)
        {    
            if (i == (SG_LEN-1)) sg->control=0x80000000|(PCMOUT_DMABUF_SIZE*2/3);
            else sg->control=0x00000000|(PCMOUT_DMABUF_SIZE*2/3);
        }
        else 
        {    
            if (i == (SG_LEN-1)) sg->control=0x80000000|(PCMOUT_DMABUF_SIZE);
            else sg->control=0x00000000|(PCMOUT_DMABUF_SIZE);
        }
        sg++;
    }

    if(card->driver_data == VIA8233) // VT8233
    {   
        // Assign Buffer Descriptor Base Address
        outl(virt_to_bus(&card->pcmout_buffer_descriptor.sg[0]), card->opbase+VIA_REG_MULTPLAY_TABLE_PTR);

        // Assign Last Valid Index and Slot mapping
        dwTemp=inl(card->opbase+VIA_REG_MULTPLAY_STOP_IDX);
        dwTemp &= 0x00ffffff; dwTemp |= 0xff000000;
        outl(dwTemp, card->opbase+VIA_REG_MULTPLAY_STOP_IDX);

        // Enable PCM 2 Channel
        if (output_channels == 2) outb(0xa0, card->opbase+VIA_REG_MULTPLAY_FORMAT);
        else if (output_channels == 4) outb(0xc0, card->opbase+VIA_REG_MULTPLAY_FORMAT);
        else outb(0xe0, card->opbase+VIA_REG_MULTPLAY_FORMAT);

        dwTemp=inl(card->opbase+VIA_REG_MULTPLAY_STOP_IDX);
        dwTemp &= 0xff000000; dwTemp |= 0x00654321;
        outl(dwTemp, card->opbase+VIA_REG_MULTPLAY_STOP_IDX);
    }
    else
    {
        // Set PCM 16-bit and stereo
        outb(inb(card->opbase+VIA_REG_PLAYBACK_VOLUME_L)|0xb0, card->opbase+VIA_REG_PLAYBACK_VOLUME_L);

        // Assign Buffer Descriptor Base Address
        outl(virt_to_bus(&card->pcmout_buffer_descriptor.sg[0]), card->opbase+VIA_REG_PLAYBACK_TABLE_PTR);
    }

    // Recording
    sg=&card->pcmin_buffer_descriptor.sg[0];
    busaddr=virt_to_bus(card->pcmin_rawbuf);
    for(i=0; i<SG_LEN; i++) 
    {
        sg->busaddr=busaddr;
        if (i == (SG_LEN-1)) sg->control=0x80000000|PCMIN_DMABUF_SIZE;
        else sg->control=0x00000000|PCMIN_DMABUF_SIZE;
        sg++;
    }

    if(card->driver_data == VIA8233) // VT8233
    {   
        // Assign Buffer Descriptor Base Address
        outl(virt_to_bus(&card->pcmin_buffer_descriptor.sg[0]), card->opbase+VIA_REG_CAPTURE_TABLE_PTR);

        // Assign Last Valid Index and format
        dwTemp=inl(card->opbase+VIA_REG_CAPTURE_STOP_IDX);
        dwTemp &= 0x000fffff; dwTemp |= 0xff300000;
        outl(dwTemp, card->opbase+VIA_REG_CAPTURE_STOP_IDX);

        // Select Source
        outb(0x0, card->opbase+VIA_REG_CAPTURE_FIFO);
        outb(0x0, card->opbase+VIA_REG_CAPTURE_CHANNEL);
    }
    else
    {
        // Set PCM 16-bit and stereo
        outb(inb(card->opbase+VIA_REG_PLAYBACK_CHANNEL_TYPE)|0xb0, 
             card->opbase+VIA_REG_PLAYBACK_CHANNEL_TYPE);

        // Assign Buffer Descriptor Base Address
        outl(virt_to_bus(&card->pcmin_buffer_descriptor.sg[0]), 
             card->opbase+VIA_REG_PLAYBACK_CHANNEL_TABLE_PTR);
    }

    spin_unlock_irqrestore(&card->lock, flags);

    return 0;
}

void ConvertPCMOUT_VIA_82cxxx(struct cmedia_card *card)
{
    short *ptrSource, *ptrTarget;
    unsigned long i, len1, len2;
    len1=len2=0;

    if (card->pcmout_swptr < card->pcmout_hwptr)
    {
        len1 = ((card->pcmout_hwptr-card->pcmout_swptr)>>1)/6;
    }
    else
    {
        len1 = ((PCMOUT_DMABUF_SIZE-card->pcmout_swptr)>>1)/6;
        len2 = ((card->pcmout_hwptr)>>1)/6;
    }

    if (output_channels==2) // Front Left/Right
    {
        ptrSource=(short *)(card->pcmout_rawbuf+card->pcmout_swptr);
        ptrTarget=(short *)(card->dmaout_rawbuf+card->pcmout_swptr/3);
        for(i=0; i<len1; i++)
        {
            *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
            *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
            ptrSource++;ptrSource++;ptrSource++;ptrSource++;
        }

        ptrSource=(short *)(card->pcmout_rawbuf);
        ptrTarget=(short *)(card->dmaout_rawbuf);
        for(i=0; i<len2; i++)
        {
            *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
            *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
            ptrSource++;ptrSource++;ptrSource++;ptrSource++;
        }
    }

    if (output_channels==4) // Front Left/Right, Rear Left/Right
    {
        ptrSource=(short *)(card->pcmout_rawbuf+card->pcmout_swptr);
        ptrTarget=(short *)(card->dmaout_rawbuf+card->pcmout_swptr*2/3);
        if (card->XearMode)
        {
            for(i=0; i<len1; i++)
            {
                *(ptrTarget+2)=*ptrSource; ptrSource++; 
                *(ptrTarget+3)=*ptrSource; ptrSource++;
                *ptrTarget=*ptrSource; ptrSource++;
                *(ptrTarget+1)=*ptrSource; ptrSource++;
                ptrTarget++;ptrTarget++;ptrTarget++;ptrTarget++;
                ptrSource++;ptrSource++;
            }
        }
        else
        {
            for(i=0; i<len1; i++)
            {
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                ptrSource++;ptrSource++;
            }
        }

        ptrSource=(short *)(card->pcmout_rawbuf);
        ptrTarget=(short *)(card->dmaout_rawbuf);
        if (card->XearMode)
        {
            for(i=0; i<len2; i++)
            {
                *(ptrTarget+2)=*ptrSource; ptrSource++; 
                *(ptrTarget+3)=*ptrSource; ptrSource++;
                *ptrTarget=*ptrSource; ptrSource++;
                *(ptrTarget+1)=*ptrSource; ptrSource++;
                ptrTarget++;ptrTarget++;ptrTarget++;ptrTarget++;
                ptrSource++;ptrSource++;
            }
        }
        else
        {
            for(i=0; i<len2; i++)
            {
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                ptrSource++;ptrSource++;
            }
        }
    }

    if (output_channels==6) // Front Left/Right, Rear Left/Right, Center/Bass
    {
        ptrSource=(short *)(card->pcmout_rawbuf+card->pcmout_swptr);
        ptrTarget=(short *)(card->dmaout_rawbuf+card->pcmout_swptr);
        if (card->XearMode)
        {
            for(i=0; i<len1; i++)
            {
                *(ptrTarget+2)=*ptrSource; ptrSource++; 
                *(ptrTarget+3)=*ptrSource; ptrSource++;
                *ptrTarget=*ptrSource; ptrSource++;
                *(ptrTarget+1)=*ptrSource; ptrSource++;
                ptrTarget++;ptrTarget++;ptrTarget++;ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
            }
        }
        else
        {
            for(i=0; i<len1; i++)
            {
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
            }
        }

        ptrSource=(short *)(card->pcmout_rawbuf);
        ptrTarget=(short *)(card->dmaout_rawbuf);
        if (card->XearMode)
        {
            for(i=0; i<len2; i++)
            {
                *(ptrTarget+2)=*ptrSource; ptrSource++; 
                *(ptrTarget+3)=*ptrSource; ptrSource++;
                *ptrTarget=*ptrSource; ptrSource++;
                *(ptrTarget+1)=*ptrSource; ptrSource++;
                ptrTarget++;ptrTarget++;ptrTarget++;ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
            }
        }
        else
        {
            for(i=0; i<len2; i++)
            {
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
                *ptrTarget=*ptrSource; ptrSource++; ptrTarget++;
            }
        }
    }
}
