/***************************************************************************
                          cmconfig.c  -  description
                             -------------------
    begin                : 02/19/2003
    author               : Feng Min-Chih (from C-Media Electronics Inc.)
    email                : min_chih@cmedia.com.tw
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>

#define SNDCTL_DSP_LINEINASREAR	        _SIOWR ('P', 68, int)
#define SNDCTL_DSP_MICASCENTERBASS      _SIOWR ('P', 69, int)
#define SNDCTL_DSP_XEAR                 _SIOWR ('P', 70, int)
#define SNDCTL_DSP_MICSELECT2           _SIOWR ('P', 71, int)
#define SNDCTL_DSP_MIX2SURROUND         _SIOWR ('P', 72, int)

int main(int argc, char *argv[])
{
    int fd;            /* device file descriptor */
    int status, arg;
    int LineInAsRearAvailable;
    int LineInAsRear;
    int MicAsCenterBassAvailable;
    int MicAsCenterBass;
    int XearModeAvailable;
    int XearMode;
    int MicSelect2Available;
    int MicSelect2;
    int Mix2SurroundAvailable;
    int Mix2Surround;
    int KeyPress;

    /* open device */
    status = fd = open("/dev/dsp", O_WRONLY | O_SYNC);
    if (status == -1) 
    {
        perror("error opening /dev/dsp");
        exit(1);
    }

    /* set a parameter using ioctl call */
    LineInAsRear = -1; 
    status = ioctl(fd, SNDCTL_DSP_LINEINASREAR, &LineInAsRear);
    if (LineInAsRear != -1) LineInAsRearAvailable=1; else LineInAsRearAvailable=0;

    MicAsCenterBass = -1; 
    status = ioctl(fd, SNDCTL_DSP_MICASCENTERBASS, &MicAsCenterBass);
    if (MicAsCenterBass != -1) MicAsCenterBassAvailable=1; else MicAsCenterBassAvailable=0;

    XearMode = -1; 
    status = ioctl(fd, SNDCTL_DSP_XEAR, &XearMode);
    if (XearMode != -1) XearModeAvailable=1; else XearModeAvailable=0;

    MicSelect2 = -1; 
    status = ioctl(fd, SNDCTL_DSP_MICSELECT2, &MicSelect2);
    if (MicSelect2 != -1) MicSelect2Available=1; else MicSelect2Available=0;

    Mix2Surround = -1; 
    status = ioctl(fd, SNDCTL_DSP_MIX2SURROUND, &Mix2Surround);
    if (Mix2Surround != -1) Mix2SurroundAvailable=1; else Mix2SurroundAvailable=0;

    if (!(LineInAsRearAvailable || MicAsCenterBassAvailable || XearModeAvailable || MicSelect2Available
        || Mix2SurroundAvailable))
    {
        printf("There is no configuration settings can be changed!\n");
        return (0);
    }

    do
    {
        printf("\n\n**************************************************************\nConfiguration:\n");
        if (LineInAsRearAvailable)
        {
            if (LineInAsRear) 
                printf("    * Line in phone jack is used to be surround speakers output.\n");
            else 
                printf("    * Line in phone jack is used to be analog signal input.\n");
        }

        if (MicAsCenterBassAvailable)
        {
            if (MicAsCenterBass) 
                printf("    * Microphone in phone jack is used to be center/bass output.\n");
            else 
                printf("    * Microphone in phone jack is used to be microphone input.\n");
        }

        if (XearModeAvailable)
        {
            if (XearMode) 
                printf("    * Front and surround speakers output is swapped.(Xear mode)\n");
            else
                printf("    * Front and surround speakers output is not swapped.(Normal mode)\n");
        }

        if (MicSelect2Available)
        {
            if (MicSelect2) 
                printf("    * Using microphone 2 as the microphone input source\n");
            else
                printf("    * Using microphone 1 as the microphone input source\n");
        }

        if (Mix2SurroundAvailable)
        {
            if (Mix2Surround) 
                printf("    * Analog input pass to surround channel\n");
            else
                printf("    * Analog input does not pass to surround channel\n");
        }

        printf("\n\nFunctions:\n");
        if (LineInAsRearAvailable)
        {
            if (!LineInAsRear) 
                printf("    1. Line in phone jack is used to be surround speakers output.\n");
            else
                printf("    1. Line in phone jack is used to be analog signal input.\n");
        }
        if (MicAsCenterBassAvailable)
        {
            if (!MicAsCenterBass) 
                printf("    2. Microphone in phone jack is used to be center/bass output.\n");
            else
                printf("    2. Microphone in phone jack is used to be microphone input.\n");
        }
        if (XearModeAvailable)
        {
            if (!XearMode) 
                printf("    3. Front and surround speakers output is swapped.(Xear mode)\n");
            else
                printf("    3. Front and surround speakers output is not swapped.(Normal mode)\n");
        }
        if (MicSelect2Available)
        {
            if (!MicSelect2) 
                printf("    4. Using microphone 1 as the microphone input source\n");
            else
                printf("    4. Using microphone 2 as the microphone input source\n");
        }
        if (Mix2SurroundAvailable)
        {
            if (!Mix2Surround) 
                printf("    5. Analog input pass to surround channel\n");
            else
                printf("    5. Analog input does not pass to surround channel\n");
        }
        printf("    0. Exit.\n");

        printf("\n\nPlease enter your choice : ");
        KeyPress = getchar();
        switch(KeyPress)
        {
        case '1':
            if (LineInAsRear) LineInAsRear = 0; else LineInAsRear = 1;
            status = ioctl(fd, SNDCTL_DSP_LINEINASREAR, &LineInAsRear);
            if (status != 0) LineInAsRearAvailable=0; else LineInAsRearAvailable=1;
            break;
        case '2':
            if (MicAsCenterBass) MicAsCenterBass = 0; else MicAsCenterBass = 1;
            status = ioctl(fd, SNDCTL_DSP_MICASCENTERBASS, &MicAsCenterBass);
            if (MicAsCenterBass) MicSelect2 = 1;
            if (status != 0) MicAsCenterBassAvailable=0; else MicAsCenterBassAvailable=1;
            break;
        case '3':
            if (XearMode) XearMode = 0; else XearMode = 1;
            status = ioctl(fd, SNDCTL_DSP_XEAR, &XearMode);
            if (status != 0) XearModeAvailable=0; else XearModeAvailable=1;
            break;
        case '4':
            if (MicSelect2) MicSelect2 = 0; else MicSelect2 = 1;
            status = ioctl(fd, SNDCTL_DSP_MICSELECT2, &MicSelect2);
            if (status != 0) MicSelect2Available=0; else MicSelect2Available=1;
            break;
        case '5':
            if (Mix2Surround) Mix2Surround = 0; else Mix2Surround = 1;
            status = ioctl(fd, SNDCTL_DSP_MIX2SURROUND, &Mix2Surround);
            if (status != 0) Mix2SurroundAvailable=0; else Mix2SurroundAvailable=1;
            break;
        }

    } while(KeyPress != '0');

    /* close the device */
    status = close(fd);
    if (status == -1) 
    {
        perror("error closing /dev/dsp");
        exit(1);
    }

    /* and exit */
    return(0);
}


