#include <linux/module.h>
#include <linux/version.h>
#include <linux/string.h>
#include <linux/ctype.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/sound.h>
#include <linux/slab.h>
#include <linux/soundcard.h>
#include <linux/pci.h>
#include <asm/io.h>
#include <asm/dma.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <linux/spinlock.h>
#include <linux/smp_lock.h>
#include <linux/ac97_codec.h>
#include <linux/wrapper.h>
#include <asm/uaccess.h>
#include <asm/hardirq.h>

#define SNDCTL_DSP_LINEINASREAR	        _SIOWR ('P', 68, int)
#define SNDCTL_DSP_MICASCENTERBASS      _SIOWR ('P', 69, int)
#define SNDCTL_DSP_XEAR                 _SIOWR ('P', 70, int)
#define SNDCTL_DSP_MICSELECT2           _SIOWR ('P', 71, int)
#define SNDCTL_DSP_MIX2SURROUND         _SIOWR ('P', 72, int)

// For PCCHIPS LCD PC
//#define AUTO_PHONEJACK_SHARE 0
//#define FORCE_LINEINASREAR_MODE 1
//#define FORCE_MICASBASS_MODE 1
//#define FORCE_XEAR_MODE 1
//#define FORCE_MICSELECT2_MODE 1

// Use S-Bracket (no phone jacks sharing)
//#define AUTO_PHONEJACK_SHARE 0
//#define FORCE_LINEINASREAR_MODE 0
//#define FORCE_MICASBASS_MODE 0
//#define FORCE_XEAR_MODE 0
//#define FORCE_MICSELECT2_MODE 0

// Others (Most computers use this)
#define AUTO_PHONEJACK_SHARE 1
#define FORCE_LINEINASREAR_MODE 0
#define FORCE_MICASBASS_MODE 0
#define FORCE_XEAR_MODE 0
#define FORCE_MICSELECT2_MODE 0

#ifndef PCI_VENDOR_ID_AMD
#define PCI_VENDOR_ID_AMD            	0x1022
#endif

#ifndef PCI_DEVICE_ID_AMD_8111
#define PCI_DEVICE_ID_AMD_8111		0x746d
#endif

#ifndef PCI_VENDOR_ID_NVIDIA
#define PCI_VENDOR_ID_NVIDIA            0x10de
#endif

#ifndef PCI_DEVICE_ID_NVIDIAI_NFORCE_0
#define PCI_DEVICE_ID_NVIDIA_NFORCE_0	0x01b1
#endif

#ifndef PCI_DEVICE_ID_NVIDIAI_NFORCE_1
#define PCI_DEVICE_ID_NVIDIA_NFORCE_1	0x006a
#endif

#ifndef PCI_VENDOR_ID_ALI
#define PCI_VENDOR_ID_ALI               0x10b9
#endif

#ifndef PCI_DEVICE_ID_ALI_5451
#define PCI_DEVICE_ID_ALI_5451		0x5451
#endif

#ifndef PCI_VENDOR_ID_SIS
#define PCI_VENDOR_ID_SIS               0x1039
#endif

#ifndef PCI_DEVICE_ID_SIS_7012
#define PCI_DEVICE_ID_SIS_7012		0x7012
#endif

#ifndef PCI_DEVICE_ID_SIS_7018
#define PCI_DEVICE_ID_SIS_7018		0x7018
#endif

#ifndef PCI_DEVICE_ID_VIA_8233_5
#define PCI_DEVICE_ID_VIA_8233_5	0x3059
#endif

#ifndef PCI_DEVICE_ID_VIA_82686
#define PCI_DEVICE_ID_VIA_82686         0x3058
#endif

#ifndef PCI_DEVICE_ID_INTEL_ICH4
#define PCI_DEVICE_ID_INTEL_ICH4	0x24c5
#endif

#ifndef PCI_DEVICE_ID_INTEL_ICH2
#define PCI_DEVICE_ID_INTEL_ICH2	0x2445
#endif

#ifndef PCI_DEVICE_ID_INTEL_ICH5
#define PCI_DEVICE_ID_INTEL_ICH5	0x24d5
#endif

enum 
{
    INTELICH4=0,
    VIA8233,
    SIS7012,
    SIS7018,
    ALI5451,
    NVIDIA_NFORCE,
    INTELICH2,
    VIA82686,
    INTELICH5,
    AMD8111
};


#define        AC97REG_RESET               0x00
#define        AC97REG_MASTER_VOLUME       0x02
#define        AC97REG_REAR_VOLUME         0x04
#define        AC97REG_MMONO_VOLUME        0x06
#define        AC97REG_MASTER_TONE         0x08
#define        AC97REG_BEEP_VOLUME         0x0a
#define        AC97REG_PHONE_VOLUME        0x0c
#define        AC97REG_MIC_VOLUME          0x0e
#define        AC97REG_LINEIN_VOLUME       0x10
#define        AC97REG_CD_VOLUME           0x12
#define        AC97REG_VIDEO_VOLUME        0x14
#define        AC97REG_AUX_VOLUME          0x16
#define        AC97REG_PCMOUT_VOLUME       0x18
#define        AC97REG_RECORD_SELECT       0x1a
#define        AC97REG_RECORD_GAIN         0x1c
#define        AC97REG_RECORD_GAIN_MIC     0x1e
#define        AC97REG_GENERAL             0x20
#define        AC97REG_3D_CONTROL          0x22
#define        AC97REG_RESERVED            0x24
#define        AC97REG_POWERDOWN           0x26

// AC97-2.0 registers
#define        AC97REG_EXT_AUDIO_ID        0x28
#define        AC97REG_EXT_AUDIO_CTRL      0x2a
#define        AC97REG_FRONT_SAMPLERATE    0x2c
#define        AC97REG_SURROUND_SAMPLERATE 0x2e
#define        AC97REG_LFE_SAMPLERATE      0x30
#define        AC97REG_RECORD_SAMPLERATE   0x32
#define        AC97REG_MIC_SAMPLERATE      0x34
#define        AC97REG_CENTER_LFE_VOLUME   0x36
#define        AC97REG_SURROUND_VOLUME     0x38
#define        AC97REG_RESERVED2           0x3a
#define        AC97REG_TOP_ELEMENT         0x3c

// Modem registers from 0x3C to 0x58 (next 15 enums)
// Vendor Reserved = 0x5A-0x7A (next 16 enums)
#define        AC97REG_CM9738_EXT1         0x5a

// SPDIF registers
#define        AC97REG_MULTI_CHANNEL_CTRL  0x64
#define        AC97REG_SPDIF_FUNCTION      0x6c

// Vendor IDs
#define        AC97REG_VENDOR_ID1          0x7c
#define        AC97REG_VENDOR_ID2          0x7e

struct ac97_mixer_hw 
{
    unsigned char offset;
    int scale;
};

#define CMEDIA_FMT_16BIT	1
#define CMEDIA_FMT_STEREO	2
#define CMEDIA_FMT_MASK	3

#define CMEDIA_DMA_MASK		0xffffffff /* DMA buffer mask for pci_alloc_consist */

extern char * card_names[];
extern u16 output_channels;
        
/* the following tables allow us to go from OSS <-> ac97 quickly. */
enum ac97_recsettings {
	AC97_REC_MIC=0,
	AC97_REC_CD,
	AC97_REC_VIDEO,
	AC97_REC_AUX,
	AC97_REC_LINE,
	AC97_REC_STEREO, /* combination of all enabled outputs..  */
	AC97_REC_MONO,	      /*.. or the mono equivalent */
	//AC97_REC_PHONE,
        AC97_REC_DIGITAL1
};

#define card_supported_mixer(CARD,FOO) ((FOO >= 0) && \
                                    (FOO < SOUND_MIXER_NRDEVICES) && \
                                    (CARD)->supported_mixers & (1<<FOO) )

static const unsigned int ac97_rm2oss[] = 
{
	[AC97_REC_MIC] 	 = SOUND_MIXER_MIC,
	[AC97_REC_CD] 	 = SOUND_MIXER_CD,
	[AC97_REC_AUX] 	 = SOUND_MIXER_LINE1,
	[AC97_REC_LINE]  = SOUND_MIXER_LINE,
	[AC97_REC_STEREO]= SOUND_MIXER_VOLUME,
	[AC97_REC_DIGITAL1]= SOUND_MIXER_DIGITAL1
};

/* indexed by bit position */
static const unsigned int ac97_oss_rm[] = 
{
	[SOUND_MIXER_MIC] 	= AC97_REC_MIC,
	[SOUND_MIXER_CD] 	= AC97_REC_CD,
	[SOUND_MIXER_LINE1] 	= AC97_REC_AUX,
	[SOUND_MIXER_LINE] 	= AC97_REC_LINE,
	[SOUND_MIXER_VOLUME]	= AC97_REC_STEREO,
	[SOUND_MIXER_DIGITAL1]	= AC97_REC_DIGITAL1
};

// --------------------------------------------------------
/* the CMedia's array of pointers to data buffers */

#define DMABUF_DEFAULTORDER 16
#define DMABUF_MINORDER 1
#define PCMOUT_DMABUF_SIZE 86400  //48K 16bit 6CH 0.1Sec
#define PCMIN_DMABUF_SIZE  57600  //48K 16bit 2CH 0.1Sec
#define TEMPBUF_SIZE  6144
#define PROCESS_TIMER (HZ/30) // 0.03Sec

#define ADC_RUNNING	1
#define DAC_RUNNING	2

#define NR_VR_CH	16

typedef union
{
    unsigned long dw;
    struct
    {   
        unsigned short fract; // fractional part
        unsigned short whole; // integer part
    } s;
} INDEX;


/* an instance of the cmedia virtual channel */
struct cmedia_channel 
{
    struct cmedia_card *card;	/* Card info */

    /* single open lock mechanism, only used for recording */
    struct semaphore open_sem;
    //wait_queue_head_t open_wait;

    /* file mode */
    mode_t open_mode;
    int trigger;

    /* virtual channel number */
    int virt;
    int PhysicalChannels;

    /* put process on wait queue when no more space in buffer */
    wait_queue_head_t in_wait;	
    wait_queue_head_t out_wait;	

    /* wave sample stuff */
    unsigned int rate;
    unsigned char fmt, enable;
    int stereo, IsAC3;

    /* input and output buffer */
    void *outbuf;
    long out_hwptr;
    long out_swptr;
    long out_count;
    long out_total_bytes;

    void *inbuf;
    long in_hwptr;
    long in_swptr;
    long in_count;
    long in_total_bytes;

    /* Sampling Rate Convert */
    void  *pcmout_tempbuf;
    INDEX pcmout_doppler_rate;
    INDEX pcmout_index;
    int   pcmout_leftsize;

    void  *pcmin_tempbuf;
    void  *pcmin_tempbuf1;
    unsigned  pcmin_tempbuf1_count;
    INDEX pcmin_doppler_rate;
    INDEX pcmin_index;

    int opened;
};

struct sg_item {
#define BUSADDR_MASK	0xFFFFFFFE
	u32 busaddr;	
#define CON_IOC 	0x80000000 /* interrupt on completion */
#define CON_BUFPAD	0x40000000 /* pad underrun with last sample, else 0 */
#define CON_BUFLEN_MASK	0x0000ffff /* buffer length in samples */
	u32 control;
};

/* an instance of the buffer descriptor */
#define SG_LEN 32
struct buffer_descriptor 
{
    struct sg_item sg[SG_LEN];	/* 32*8 */
};

struct cmedia_card 
{
    struct cmedia_channel *channels[NR_VR_CH];
    struct buffer_descriptor pcmout_buffer_descriptor;
    struct buffer_descriptor pcmin_buffer_descriptor;

    void *pcmout_rawbuf;
    void *pcmin_rawbuf;
    void *dmaout_rawbuf;

    /* our buffer acts like a circular ring */
    unsigned long pcmout_hwptr;		        /* where dma last started, updated by update_ptr */
    unsigned long pcmout_swptr;		        /* where driver last clear/filled, updated by read/write */
    unsigned long pcmin_hwptr;		        /* where dma last started, updated by update_ptr */
    unsigned long pcmin_swptr;		        /* where driver last clear/filled, updated by read/write */

    /* OSS buffer management stuff */
    dma_addr_t dmaout_dma_handle;
    dma_addr_t pcmout_dma_handle;
    u16 pcmout_buforder;
    long pcmout_count;

    dma_addr_t pcmin_dma_handle;
    u16 pcmin_buforder;
    long pcmin_count;

    u16 dma_state;

    /* The cmedia has a certain amount of cross channel interaction so we use a single per card lock */
    spinlock_t lock;
    int modify_counter;

    /* PCI device stuff */
    struct pci_dev * pci_dev;
    u16 pci_id;
    u16 driver_data;

    /* soundcore stuff */
    int dev_audio;
    int dev_mixer;

    u16 ac97_features;
    u16 ac97_vender_id1;
    u16 ac97_vender_id2;
	
    /* hardware resources */
    unsigned long iobase;
    unsigned long opbase;

    /* Phone Jacks Settings */
    int LineInAsRear;
    int MicAsCenterBass;
    int XearMode;
    int MicSelect2;
    int FourChannelCount;
    int SixChannelCount;
    int Mix2Surround;
	
    /* Function support */
    void (*RequestRegion)(struct cmedia_card *card);
    void (*ReleaseRegion)(struct cmedia_card *card);
    int (*Initial)(struct cmedia_card *card);
    u16 (*ReadRegisterWord)(struct cmedia_card *card, u8 Index);
    void (*WriteRegisterWord)(struct cmedia_card *card, u8 Index, u16 Value);
    int (*ProgramDMABuffer)(struct cmedia_card *card);
    void (*UpdatePtr)(struct cmedia_card *card);
    void (*StartADC)(struct cmedia_card *card);
    void (*StopADC)(struct cmedia_card *card);
    void (*StartDAC)(struct cmedia_card *card);
    int (*DrainDAC)(struct cmedia_card *card);
    void (*ConvertPCMOUT)(struct cmedia_card *card);

    /* Mixer parameters and I/O functions */
    /* OSS mixer masks */
    int supported_mixers;
    int stereo_mixers;
    int record_sources;

    /* saved OSS mixer states */
    unsigned int mixer_state[SOUND_MIXER_NRDEVICES];

    void (*InitialMixer)(struct cmedia_card *card);
    int (*RecMask_io)(struct cmedia_card *card, int rw, int mask);
    void (*Set_Mixer)(struct cmedia_card *card, unsigned int oss_mixer, unsigned int val);

    /* We have a *very* long init time possibly, so use this to block */
    /* attempts to open our devices before we are ready (stops oops'es) */
    int initializing;

    int bMonitorSPDIF;
    int IsAC3;
};

// INTEL ICHx, SiS 7012, nVidia, AMD
void RequestRegion_INTEL_ICHx(struct cmedia_card *card);
void ReleaseRegion_INTEL_ICHx(struct cmedia_card *card);
int Initial_INTEL_ICHx(struct cmedia_card *card);
u16 ReadRegisterWord_INTEL_ICHx(struct cmedia_card *card, u8 reg);
void WriteRegisterWord_INTEL_ICHx(struct cmedia_card *card, u8 reg, u16 data);
int ProgramDMABuffer_INTEL_ICHx(struct cmedia_card *card);
void UpdatePtr_INTEL_ICHx(struct cmedia_card *card);
void StopADC_INTEL_ICHx(struct cmedia_card *card);
void StartADC_INTEL_ICHx(struct cmedia_card *card);
void StartDAC_INTEL_ICHx(struct cmedia_card *card);
int DrainDAC_INTEL_ICHx(struct cmedia_card *card);
void ConvertPCMOUT_INTEL_ICHx(struct cmedia_card *card);

// VIA 82c686 and VIA 8233
void RequestRegion_VIA_82cxxx(struct cmedia_card *card);
void ReleaseRegion_VIA_82cxxx(struct cmedia_card *card);
int Initial_VIA_82cxxx(struct cmedia_card *card);
u16 ReadRegisterWord_VIA_82cxxx(struct cmedia_card *card, u8 reg);
void WriteRegisterWord_VIA_82cxxx(struct cmedia_card *card, u8 reg, u16 data);
int ProgramDMABuffer_VIA_82cxxx(struct cmedia_card *card);
void UpdatePtr_VIA_82cxxx(struct cmedia_card *card);
void StopADC_VIA_82cxxx(struct cmedia_card *card);
void StartADC_VIA_82cxxx(struct cmedia_card *card);
void StartDAC_VIA_82cxxx(struct cmedia_card *card);
int DrainDAC_VIA_82cxxx(struct cmedia_card *card);
void ConvertPCMOUT_VIA_82cxxx(struct cmedia_card *card);

// SiS 7018
void RequestRegion_SiS_7018(struct cmedia_card *card);
void ReleaseRegion_SiS_7018(struct cmedia_card *card);
int Initial_SiS_7018(struct cmedia_card *card);
u16 ReadRegisterWord_SiS_7018(struct cmedia_card *card, u8 reg);
void WriteRegisterWord_SiS_7018(struct cmedia_card *card, u8 reg, u16 data);
int ProgramDMABuffer_SiS_7018(struct cmedia_card *card);
void UpdatePtr_SiS_7018(struct cmedia_card *card);
void StopADC_SiS_7018(struct cmedia_card *card);
void StartADC_SiS_7018(struct cmedia_card *card);
void StartDAC_SiS_7018(struct cmedia_card *card);
int DrainDAC_SiS_7018(struct cmedia_card *card);
void ConvertPCMOUT_SiS_7018(struct cmedia_card *card);

// ALI 5451
void RequestRegion_ALI_5451(struct cmedia_card *card);
void ReleaseRegion_ALI_5451(struct cmedia_card *card);
int Initial_ALI_5451(struct cmedia_card *card);
u16 ReadRegisterWord_ALI_5451(struct cmedia_card *card, u8 reg);
void WriteRegisterWord_ALI_5451(struct cmedia_card *card, u8 reg, u16 data);
int ProgramDMABuffer_ALI_5451(struct cmedia_card *card);
void UpdatePtr_ALI_5451(struct cmedia_card *card);
void StopADC_ALI_5451(struct cmedia_card *card);
void StartADC_ALI_5451(struct cmedia_card *card);
void StartDAC_ALI_5451(struct cmedia_card *card);
int DrainDAC_ALI_5451(struct cmedia_card *card);
void ConvertPCMOUT_ALI_5451(struct cmedia_card *card);

// CMI9739
void InitialMixerCMI9739(struct cmedia_card *card);
int RecMask_io_CMI9739(struct cmedia_card *card, int rw, int mask);
void write_mixer_9739(struct cmedia_card *card, int oss_channel, unsigned int left, unsigned int right);
void Set_Mixer_CMI9739(struct cmedia_card *card, unsigned int oss_mixer, unsigned int val);

// CMI9738
void InitialMixerCMI9738(struct cmedia_card *card);
int RecMask_io_CMI9738(struct cmedia_card *card, int rw, int mask);
void write_mixer_9738(struct cmedia_card *card, int oss_channel, unsigned int left, unsigned int right);
void Set_Mixer_CMI9738(struct cmedia_card *card, unsigned int oss_mixer, unsigned int val);



