RM=rm -f

RM_DIR=rm -rf

MAKE_DEP=echo

MAKE_DEP_FLAGS=$(INCLUDES) $(DEFINES)

MAKE_LIB=ar cr

MAKE_LIB_FLAGS=

RANLIB=ranlib

CP=cp

MAKE=make

CC=gcc

CCFLAGS=--permissive -pipe -W -Wreturn-type -fno-rtti -fno-exceptions -O0 -g -DDEBUG -D_DEBUG  $(INCLUDES) $(DEFINES)

CXX=g++

CXXFLAGS=--permissive -pipe -W -Wreturn-type -fno-rtti -fno-exceptions -O0 -g -DDEBUG -D_DEBUG  $(INCLUDES) $(DEFINES)

SRCS=main.cpp guids.cpp crmevapp.cpp RTASampleLogObserver.cpp filewriter.cpp

OBJS=$(COMPILED_OBJS) $(SOURCE_OBJS)
COMPILED_OBJS=dbg/main.o dbg/guids.o dbg/crmevapp.o 

SOURCE_OBJS=

INCLUDES=-I/usr/X11R6/include -I../../include -I./pub -I../logging

DEFINES=-D_UNIX -DFD_SETSIZE=2048 -D_LINUX -D_REENTRANT -D_RED_HAT_5_X_ -D_LITTLE_ENDIAN -D_UNIX_THREADED_NETWORK_IO -D_UNIX_THREADS_SUPPORTED -DHELIX_FEATURE_FULLGUID

STATIC_LIBS=

DYNAMIC_LIBS=-lstdc++ -ldl -lpthread -lm -lc

.SUFFIXES: .cpp .so

.c.o: 
	$(CC) $(CCFLAGS) -o  $@ -c $<

.cpp.o: 
	$(CXX) $(CXXFLAGS) -o  $@ -c $<

dbg/rmevents: $(OBJS) $(STATIC_LIBS)
	if test -d dbg; then echo; else mkdir dbg; fi
	gcc -o dbg/rmevents $(OBJS) -L/usr/X11R6/lib $(DYNAMIC_LIBS) $(STATIC_LIBS)

dbg/main.o: main.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	$(CXX) $(CXXFLAGS) -o dbg/main.o -c main.cpp

dbg/crmevapp.o: crmevapp.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	$(CXX) $(CXXFLAGS) -o dbg/crmevapp.o -c crmevapp.cpp

dbg/guids.o: guids.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	$(CXX) $(CXXFLAGS) -o dbg/guids.o -c guids.cpp

clean: 
	$(RM) dbg/rmevents dbg/lib  $(COMPILED_OBJS)

copy: 
	if test -d ../debug; then echo; else mkdir ../debug; fi
	cp dbg/rmevents ../../bin/rmevents

depend: 
	$(MAKE_DEP) $(MAKE_DEP_FLAGS) dbg/ $(SRCS)




