/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _CRMEDAP_
#define _CRMEDAP_

#include "hxtypes.h"
#include "hxresult.h"
#include "hxcom.h"
#include "rmflsnk.h"
#include "ihxtedit.h"

class CRMFileSink;
struct IHXRMEdit;
struct IHXRMEdit2;
struct IHXRMDump;
struct IHXRMFileSink;
struct IHXPacket;
struct IHXValues;

class CRMEditApp
{
public:

    CRMEditApp();
    ~CRMEditApp();
    HX_RESULT		Initialize(UINT16 argc, const char ** argv);
    HX_RESULT		Process(void);
    HX_RESULT		DisplayEditInfo(void);
    HX_RESULT		DisplayMetaInformation(void);
	void			Usage(void);
	void			Log(const char* pLogString);
	IHXRMEdit*		GetEditSDK(void) {return m_pEdit;};
	IHXRMEdit2*	GetEdit2SDK(void) {return m_pEdit2;};

protected:

	void			HandleSDKError(HX_RESULT theRes);
	HX_RESULT		CreateEditSDK(void);
	HX_RESULT		CreateDumpSDK(void);
	HX_RESULT		SetMetaInformationString(const char* pName, const char* pValue);
	HX_RESULT		SetMetaInformationInteger(const char* pName, UINT32 value);
	
	IHXRMEdit* 	m_pEdit;
	IHXRMEdit2* 	m_pEdit2;
	IHXRMDump*	m_pDump;

#ifdef _WINDOWS
	HMODULE m_RmtoolsDLL;
#else
	void* m_RmtoolsDLL;
#endif

	CRMFileSink*	m_pFileSink;

	char*			m_pDumpFile;
	UINT32			m_ulNumInputFiles;
	BOOL			m_bHasInputFile;
	BOOL			m_bHasOutputFile;
	BOOL			m_bListInputFile;
	BOOL			m_bDumpInputFile;
	BOOL			m_bUseLogFile;
	BOOL			m_bUsageOnly;
};


class CRMFileSink : public IHXRMFileSink
{
public:

    CRMFileSink(CRMEditApp* pOwnerApp);
    ~CRMFileSink();

	/************************************************************************
    *  IUnknown COM Interface Methods                          ref:  hxcom.h
    */
    STDMETHOD (QueryInterface ) (THIS_ REFIID ID, void** ppInterfaceObj);
    STDMETHOD_(UINT32, AddRef ) (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

	/************************************************************************
    *  IHXRMFileSink COM Interface Methods                    ref:  ihxtedit.h
    */
    STDMETHOD(OnPacket)	(THIS_ IHXPacket* pMediaPacket, BOOL bIsKeyFrame);
	STDMETHOD(OnMediaPropertyHeader) (THIS_ IHXValues* pValues);

protected:

	CRMEditApp*		m_pOwnerApp;
	LONG32			m_lRefCount;
};
#endif /*_CRMEDAP_*/
