RM=rm -f

RM_DIR=rm -rf

MAKE_DEP=echo

MAKE_DEP_FLAGS=$(INCLUDES) $(DEFINES)

MAKE_LIB=ar cr

MAKE_LIB_FLAGS=

RANLIB=ranlib

CP=cp

MAKE=make

CC=gcc

CCFLAGS=--permissive -pipe -W -Wreturn-type -fno-rtti -fno-exceptions -O0 -g -DDEBUG -D_DEBUG  $(INCLUDES) $(DEFINES)

CXX=g++

CXXFLAGS=--permissive -pipe -W -Wreturn-type -fno-rtti -fno-exceptions -O0 -g -DDEBUG -D_DEBUG  $(INCLUDES) $(DEFINES)

SRCS=PrefilterExampleTransform.cpp PrefilterExampleFilter.cpp PrefilterExampleAgent.cpp PrefilterExamplePlugin.cpp

OBJS=$(COMPILED_OBJS) $(SOURCE_OBJS)
COMPILED_OBJS=dbg/obj/RSPrefilterExamplePlugin/PrefilterExampleTransform.o dbg/obj/RSPrefilterExamplePlugin/PrefilterExampleFilter.o dbg/obj/RSPrefilterExamplePlugin/PrefilterExampleAgent.o dbg/obj/RSPrefilterExamplePlugin/PrefilterExamplePlugin.o

SOURCE_OBJS=

INCLUDES=-I../../include -I./pub -I../logging

DEFINES=-D_UNIX -DFD_SETSIZE=2048 -D_MAC_UNIX -D_MAC_MACHO -D_UNIX_THREADED_NETWORK_IO -D_UNIX_THREADS_SUPPORTED -DHELIX_FEATURE_FULLGUID -D _DARWIN -D _BIG_ENDIAN -D USE_RN_ATOMIC_INTERLOCKED_INC_DEC

STATIC_LIBS=

DYNAMIC_LIBS=-lstdc++  -lpthread -lm -lc -framework Carbon

.SUFFIXES: .cpp .so

.c.o: 
	$(CC) $(CCFLAGS) -fPIC -DPIC -o  $@ -c $<

.cpp.o: 
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o  $@ -c $<


dbg/PrefilterExamplePlugin: $(OBJS) $(STATIC_LIBS)
	if test -d dbg; then echo; else mkdir dbg; fi
	if test -d dbg/prefilterexampleplugin.bundle/Contents/MacOS; then echo; else mkdir -p dbg/prefilterexampleplugin.bundle/Contents/MacOS; fi                
	gcc -dynamiclib -o dbg/prefilterexampleplugin.bundle/Contents/MacOS/prefilterexampleplugin $(OBJS)  $(DYNAMIC_LIBS)
	
dbg/obj/RSPrefilterExamplePlugin/PrefilterExampleTransform.o: PrefilterExampleTransform.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	-@if test -d dbg/obj; then echo; else mkdir dbg/obj; fi
	-@if test -d dbg/obj/RSPrefilterExamplePlugin; then echo; else mkdir dbg/obj/RSPrefilterExamplePlugin; fi
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o dbg/obj/RSPrefilterExamplePlugin/PrefilterExampleTransform.o -c PrefilterExampleTransform.cpp

dbg/obj/RSPrefilterExamplePlugin/PrefilterExampleFilter.o: PrefilterExampleFilter.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	-@if test -d dbg/obj; then echo; else mkdir dbg/obj; fi
	-@if test -d dbg/obj/RSPrefilterExamplePlugin; then echo; else mkdir dbg/obj/RSPrefilterExamplePlugin; fi
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o dbg/obj/RSPrefilterExamplePlugin/PrefilterExampleFilter.o -c PrefilterExampleFilter.cpp

dbg/obj/RSPrefilterExamplePlugin/PrefilterExampleAgent.o: PrefilterExampleAgent.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	-@if test -d dbg/obj; then echo; else mkdir dbg/obj; fi
	-@if test -d dbg/obj/RSPrefilterExamplePlugin; then echo; else mkdir dbg/obj/RSPrefilterExamplePlugin; fi
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o dbg/obj/RSPrefilterExamplePlugin/PrefilterExampleAgent.o -c PrefilterExampleAgent.cpp

dbg/obj/RSPrefilterExamplePlugin/PrefilterExamplePlugin.o: PrefilterExamplePlugin.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	-@if test -d dbg/obj; then echo; else mkdir dbg/obj; fi
	-@if test -d dbg/obj/RSPrefilterExamplePlugin; then echo; else mkdir dbg/obj/RSPrefilterExamplePlugin; fi
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o dbg/obj/RSPrefilterExamplePlugin/PrefilterExamplePlugin.o -c PrefilterExamplePlugin.cpp

clean: 
	$(RM_DIR) dbg/prefilterexampleplugin.bundle  $(COMPILED_OBJS)

copy: 
	-@if test -d ../debug; then echo; else mkdir ../debug; fi
	cp -r dbg/prefilterexampleplugin.bundle ../debug/prefilterexampleplugin.bundle

depend: 
	$(MAKE_DEP) $(MAKE_DEP_FLAGS) dbg/obj/prefilterexampleplugin/ $(SRCS)



