/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _PREFILTEREXAMPLEFILTER_H
#define _PREFILTEREXAMPLEFILTER_H

class	CRSPrefilterExampleFilter 
		: public IHXTTransformFilter	
		, public CRSPrefilterExampleTransform
{

public:

	CRSPrefilterExampleFilter();
	~CRSPrefilterExampleFilter();  

	// IHXTFilter methods
	STDMETHOD( SetFactory ) ( IHXCommonClassFactory* pCCF );
	STDMETHOD( SetGraphServices ) ( IHXTServiceBroker* pEventSink );
	STDMETHOD( Prime )( UINT32 ulOutputStreamID );
	STDMETHOD( DiscardCachedSamples )( UINT32 ulOutputStreamID );
	STDMETHOD( Teardown )( UINT32 uStream );

	// IHXTTransformFilter methods
	STDMETHOD( SetAllocator ) ( UINT32 uOutputStreamID, IHXTSampleAllocator* pAllocator );
	STDMETHOD( SetSampleSink ) ( UINT32 uOutputStreamID, IHXTSampleSink* pOutputSink );
	STDMETHOD( ReceiveSample )( UINT32 uInputStreamID, IHXTMediaSample* pSample );

	// IUnknown Interface Methods                         
    STDMETHOD(QueryInterface)		(THIS_ REFIID riid, void** ppvObj);

	// INTERNAL Helpers between Agent/ Filter

	// agent informs filter when format is ready
	void SetFormatReady( BOOL bReady ) { m_bFormatReady = bReady; }


private:

	IHXTSampleAllocator		*m_pAllocator;			
	IHXTSampleSink			*m_pOutputSink;			

	BOOL					m_bFormatReady;				
	BOOL					m_bReadyToOutputSamples;	
};

#endif // _PREFILTEREXAMPLEFILTER_H


		

