RM=rm -f

RM_DIR=rm -rf

MAKE_DEP=echo

MAKE_DEP_FLAGS=$(INCLUDES) $(DEFINES)

MAKE_LIB=ar cr

MAKE_LIB_FLAGS=

RANLIB=ranlib

CP=cp

MAKE=make

CC=gcc

CCFLAGS=--permissive -pipe -W -Wreturn-type -fno-rtti -fno-exceptions -O0 -g -DDEBUG -D_DEBUG  $(INCLUDES) $(DEFINES)

CXX=g++

CXXFLAGS=--permissive -pipe -W -Wreturn-type -fno-rtti -fno-exceptions -O0 -g -DDEBUG -D_DEBUG  $(INCLUDES) $(DEFINES)

SRCS=InWAVReader.cpp InWAVFilter.cpp InWAVAgent.cpp InWAVPlugin.cpp

OBJS=$(COMPILED_OBJS) $(SOURCE_OBJS)
COMPILED_OBJS=dbg/obj/RSInWAVPlugin/InWAVReader.o dbg/obj/RSInWAVPlugin/InWAVFilter.o dbg/obj/RSInWAVPlugin/InWAVAgent.o dbg/obj/RSInWAVPlugin/InWAVPlugin.o

SOURCE_OBJS=

INCLUDES=-I../../include -I./pub -I../logging

DEFINES=-D_UNIX -DFD_SETSIZE=2048 -D_MAC_UNIX -D_MAC_MACHO -D_UNIX_THREADED_NETWORK_IO -D_UNIX_THREADS_SUPPORTED -DHELIX_FEATURE_FULLGUID -D _DARWIN -D _BIG_ENDIAN -D USE_RN_ATOMIC_INTERLOCKED_INC_DEC

STATIC_LIBS=

DYNAMIC_LIBS=-lstdc++ -lpthread -lm -lc -framework Carbon

.SUFFIXES: .cpp .so

.c.o: 
	$(CC) $(CCFLAGS) -fPIC -DPIC -o  $@ -c $<

.cpp.o: 
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o  $@ -c $<


dbg/InWAVPlugin: $(OBJS) $(STATIC_LIBS)
	if test -d dbg/wavreader.bundle/Contents/MacOS; then echo; else mkdir -p dbg/wavreader.bundle/Contents/MacOS; fi                
	gcc -dynamiclib -o dbg/wavreader.bundle/Contents/MacOS/wavreader $(OBJS) $(DYNAMIC_LIBS)
	
dbg/obj/RSInWAVPlugin/InWAVReader.o: InWAVReader.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	-@if test -d dbg/obj; then echo; else mkdir dbg/obj; fi
	-@if test -d dbg/obj/RSInWAVPlugin; then echo; else mkdir dbg/obj/RSInWAVPlugin; fi
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o dbg/obj/RSInWAVPlugin/InWAVReader.o -c InWAVReader.cpp

dbg/obj/RSInWAVPlugin/InWAVFilter.o: InWAVFilter.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	-@if test -d dbg/obj; then echo; else mkdir dbg/obj; fi
	-@if test -d dbg/obj/RSInWAVPlugin; then echo; else mkdir dbg/obj/RSInWAVPlugin; fi
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o dbg/obj/RSInWAVPlugin/InWAVFilter.o -c InWAVFilter.cpp

dbg/obj/RSInWAVPlugin/InWAVAgent.o: InWAVAgent.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	-@if test -d dbg/obj; then echo; else mkdir dbg/obj; fi
	-@if test -d dbg/obj/RSInWAVPlugin; then echo; else mkdir dbg/obj/RSInWAVPlugin; fi
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o dbg/obj/RSInWAVPlugin/InWAVAgent.o -c InWAVAgent.cpp

dbg/obj/RSInWAVPlugin/InWAVPlugin.o: InWAVPlugin.cpp
	-@if test -d dbg; then echo; else mkdir dbg; fi
	-@if test -d dbg/obj; then echo; else mkdir dbg/obj; fi
	-@if test -d dbg/obj/RSInWAVPlugin; then echo; else mkdir dbg/obj/RSInWAVPlugin; fi
	$(CXX) $(CXXFLAGS) -fPIC -DPIC -o dbg/obj/RSInWAVPlugin/InWAVPlugin.o -c InWAVPlugin.cpp

clean: 
	$(RM_DIR) dbg/wavreader.bundle  $(COMPILED_OBJS)

copy: 
	-@if test -d ../debug; then echo; else mkdir ../debug; fi
	cp -r dbg/wavreader.bundle ../debug/wavreader.bundle

depend: 
	$(MAKE_DEP) $(MAKE_DEP_FLAGS) dbg/obj/RSInWAVPlugin/ $(SRCS)



