/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _INWAVAGENT_H
#define _INWAVAGENT_H

#if defined (_WINDOWS ) || defined (WIN32)
#define OS_SEPARATOR_CHAR	'\\'
#elif defined (_UNIX)
#define OS_SEPARATOR_CHAR	'/'
#endif /* defined (_WINDOWS ) || defined (WIN32) */

class	CRSInWAVAgent
			: public CHXTConfigurationAgentHelper
			, public IHXTConnectionAgent
			, public CRSInWAVFilter
{

public:

	CRSInWAVAgent( );

	// overrides of filter methods to facilitate use of the CHXTConfigurationAgentHelper class
	STDMETHOD( SetFactory ) ( IHXCommonClassFactory* pFactory );
	STDMETHOD( Prime )( UINT32 ulOutputStreamID );
	STDMETHOD( Teardown )( UINT32 ulOutputStreamID );

	// CHXTConfigurationAgentHelper overrides
	STDMETHOD(OnSetString)( const char* szName, const char* szValue );

	// IHXTConnectionAgent methods 

	// Output connection methods
	STDMETHOD_( UINT32, GetOutputStreamCount ) ();
	STDMETHOD ( GetSupportedOutputFormat )( UINT32 ulOutputStreamID, IHXTPropertyBag** ppSupportedFormats );
	STDMETHOD ( SetNegotiatedOutputFormat )( UINT32 ulOutputStreamID, IHXTPropertyBag* pConnectedFormat );

	// input connection methods -- aren't needed by an input plugin 
	STDMETHOD_( UINT32, GetInputStreamCount ) ()	{	return 0;	}	// no outputs	
	STDMETHOD ( GetSupportedInputFormat )( UINT32 ulInputStreamID, IHXTPropertyBag** ppSupportedFormats ) { return HXR_FAIL; }
	STDMETHOD ( GetNegotiatedInputFormat )( UINT32 ulInputStreamID, IHXTPropertyBag** ppSupportedFormats ) { return HXR_FAIL; }

	// for future use
	STDMETHOD ( SetNegotiatedInputFormat ) ( UINT32 ulInputStreamID, IHXTPropertyBag* pConnectedFormat ) { return HXR_FAIL;}
	STDMETHOD ( GetNegotiatedOutputFormat )( UINT32 ulOutputStreamID, IHXTPropertyBag** ppSupportedFormats ) { return HXR_FAIL;}
	STDMETHOD ( GetPreferredInputFormat ) ( THIS_ UINT32 uIndex, UINT32 uPrefRank, IHXTPropertyBag** ppPreferredFormat ) {return HXR_FAIL;}
	STDMETHOD ( GetPreferredOutputFormat ) ( THIS_ UINT32 uIndex, UINT32 uPrefRank, IHXTPropertyBag** ppPreferredFormat ) {return HXR_FAIL;}

	// IUnknown Interface Methods                         
	STDMETHOD(QueryInterface)		(THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)		(THIS);
    STDMETHOD_(ULONG32,Release)		(THIS);

protected:
	~CRSInWAVAgent();

private:
	// common helper methods
	HX_RESULT FillInPropertyBags();
	HX_RESULT FillTrackBag( const CHAR *cszValue ); 

	IHXTPropertyBag*		m_pOutputFormat;			
	IHXTPropertyBag*		m_pConnectedOutputFormat;	

	IHXTPropertyBag*		m_pAudioTrack;				
	IHXTTime*				m_pAudioDuration;	
	IHXTInputFormatHelper*  m_pIFH;

	LONG32					m_lRefCount;				
};

#endif // _INWAVAGENT_H


		

