/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#include "ihxtprofile.h"
#ifdef _MAC_UNIX
#include <Carbon/Carbon.h>
#endif
#include "hxcom.h"
#include "logobserver.h"

// log system observer includes
#include "ihxtlogsystem.h"

#include <time.h>

HX_RESULT CSampleLogObserver::Initialize(const char* szFilename, IHXTLogSystem* pLogSystem)
{
    // Validate params
    if (!szFilename || !pLogSystem)
    {
	return HXR_FAIL;
    }
    
    m_pFile = fopen(szFilename, "w");
    if (!m_pFile)
    {
	return HXR_FAIL;	
    }
    
    m_pLogSystem = pLogSystem;
    m_pLogSystem->AddRef();
    
    return HXR_OK;
}

HX_RESULT CSampleLogObserver::SetCategoryFilter(UINT32 nLogCode)
{
    IHXTLogObserverManager* pIObserverManager;
    char szFilterString[256];
    char szConvert[12];
    
    // Compose the XML filter string to be passed to the log system
    strcpy(szFilterString, "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><Filter LOGCODE=\"");
    sprintf(szConvert, "%u", nLogCode);
    strcat(szFilterString, szConvert);
    strcat(szFilterString, "\"></Filter>");
    
    // Get the subscribe interface to the log system
    if( m_pLogSystem && SUCCEEDED(m_pLogSystem->GetObserverManagerInterface(&pIObserverManager)) )
    {
	// Set the filter for this observer
	pIObserverManager->SetFilter(szFilterString, (IUnknown*)this);
	pIObserverManager->Release();
	return HXR_OK;
    }
    
    return HXR_FAIL;
}

HX_RESULT CSampleLogObserver::Subscribe()
{
    IHXTLogObserverManager* pIObserverManager;
    
    // Get the subscribe interface to the log system
    if( m_pLogSystem && SUCCEEDED(m_pLogSystem->GetObserverManagerInterface(&pIObserverManager)) )
    {
	// Subscribe this observer to receive log messages, requesting any missed messages
	pIObserverManager->Subscribe((IUnknown*)this, NULL, NULL, TRUE);
	pIObserverManager->Release();
	
	m_bSubscribed = TRUE;
	
	return HXR_OK;
    }
    
    return HXR_FAIL;
}

HX_RESULT CSampleLogObserver::Unsubscribe()
{
    if ( m_bSubscribed )
    {
	IHXTLogObserverManager* pIObserverManager;
	
	// Get the subscribe interface to the log system
	if( m_pLogSystem && SUCCEEDED(m_pLogSystem->GetObserverManagerInterface(&pIObserverManager)) )
	{
	    // Subscribe this observer to receive log messages
	    pIObserverManager->Unsubscribe((IUnknown*)this, TRUE);
	    pIObserverManager->Release();
	    
	    m_bSubscribed = FALSE;
	    
	    return HXR_OK;
	}
    }
    
    return HXR_FAIL;
}

CSampleLogObserver::CSampleLogObserver() :
m_ulRefCount(0)
,m_bSubscribed(FALSE)
,m_pFile(NULL)
,m_pLogSystem(NULL)
{
}

CSampleLogObserver::~CSampleLogObserver()
{
    Unsubscribe();
    
    if( m_pFile )
    {
	fclose(m_pFile);
    }
    
    HX_RELEASE(m_pLogSystem);
}

STDMETHODIMP_( ULONG32 )
CSampleLogObserver::AddRef()
{
    return InterlockedIncrement(&m_ulRefCount);
}

STDMETHODIMP_( ULONG32 )
CSampleLogObserver::Release()
{
    if (InterlockedDecrement(&m_ulRefCount) > 0)
    {
	return m_ulRefCount;
    }

    delete this;
    return 0;
}

STDMETHODIMP
CSampleLogObserver::QueryInterface( REFIID riid, void** ppvObj )
{
    if( IsEqualGUID(riid, IID_IHXTLogObserver) )
    {
	*ppvObj = (void*)(IHXTLogObserver*)this;
	AddRef();
	return HXR_OK;
    }
    else if( IsEqualGUID(riid, IID_IUnknown) )
    {
	*ppvObj = (void*)(IUnknown*)this;
	AddRef();
	return HXR_OK;
    }
    
    return HXR_FAIL;
}

STDMETHODIMP
CSampleLogObserver::OnEndService()
{
    // At this point, this observer has received all the log messages it could
    return HXR_OK;
}

STDMETHODIMP
CSampleLogObserver::ReceiveMsg (const char* szNamespace, EHXTLogCode nCode, UINT32 unFuncArea, const char* szFuncArea, 
				INT32 nTimeStamp, UINT32 nMsg, const char* szMsg,	const char* szThreadName)
{
    char *szTime;
    
    // Convert the time the message was logged to a legible format, then
    // write the message to the specified file.
    szTime = ctime( &nTimeStamp );
    if( m_pFile )
    {
	fprintf(m_pFile, "%s received at:%s", szMsg, szTime);
    }
    
    return HXR_OK;
}
