/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _ENCODER_H
#define _ENCODER_H
#ifdef _MAC_UNIX
#include <Carbon/Carbon.h>
#endif

#include <iostream>
using namespace std;


#include "hxcom.h"

#include "ihxtencodingjob.h"
#include "ihxtfileobserver.h"
#include "filewriter.h"
#include "ihxtpreviewsink.h"
#include "ihxtlogsystem.h"

class CSampleLogObserver;
class CSampleEventSink;
class CSamplePreviewSink;

#define MAX_PREVIEW_SINK 20

class CEncoderApp
{
public:
    
    CEncoderApp(istream& cInput);
    ~CEncoderApp();
    
    virtual HX_RESULT SetupDLLPaths();
    virtual HX_RESULT InitializeLogSystem();
    virtual HX_RESULT CreateJob();
    virtual HX_RESULT SetupInput();
    virtual HX_RESULT SetupPreviews();
    virtual HX_RESULT SetupInputPreviews();
    virtual HX_RESULT SetupOpenInputPreviews();
    
    virtual HX_RESULT SetupPrefilters();
    virtual HX_RESULT SetupPrefilterPreviews();
    virtual HX_RESULT SetupOpenPrefilterPreviews();
    
    virtual HX_RESULT SetupOutput(INT32* pnOutputIndex);
    virtual HX_RESULT SetupDestination(INT32 nOutputIndex = 0);
    virtual HX_RESULT SetupMediaProfile(INT32 nOutputIndex = 0);
    virtual HX_RESULT SetupAudiences(INT32 nOutputIndex = 0);
    virtual HX_RESULT SetupCodecPreviews();
    
    virtual HX_RESULT SetupJob();
    virtual HX_RESULT SerializeJob();
    
    virtual HX_RESULT SetupClosePreviews();
    
    virtual HX_RESULT StartEncoding();
    virtual HX_RESULT Shutdown();
    virtual HX_RESULT SetupStatsInterfaces();
    virtual HX_RESULT UpdateStats();
    virtual HX_RESULT DumpCodecsInfo();
    virtual HX_RESULT TogglePreviews();
    
    virtual HX_RESULT SendEvent(BOOL bLast = FALSE);
    
private:
    HX_RESULT SetupMultipleInputs();
    HX_RESULT SetupFileInputParams(IHXTPropertyBag** ppInitParams);
    HX_RESULT SetupFileWriterParams(IHXTPropertyBag* pInitParams);
    HX_RESULT SetupG2PushBroadcastParams(IHXTPropertyBag* pInitParams);
    HX_RESULT Setup90PushBroadcastParams(IHXTPropertyBag* pInitParams);
    HX_RESULT SetupCaptureInputParams(IHXTPropertyBag** ppInitParams);
    HX_RESULT SetupEventInputParams(IHXTPropertyBag** ppInitParams);
    HX_RESULT SetupInputParGroupParams(IHXTPropertyBag** ppInitParams);
    HX_RESULT DisplayCaptureDevices(const char* szCaptureType, const char* szDeviceIDType);
    HX_RESULT SetupEvents(IHXTInput2* pInputGroup);
#ifdef _WINDOWS
    HX_RESULT LaunchCaptureDialogs(IHXTInput *pInput, UINT32 ulCaptureDialogType);
#endif
    
    HX_RESULT DumpAllCodecInfo();
    HX_RESULT DumpRealNetworksVideoCodecInfo();
    HX_RESULT DumpAllAudioCodecInfo();
    
    HX_RESULT CreatePreviewSinkInputAudio(UINT32 nSampleRate, UINT32 nSampleSize, UINT32 nNumChannels);
    HX_RESULT CreatePreviewSinkInputVideo(UINT32 nColorFormat, UINT32 nVideoWidth, UINT32 nVideoHeight);
    HX_RESULT CreatePreviewSinkPrefilteredAudio(UINT32 nSampleRate, UINT32 nSampleSize, UINT32 nNumChannels);
    HX_RESULT CreatePreviewSinkPrefilteredVideo(UINT32 nColorFormat, UINT32 nVideoWidth, UINT32 nVideoHeight);
    HX_RESULT CreatePreviewSinkEncodedVideo(UINT32 nColorFormat, UINT32 nVideoWidth, UINT32 nVideoHeight);
    
    HX_RESULT CreateSink(UINT32 nPreviewPosition, const char* szMediaFormat, UINT32 nColorFormat = HXT_VIDEO_FORMAT_BGR24_INVERTED, UINT32 nVideoWidth = 0, UINT32 VideoHeight = 0);
    HX_RESULT CreateAudioSink(IHXTPreviewSinkControl* pIHXTPreviewSinkControl, UINT32 nPreviewPosition, UINT32 nSampleRate = 0, UINT32 nSampleSize = 0, UINT32 nNumChannels = 0);
    HX_RESULT CreateVideoSink(IHXTPreviewSinkControl* pIHXTPreviewSinkControl, UINT32 nPreviewPosition, UINT32 nColorFormat = 0, UINT32 nVideoWidth = 0, UINT32 nVideoHeight = 0);
    
    HX_RESULT DestroyPreviewSinks();
    
    typedef enum
    {
	INPUT_PREVIEW = 1,
	    PREFILTER_PREVIEW,
	    CODEC_PREVIEW
    } ePreviewType;
    
#ifdef _WINDOWS
    typedef enum
    {
	CAPTURE_DIALOG_AUDIO = 1,
	    CAPTURE_DIALOG_VIDEO = 2
    } eCaptureDialogType;
#endif
    
    
    HX_RESULT SetupPreview(ePreviewType nPreviewType);
    HX_RESULT SetupOpenPreviews(ePreviewType nPreviewType);
    
    HX_RESULT SetupAudioPreviewFormat(UINT32* pnSampleRate, UINT32* pnnSampleSize, UINT32* pnNumChannels);
    HX_RESULT SetupVideoPreviewFormat(UINT32* pnColorFormat, UINT32* pnVideoWidth, UINT32* pnVideoHeight);
    
    HX_RESULT GetInput(IHXTInput** ppInput);
    HX_RESULT AddEventsToAudience(IHXTAudience* pAudience);
    HX_RESULT BuildAndAddInput(IHXTPropertyBag* pInitParams, IHXTInput** ppInput = NULL);
    HX_RESULT BuildAndAddMultipleInput(IHXTInput2* pInputGroup, IHXTPropertyBag* pInitParams, IHXTInput** ppInput = NULL);
    
    istream& m_cInput;

    IHXTClassFactory* m_pFactory;
    IHXTStatistics** m_ppAudioStreamStats;
    IHXTStatistics** m_ppVideoStreamStats;
    IHXTEncodingJob* m_pJob;
    
    IHXTMediaInputPin* m_pEventPin;
    
    CSampleLogObserver* m_pSampleLogObserver;
    IHXTFileObserver* m_pFileLogObserver;
    CSampleEventSink* m_pEventSink;
    CSamplePreviewSink* m_ppPreviewSink[MAX_PREVIEW_SINK];
    UINT32 m_nPreviewSinkCount;
    
    INT32 m_nCurrentOutputProfile;
    INT32 m_nCurrentAudience;
    
    BOOL m_bOpenInputPreviews;
    BOOL m_bOpenPrefilterPreviews;
    
    BOOL m_bSinkEnabled;
    BOOL m_bTogglePreviews;
    
    BOOL m_bDoEvents;
    
    IHXTLogSystem* m_pLogSystem;
    
    UINT32 m_ulNumberofAudioStats;
    UINT32 m_ulNumberofVideoStats;
    IHXTPropertyBag* m_pCurentAudioStatsBag;
    IHXTPropertyBag* m_pLifeTimeAudioStatsBag;
    
    IHXTPropertyBag* m_pCurentVideoStatsBag;
    IHXTPropertyBag* m_pLifeTimeVideoStatsBag;
    
    CFileWriter m_StatsWriter;
    char m_szDllPath[2048];
    BOOL m_bEnableStats;
    
#ifdef _WINDOWS
    HMODULE m_RmsessionDLL;
#elif defined _LINUX
    void* m_RmsessionDLL;
#elif defined _MAC_UNIX
    CFBundleRef m_RmsessionDLL;
#endif
};


#endif // _ENCODER_H
