/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 

#ifndef _RMMETAIN_H_
#define _RMMETAIN_H_

/*
 * Forward declarations of some interfaces defined here-in.
 */

typedef _INTERFACE IUnknown			IUnknown;
typedef _INTERFACE IHXRMMetaInformation	IHXRMMetaInformation;
typedef _INTERFACE IHXValues	IHXValues;
 

// constant strings defined for Meta Information names
// these will be automatically searched for by search engines

#define RM_PROPERTY_KEYWORDS "Keywords"
#define RM_PROPERTY_DESCRIPTION "Description"
#define RM_PROPERTY_GENERATOR "Generated By" // application which created the file, by default this will be set to RealMedia Build Engine

#define RM_PROPERTY_CONTENT_RATING "Content Rating"

// the following properties will be automatically added by the Build Engine
#define RM_PROPERTY_CREATION_DATE "Creation Date"
#define RM_PROPERTY_MODIFICATION_DATE "Modification Date"
#define RM_PROPERTY_TARGET_AUDIENCES "Audiences"
#define RM_PROPERTY_AUDIO_FORMAT "audioMode"
#define RM_PROPERTY_VIDEO_QUALITY "videoMode"

// when we are archiving a file on the encoding machine during a live broadcast, we save the 
// clock-time at which the stream began, since the file is timestamped from 0
// this value will not be present in files which are not archived broadcasts
#define RM_PROPERTY_CLOCK_START_TIME "Clock Start Time" // UINT32 

#endif //_RMMETAIN_H_
