/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 

#ifndef _RMFLSNK_H_
#define _RMFLSNK_H_

struct	IHXValues;
struct	IHXPacket;

/****************************************************************************
 * 
 *  Interface:
 *
 *	IID_IHXRMFileSink
 *
 *  Purpose:
 *
 *	A sink interface that can be registered with the IRMARMFFEditor interface allowing the user
 *  to modify (encrypt) the RM file headers and packets before they are written to the file.
 *
 *  IID_IHXRMFileSink:
 *
 *  {19137680-377B-11d2-A1C4-0060083BE563}
 *	
 *
 */

// The IHXValues parameter in the OnMediaHeader() callback allows you to access the following:
#define RM_MEDIA_PROP_STREAM_NUMBER			"RM_MEDIA_PROP_STREAM_NUMBER"
#define RM_MEDIA_PROP_MIMETYPE				"RM_MEDIA_PROP_MIMETYPE"
#define RM_MEDIA_PROP_TYPE_SPECIFIC_DATA	"RM_MEDIA_PROP_TYPE_SPECIFIC_DATA"

DEFINE_GUID(IID_IHXRMFileSink,
	    0x19137680, 0x377b, 0x11d2, 0xa1, 0xc4, 0x0, 0x60, 0x8, 0x3b, 0xe5, 0x63);

#undef INTERFACE
#define INTERFACE IHXRMFileSink

DECLARE_INTERFACE_(IHXRMFileSink, IUnknown)
{
    /***********************************************************************/
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					 REFIID riid,
					 void** ppvObj) PURE;

    STDMETHOD_(UINT32,AddRef)		(THIS) PURE;

    STDMETHOD_(UINT32,Release)		(THIS) PURE;

    /***********************************************************************/
    /*
     * IHXRMFileSink methods
     */
   
    /************************************************************************
     *	Method:
     *	    IHXRMFileSink::OnPacket
     *	Purpose:
     *	    After you have registered your IHXRMFileSink this method will be called every 
	 *		time that a packet is about to be written to .rm file. You will have the opportunity
	 *		to modify (encrypt) the data buffer of the packet before it is written to the file.
	 */

    STDMETHOD(OnPacket)	(THIS_
		IHXPacket* pMediaPacket, BOOL bIsKeyFrame) PURE;

    /************************************************************************
     *	Method:
     *	    IHXRMFileSink::OnMediaPropertyHeader
     *	Purpose:
     *	    After you have registered your IHXRMFileSink sink on of these methods will be called every 
	 *		time that a header (Property, MediaProperty or Content) is about to be written to .rm file. You will have the
	 *		opportunity to modify (encrypt) the type specific data of the header or mimetype 
	 *		before it is written to the file.
	 */

    STDMETHOD(OnMediaPropertyHeader) (THIS_
		IHXValues* pValues) PURE;

};

/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXRMFileSinkControl
 *
 *  Purpose:
 *
 *	A control sink interface to add and remove the RM File Sink to modify 
 *	data as it is being written. Because the data is written after the sink
 *	is notified, there can only be one sink at a time.
 *
 *  IID_IHXRMFileSinkControl:
 *
 *  {0CB88B91-A444-11d2-8792-00C0F031938B}
 *	
 *
 */
DEFINE_GUID(IID_IHXRMFileSinkControl, 
	    0xcb88b91, 0xa444, 0x11d2, 0x87, 0x92, 0x0, 0xc0, 0xf0, 0x31, 0x93, 0x8b);

#undef INTERFACE
#define INTERFACE IHXRMFileSinkControl

DECLARE_INTERFACE_(IHXRMFileSinkControl, IUnknown)
{
    /***********************************************************************/
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					 REFIID riid,
					 void** ppvObj) PURE;

    STDMETHOD_(UINT32,AddRef)		(THIS) PURE;

    STDMETHOD_(UINT32,Release)		(THIS) PURE;

    /***********************************************************************/
    /*
     * IHXRMFileSinkControl methods
     */
   
    /************************************************************************
     *	Method:
     *	    IHXRMFileSinkControl::SetRMFileSink
     *	Purpose:
     *	    Set the active RMFileSink. There can only be one RM File Sink at a
     *	    time
     */
    STDMETHOD(SetRMFileSink)	(THIS_
				IHXRMFileSink* pRMFileSink) PURE;

    /************************************************************************
     *	Method:
     *	    IHXRMFileSinkControl::RemoveRMFileSink
     *	Purpose:
     *	    Remove this RMFileSink. The RMFileSink will be removed if it is the
     *	    active RM File Sink;
     */
    STDMETHOD(RemoveRMFileSink)	(THIS_
				IHXRMFileSink* pRMFileSink) PURE;
};

#endif //_RMFLSNK_H_
