/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 



#ifndef _HXTPROPERTYBAG_H
#define _HXTPROPERTYBAG_H

#include "hxcom.h"


_INTERFACE IHXTProperty;
_INTERFACE IHXTPropertyBag;


enum EHXTTypeId
{
	eTypeNone = 0,
	eTypeBOOL,
	eTypeINT32,
	eTypeUINT32,
	eTypeINT64,
	eTypeDouble,

	eTypeCString,

	eTypeIntList,
	eTypeUintList,
	eTypeInt64List,
	eTypeDoubleList,

	eTypeIntRange,
	eTypeUintRange,
	eTypeInt64Range,
	eTypeDoubleRange,

	eTypeUnknown,		/* used for property  */
	eTypeComposite,
	eTypeCustomComparison
};


/****************************************************************************
 *
 * IHXTPropertyEnumerator
 *
 */

/* {DE3AF55D-E608-4b96-B14A-9B1B63EE6D4E} */
DEFINE_GUID( IID_IHXTPropertyEnumerator, 0xde3af55d, 0xe608, 0x4b96, 0xb1, 0x4a, 0x9b, 0x1b, 0x63, 0xee, 0x6d, 0x4e);
DECLARE_INTERFACE_( IHXTPropertyEnumerator, IUnknown )
{												
	STDMETHOD_( UINT32, GetCount)( THIS ) const PURE;	
												
    STDMETHOD( First )( THIS_ IHXTProperty **pValue ) PURE;	
	STDMETHOD( Next )( THIS_ IHXTProperty **pValue ) PURE;		
    STDMETHOD( Current )( THIS_ IHXTProperty **pValue ) PURE;  
};												


/* {B79B102D-2ADD-4a2f-9258-6CEA02F38355} */
DEFINE_GUID( IID_IHXTIntEnumerator, 0xb79b102d, 0x2add, 0x4a2f, 0x92, 0x58, 0x6c, 0xea, 0x2, 0xf3, 0x83, 0x55);
DECLARE_INTERFACE_( IHXTIntEnumerator, IUnknown )			
{												
	STDMETHOD_( UINT32, GetCount)( THIS ) const PURE;	
												
    STDMETHOD( First )( THIS_ INT32 *pValue ) PURE;	
	STDMETHOD( Next )( THIS_ INT32 *pValue ) PURE;		
    STDMETHOD( Current )( THIS_ INT32 *pValue ) PURE;  
};												


/* {FB119200-6A26-4275-9722-F2E6A0EDBF65} */
DEFINE_GUID( IID_IHXTUintEnumerator, 0xfb119200, 0x6a26, 0x4275, 0x97, 0x22, 0xf2, 0xe6, 0xa0, 0xed, 0xbf, 0x65);
DECLARE_INTERFACE_( IHXTUintEnumerator, IUnknown )			
{												
	STDMETHOD_( UINT32, GetCount)( THIS ) const PURE;	
												
    STDMETHOD( First )( THIS_ UINT32 *pValue ) PURE;	
	STDMETHOD( Next )( THIS_ UINT32 *pValue ) PURE;		
    STDMETHOD( Current )( THIS_ UINT32 *pValue ) PURE;  
};												


/* {F3687366-C7BA-4512-8013-B633C80FA4F2} */
DEFINE_GUID( IID_IHXTInt64Enumerator, 0xf3687366, 0xc7ba, 0x4512, 0x80, 0x13, 0xb6, 0x33, 0xc8, 0xf, 0xa4, 0xf2);
DECLARE_INTERFACE_( IHXTInt64Enumerator, IUnknown )			
{												
	STDMETHOD_( UINT32, GetCount)( THIS ) const PURE;	
												
    STDMETHOD( First )( THIS_ INT64 *pValue ) PURE;	
	STDMETHOD( Next )( THIS_ INT64 *pValue ) PURE;		
    STDMETHOD( Current )( THIS_ INT64 *pValue ) PURE;  
};												


/* {8B9435F7-C7A4-4dc0-B726-05D617E7727C} */
DEFINE_GUID( IID_IHXTDoubleEnumerator, 0x8b9435f7, 0xc7a4, 0x4dc0, 0xb7, 0x26, 0x5, 0xd6, 0x17, 0xe7, 0x72, 0x7c);
DECLARE_INTERFACE_( IHXTDoubleEnumerator, IUnknown )			
{												
	STDMETHOD_( UINT32, GetCount)( THIS ) const PURE;	
												
    STDMETHOD( First )( THIS_ double *pValue ) PURE;	
	STDMETHOD( Next )( THIS_ double *pValue ) PURE;		
    STDMETHOD( Current )( THIS_ double *pValue ) PURE;  
};												


/* {C33AB619-BFC4-41c3-9B91-C46954FB7AB0} */
DEFINE_GUID( IID_IHXTStringEnumerator, 0xc33ab619, 0xbfc4, 0x41c3, 0x9b, 0x91, 0xc4, 0x69, 0x54, 0xfb, 0x7a, 0xb0);
DECLARE_INTERFACE_( IHXTStringEnumerator, IUnknown )			
{												
	STDMETHOD_( UINT32, GetCount)( THIS ) const PURE;	
												
    STDMETHOD( First )( THIS_ PCSTR *pValue ) PURE;	
	STDMETHOD( Next )( THIS_ PCSTR *pValue ) PURE;		
    STDMETHOD( Current )( THIS_ PCSTR *pValue ) PURE;  
};												




/* IHXTIntRange */
/* {C3A72969-7B9A-42b3-9EDE-0CA689CDAE1B} */
DEFINE_GUID( IID_IHXTIntRange, 0xc3a72969, 0x7b9a, 0x42b3, 0x9e, 0xde, 0xc, 0xa6, 0x89, 0xcd, 0xae, 0x1b);
DECLARE_INTERFACE_( IHXTIntRange, IUnknown )											
{																				
	STDMETHOD_( INT32, GetMin )( THIS ) const PURE;									
	STDMETHOD_( INT32, GetMax )( THIS ) const PURE;									
	STDMETHOD_( INT32, GetStepSize )( THIS ) const PURE;								
																				
	STDMETHOD( Set )( THIS_ INT32 uMin, INT32 uMax, INT32 uStepSize = 1 ) PURE;			
																				
	STDMETHOD_( BOOL, IsInRange )( THIS_ INT32 uValue ) const PURE;					
	STDMETHOD( Compare )( THIS_ IHXTIntRange *pRange, IHXTIntRange **ppResult ) const PURE;	
};																				


#define IHXTRange IHXTIntRange
#define IHXTRangePtr IHXTIntRangePtr

/* IHXTUintRange */
/* {6BB9FEA0-A1BC-498c-B08F-800C95A30A19} */
DEFINE_GUID( IID_IHXTUintRange, 0x6bb9fea0, 0xa1bc, 0x498c, 0xb0, 0x8f, 0x80, 0xc, 0x95, 0xa3, 0xa, 0x19);
DECLARE_INTERFACE_( IHXTUintRange, IUnknown )											
{																				
	STDMETHOD_( UINT32, GetMin )( THIS ) const PURE;									
	STDMETHOD_( UINT32, GetMax )( THIS ) const PURE;									
	STDMETHOD_( UINT32, GetStepSize )( THIS ) const PURE;								
																				
	STDMETHOD( Set )( THIS_ UINT32 uMin, UINT32 uMax, UINT32 uStepSize = 1 ) PURE;			
																				
	STDMETHOD_( BOOL, IsInRange )( THIS_ UINT32 uValue ) const PURE;					
	STDMETHOD( Compare )( THIS_ IHXTUintRange *pRange, IHXTUintRange **ppResult ) const PURE;	
};																				


/* {CE755DAF-5402-44c5-9FE3-187B341401BF} */
DEFINE_GUID( IID_IHXTInt64Range, 0xce755daf, 0x5402, 0x44c5, 0x9f, 0xe3, 0x18, 0x7b, 0x34, 0x14, 0x1, 0xbf);
DECLARE_INTERFACE_( IHXTInt64Range, IUnknown )											
{																				
	STDMETHOD_( INT64, GetMin )( THIS ) const PURE;									
	STDMETHOD_( INT64, GetMax )( THIS ) const PURE;									
	STDMETHOD_( INT64, GetStepSize )( THIS ) const PURE;								
																				
	STDMETHOD( Set )( THIS_ INT64 uMin, INT64 uMax, INT64 uStepSize = 1 ) PURE;			
																				
	STDMETHOD_( BOOL, IsInRange )( THIS_ INT64 uValue ) const PURE;					
	STDMETHOD( Compare )( THIS_ IHXTInt64Range *pRange, IHXTInt64Range **ppResult ) const PURE;	
};																				


/* {B560CB1B-5A07-40bf-9C1E-41537F1B2485} */
DEFINE_GUID( IID_IHXTDoubleRange, 0xb560cb1b, 0x5a07, 0x40bf, 0x9c, 0x1e, 0x41, 0x53, 0x7f, 0x1b, 0x24, 0x85);
DECLARE_INTERFACE_( IHXTDoubleRange, IUnknown )
{
	STDMETHOD_( double, GetMin )( THIS ) const PURE;
	STDMETHOD_( double, GetMax )( THIS ) const PURE;
	STDMETHOD_( double, GetStepSize )( THIS ) const PURE;
	STDMETHOD_( double, GetError )( THIS ) const PURE;

	STDMETHOD( Set )( double dMin, double dMax, double dStepSize, double dError ) PURE;

	STDMETHOD_( BOOL, IsInRange )( THIS_ double dValue ) const PURE;
	STDMETHOD( Compare )( THIS_ IHXTDoubleRange *pRange, IHXTDoubleRange **ppResult ) const PURE;
};


/* create interface for a list of integers */
  

/* {0AF8BC8C-8157-48ef-865E-F75F5E539ABC} */
DEFINE_GUID( IID_IHXTIntList, 0xaf8bc8c, 0x8157, 0x48ef, 0x86, 0x5e, 0xf7, 0x5f, 0x5e, 0x53, 0x9a, 0xbc);
DECLARE_INTERFACE_( IHXTIntList, IUnknown )							
{																		
	STDMETHOD_( INT32, GetFront )( THIS ) PURE;								
	STDMETHOD_( INT32, PopFront )( THIS ) PURE;								
	STDMETHOD( PushFront )( THIS_ INT32 value ) PURE;							
																		
	STDMETHOD_( INT32, GetBack )( THIS ) PURE;									
	STDMETHOD_( INT32, PopBack )( THIS ) PURE;									
	STDMETHOD( PushBack )( THIS_ INT32 value ) PURE;							
																		
	STDMETHOD_( UINT32, GetSize )( THIS ) PURE;								
	STDMETHOD_( BOOL, IsEmpty )( THIS ) PURE;									
																		
	STDMETHOD( Clear )( THIS ) PURE;											
																		
  	STDMETHOD( Compare )( THIS_ IHXTIntList *pList, INT32 *puValue ) const PURE;
	STDMETHOD( GetIntersection )( THIS_ IHXTIntList *pList, IHXTIntList **ppIntersection ) const PURE;
  	STDMETHOD_( BOOL, Contains )( THIS_ INT32 value ) const PURE;				
																		
	STDMETHOD( GetEnumerator )( THIS_ IHXTIntEnumerator **pEnumerator ) PURE;	
};																		




/* {1548135D-84CF-4102-AA6D-22245C480B74} */
DEFINE_GUID( IID_IHXTUintList, 0x1548135d, 0x84cf, 0x4102, 0xaa, 0x6d, 0x22, 0x24, 0x5c, 0x48, 0xb, 0x74);
DECLARE_INTERFACE_( IHXTUintList, IUnknown )							
{																		
	STDMETHOD_( UINT32, GetFront )( THIS ) PURE;								
	STDMETHOD_( UINT32, PopFront )( THIS ) PURE;								
	STDMETHOD( PushFront )( THIS_ UINT32 value ) PURE;							
																		
	STDMETHOD_( UINT32, GetBack )( THIS ) PURE;									
	STDMETHOD_( UINT32, PopBack )( THIS ) PURE;									
	STDMETHOD( PushBack )( UINT32 value ) PURE;							
																		
	STDMETHOD_( UINT32, GetSize )( THIS ) PURE;								
	STDMETHOD_( BOOL, IsEmpty )( THIS ) PURE;									
																		
	STDMETHOD( Clear )( THIS ) PURE;											
																		
  	STDMETHOD( Compare )( THIS_ IHXTUintList *pList, UINT32 *puValue ) const PURE;
	STDMETHOD( GetIntersection )( THIS_ IHXTUintList *pList, IHXTUintList **ppIntersection ) const PURE;
  	STDMETHOD_( BOOL, Contains )( THIS_ UINT32 value ) const PURE;				
																		
	STDMETHOD( GetEnumerator )( THIS_ IHXTUintEnumerator **pEnumerator ) PURE;	
};																		



/* {2E89B96E-AE62-43d7-B819-61D979605FC7} */
DEFINE_GUID( IID_IHXTInt64List, 0x2e89b96e, 0xae62, 0x43d7, 0xb8, 0x19, 0x61, 0xd9, 0x79, 0x60, 0x5f, 0xc7);
DECLARE_INTERFACE_( IHXTInt64List, IUnknown )							
{																		
	STDMETHOD_( INT64, GetFront )( THIS ) PURE;								
	STDMETHOD_( INT64, PopFront )( THIS ) PURE;								
	STDMETHOD( PushFront )( THIS_ INT64 value ) PURE;							
																		
	STDMETHOD_( INT64, GetBack )( THIS ) PURE;									
	STDMETHOD_( INT64, PopBack )( THIS ) PURE;									
	STDMETHOD( PushBack )( THIS_ INT64 value ) PURE;							
																		
	STDMETHOD_( UINT32, GetSize )( THIS ) PURE;								
	STDMETHOD_( BOOL, IsEmpty )( THIS ) PURE;									
																		
	STDMETHOD( Clear )( THIS ) PURE;											
																		
  	STDMETHOD( Compare )( THIS_ IHXTInt64List *pList, INT64 *puValue ) const PURE;
	STDMETHOD( GetIntersection )( THIS_ IHXTInt64List *pList, IHXTInt64List **ppIntersection ) const PURE;
  	STDMETHOD_( BOOL, Contains )( THIS_ INT64 value ) const PURE;				
																		
	STDMETHOD( GetEnumerator )( THIS_ IHXTInt64Enumerator **pEnumerator ) PURE;	
};																		


/* {BCF2A536-4D85-4bff-B114-E38268623476} */
DEFINE_GUID( IID_IHXTDoubleList, 0xbcf2a536, 0x4d85, 0x4bff, 0xb1, 0x14, 0xe3, 0x82, 0x68, 0x62, 0x34, 0x76);
DECLARE_INTERFACE_( IHXTDoubleList, IUnknown )							
{																		
	STDMETHOD_( double, GetFront )( THIS ) PURE;								
	STDMETHOD_( double, PopFront )( THIS ) PURE;								
	STDMETHOD( PushFront )( THIS_ double value ) PURE;							
																		
	STDMETHOD_( double, GetBack )( THIS ) PURE;									
	STDMETHOD_( double, PopBack )( THIS ) PURE;									
	STDMETHOD( PushBack )( THIS_ double value ) PURE;							
																		
	STDMETHOD_( UINT32, GetSize )( THIS ) PURE;								
	STDMETHOD_( BOOL, IsEmpty )( THIS ) PURE;									
																		
	STDMETHOD( Clear )( THIS ) PURE;											
																		
  	STDMETHOD( Compare )( THIS_ IHXTDoubleList *pList, double *puValue ) const PURE;
	STDMETHOD( GetIntersection )( THIS_ IHXTDoubleList *pList, IHXTDoubleList **ppIntersection ) const PURE;
  	STDMETHOD_( BOOL, Contains )( THIS_ double value ) const PURE;				
																		
	STDMETHOD( GetEnumerator )( THIS_ IHXTDoubleEnumerator **pEnumerator ) PURE;	
};																		

/****************************************************************************
 *
 *	IHXTCustomComparison
 *
 */
DECLARE_INTERFACE_( IHXTCustomComparison, IUnknown )
{
	STDMETHOD( Compare )( THIS_ IUnknown *pConnectingProperty, IUnknown **ppNegotiatedProperty ) PURE;
};

// {A9A58DAF-97A7-469a-AE53-E817CFE97AD0}
DEFINE_GUID( IID_IHXTCustomComparison, 0xa9a58daf, 0x97a7, 0x469a, 0xae, 0x53, 0xe8, 0x17, 0xcf, 0xe9, 0x7a, 0xd0);


/****************************************************************************
 *
 * IHXTProperty
 *
 */
DECLARE_INTERFACE_( IHXTProperty, IUnknown )
{
	STDMETHOD_( const CHAR*, GetKey)( THIS ) const PURE;
	STDMETHOD_(UINT32, GetType)( THIS ) const PURE;

	STDMETHOD(GetBool)( BOOL *pbValue ) const PURE;
	STDMETHOD(SetBool)( BOOL bValue ) PURE;
	
	/* access to integer elements */
	STDMETHOD(GetInt)( INT32 *pnValue ) const PURE;
	STDMETHOD(SetInt)( INT32 nValue ) PURE;
	
	/* access to unsigned integer elements */
	STDMETHOD(GetUint)( UINT32 *puValue ) const PURE;
	STDMETHOD(SetUint)( UINT32 uValue ) PURE;
	
	/* access to int64 elements */
	STDMETHOD(GetInt64)( INT64 *pn64Value ) const PURE;
	STDMETHOD(SetInt64)( INT64 n64Value ) PURE;
	
	/* access to double elements */
	STDMETHOD(GetDouble)( double *pdValue ) const PURE;
	STDMETHOD(SetDouble)( double dValue ) PURE;
	
	/* access to string elements */
	STDMETHOD(GetString)( const CHAR **pcszValue ) const PURE;
	STDMETHOD(SetString)( const CHAR *cszValue ) PURE;
	
	/* access to list elements (elements that are lists themselves) */
	STDMETHOD(GetIntList)( IHXTIntList **ppValue ) const PURE;
	STDMETHOD(SetIntList)( IHXTIntList *pValue ) PURE;

	/* access to list elements (elements that are lists themselves) */
	STDMETHOD(GetUintList)( IHXTUintList **ppValue ) const PURE;
	STDMETHOD(SetUintList)( IHXTUintList *pValue ) PURE;

	/* access to list elements (elements that are lists themselves) */
	STDMETHOD(GetInt64List)( IHXTInt64List **ppValue ) const PURE;
	STDMETHOD(SetInt64List)( IHXTInt64List *pValue ) PURE;

	/* access to list elements (elements that are lists themselves) */
	STDMETHOD(GetDoubleList)( IHXTDoubleList **ppValue ) const PURE;
	STDMETHOD(SetDoubleList)( IHXTDoubleList *pValue ) PURE;

	/* access to "int-range" elements */
	STDMETHOD(GetIntRange)( IHXTIntRange **ppValue ) const PURE;
	STDMETHOD(SetIntRange)( IHXTIntRange *pValue ) PURE;

	/* access to "unsigned-int-range" elements */
	STDMETHOD(GetUintRange)( IHXTUintRange **ppValue ) const PURE;
	STDMETHOD(SetUintRange)( IHXTUintRange *pValue ) PURE;

	/* access to "int64-range" elements */
	STDMETHOD(GetInt64Range)( IHXTInt64Range **ppValue ) const PURE;
	STDMETHOD(SetInt64Range)( IHXTInt64Range *pValue ) PURE;

	/* access to "double-range" elements */
	STDMETHOD(GetDoubleRange)( IHXTDoubleRange **ppValue ) const PURE;
	STDMETHOD(SetDoubleRange)( IHXTDoubleRange *pValue ) PURE;

	/* catch all for com objects */
	STDMETHOD( GetUnknown )( IUnknown **ppType ) const PURE;
	STDMETHOD( SetUnknown )( IUnknown *pType ) PURE;

	/* access to nested property elements */
	STDMETHOD(GetPropertyBag)( IHXTPropertyBag **ppValue ) const PURE;
	STDMETHOD(SetPropertyBag)( IHXTPropertyBag *pValue ) PURE;
};

/* {0FF75E41-6F66-4392-BE4A-71030C434BF0} */
DEFINE_GUID( IID_IHXTProperty, 0xff75e41, 0x6f66, 0x4392, 0xbe, 0x4a, 0x71, 0x3, 0xc, 0x43, 0x4b, 0xf0);


/****************************************************************************
 *
 *	IHXTPropertyBag
 *
 */
DECLARE_INTERFACE_( IHXTPropertyBag, IUnknown )
{
	
	/* attribute access */
	

	STDMETHOD_(UINT32, GetCount)( THIS ) PURE;

	
	/* direct access */
	

	/* access to bool values */
	STDMETHOD(GetBool)( THIS_ const CHAR* pName, BOOL *pbValue ) PURE;
	STDMETHOD(SetBool)( THIS_ const CHAR* pName, BOOL bValue ) PURE;
	

	/* access to integer elements */
	STDMETHOD(GetInt)( THIS_ const CHAR* pName, INT32 *puValue ) PURE;
	STDMETHOD(SetInt)( THIS_ const CHAR* pName, INT32 nValue ) PURE;
	
	/* access to unsigned integer elements */
	STDMETHOD(GetUint)( THIS_ const CHAR* pName, UINT32 *puValue ) PURE;
	STDMETHOD(SetUint)( THIS_ const CHAR* pName, UINT32 uValue ) PURE;
	
	/* access to int64 elements */
	STDMETHOD(GetInt64)( THIS_ const CHAR* pName, INT64 *puValue ) PURE;
	STDMETHOD(SetInt64)( THIS_ const CHAR* pName, INT64 nValue ) PURE;
	
	/* access to double elements */
	STDMETHOD(GetDouble)( THIS_ const CHAR* pName, double *puValue ) PURE;
	STDMETHOD(SetDouble)( THIS_ const CHAR* pName, double nValue ) PURE;
	
	/* access to string elements */
	STDMETHOD(GetString)( THIS_ const CHAR* pName, const CHAR **pcszValue ) PURE;
	STDMETHOD(SetString)( THIS_ const CHAR* pName, const CHAR *cszValue ) PURE;

	
	/* access to list elements (elements that are lists themselves) */
	STDMETHOD(GetIntList)( THIS_ const CHAR* pName, IHXTIntList **ppValue ) PURE;
	STDMETHOD(SetIntList)( THIS_ const CHAR* pName, IHXTIntList *pValue ) PURE;

	/* access to list elements (elements that are lists themselves) */
	STDMETHOD(GetUintList)( THIS_ const CHAR* pName, IHXTUintList **ppValue ) PURE;
	STDMETHOD(SetUintList)( THIS_ const CHAR* pName, IHXTUintList *pValue ) PURE;

	/* access to list elements (elements that are lists themselves) */
	STDMETHOD(GetInt64List)( THIS_ const CHAR* pName, IHXTInt64List **ppValue ) PURE;
	STDMETHOD(SetInt64List)( THIS_ const CHAR* pName, IHXTInt64List *pValue ) PURE;

	/* access to list elements (elements that are lists themselves) */
	STDMETHOD(GetDoubleList)( THIS_ const CHAR* pName, IHXTDoubleList **ppValue ) PURE;
	STDMETHOD(SetDoubleList)( THIS_ const CHAR* pName, IHXTDoubleList *pValue ) PURE;


	/* access to "int-range" elements */
	STDMETHOD(GetIntRange)( THIS_ const CHAR* pName, IHXTIntRange **ppValue ) PURE;
	STDMETHOD(SetIntRange)( THIS_ const CHAR* pName, IHXTIntRange *pValue ) PURE;

	/* access to "unsigned-int-range" elements */
	STDMETHOD(GetUintRange)( THIS_ const CHAR* pName, IHXTUintRange **ppValue ) PURE;
	STDMETHOD(SetUintRange)( THIS_ const CHAR* pName, IHXTUintRange *pValue ) PURE;

	/* access to "int64-range" elements */
	STDMETHOD(GetInt64Range)( THIS_ const CHAR* pName, IHXTInt64Range **ppValue ) PURE;
	STDMETHOD(SetInt64Range)( THIS_ const CHAR* pName, IHXTInt64Range *pValue ) PURE;

	/* access to "double-range" elements */
	STDMETHOD(GetDoubleRange)( THIS_ const CHAR* pName, IHXTDoubleRange **ppValue ) PURE;
	STDMETHOD(SetDoubleRange)( THIS_ const CHAR* pName, IHXTDoubleRange *pValue ) PURE;


	/* catch all for com objects */
	STDMETHOD( GetUnknown )( THIS_ const CHAR* pName, IUnknown **ppType ) PURE;
	STDMETHOD( SetUnknown )( THIS_ const CHAR* pName, IUnknown *pType ) PURE;


	/* access to property objects */
	STDMETHOD(GetProperty)( THIS_ const CHAR* pName, IHXTProperty **pProperty ) PURE;
	STDMETHOD(SetProperty)( THIS_ IHXTProperty *pProperty ) PURE; 

	/* access to nested property elements */
	STDMETHOD(GetPropertyBag)( THIS_ const CHAR* pName, IHXTPropertyBag **ppValue ) PURE;
	STDMETHOD(SetPropertyBag)( THIS_ const CHAR* pName, IHXTPropertyBag *pValue ) PURE;


	/* removal */
	STDMETHOD( Remove )( THIS_ const CHAR* pName ) PURE;

	
	/* enumerator access */

	STDMETHOD(GetPropertyEnumerator)( THIS_ IHXTPropertyEnumerator **ppEnumerator ) PURE;
	STDMETHOD(GetPropertyBagEnumerator)( THIS_ IHXTPropertyEnumerator **ppEnumerator ) PURE;
};

/* {4C959CF0-35F9-40f2-84DD-091537702C34} */
DEFINE_GUID( IID_IHXTPropertyBag, 0x4c959cf0, 0x35f9, 0x40f2, 0x84, 0xdd, 0x9, 0x15, 0x37, 0x70, 0x2c, 0x34);


DECLARE_INTERFACE_( IHXTPropertyUtility, IUnknown )
{
	STDMETHOD( IsPropertyCompatibleWith )( IHXTProperty *pProperty1, 
								   IHXTProperty *pProperty2,
								   IHXTProperty **ppResult = NULL ) PURE;
	STDMETHOD( IsPropertyBagCompatibleWith )( IHXTPropertyBag *pPropertyBag1, 
									  IHXTPropertyBag *pPropertyBag2,
									  IHXTPropertyBag **ppResult = NULL ,
									  IHXTPropertyBag **ppErrors = NULL ) PURE;

	STDMETHOD( ArePropertyBagsEquivalent )( IHXTPropertyBag *pPropertyBag1, 
											IHXTPropertyBag *pPropertyBag2 ) PURE;
	STDMETHOD( ArePropertiesEquivalent )( IHXTProperty *pProperty1, 
										  IHXTProperty *pProperty2 ) PURE;

	STDMETHOD( CloneProperty )( IHXTProperty *pSourceProp, IHXTProperty **ppClonedProp = NULL ) PURE;
	STDMETHOD( ClonePropertyBag )( IHXTPropertyBag *pSourceBag, IHXTPropertyBag **ppClonedBag = NULL ) PURE;
};

// {4EFFA493-982B-4fd7-B25F-34B2859B0A24}
DEFINE_GUID( IID_IHXTPropertyUtility, 0x4effa493, 0x982b, 0x4fd7, 0xb2, 0x5f, 0x34, 0xb2, 0x85, 0x9b, 0xa, 0x24);



#endif // _HXTPROPERTYBAG_H
