/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 



#ifndef _HXTPREVIEWSINK_H
#define _HXTPREVIEWSINK_H

#include "ihxtbase.h"


/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXTPreviewSink
 *
 *  Purpose:
 *	
 *  This is the interface used to receive preview media samples
 *   
 *  IID_IHXTInputPreviewControl:
 *
 *  {B9EE69F3-BE4F-4a9b-90D0-0FE318E4F58A}
 *
 *
 */
DEFINE_GUID(IID_IHXTPreviewSink, 
0xb9ee69f3, 0xbe4f, 0x4a9b, 0x90, 0xd0, 0xf, 0xe3, 0x18, 0xe4, 0xf5, 0x8a);


#undef  INTERFACE
#define INTERFACE   IHXTPreviewSink

DECLARE_INTERFACE_(IHXTPreviewSink, IUnknown)
{
    /***********************************************************************/
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					 REFIID riid,
					 void** ppvObj) PURE;

    STDMETHOD_(UINT32,AddRef)		(THIS) PURE;

    STDMETHOD_(UINT32,Release)		(THIS) PURE;

    /***********************************************************************/
    /*
     *	IHXTPreviewSink methods
     */

    /************************************************************************
     *	Method:
     *	    IHXTPreviewSink::OnFormatChanged
     *	Purpose:
     *	    This is called to indicate that the next sample sent via 
     *      this interface's OnSample() call is going to be with a different
     *      format.
     *  Parameters:
     *      pProps - this property bag is filled with the following
     *                properties.
     *          + kPropMediaFormat (string) Currently only 
     *            kValueMediaFormatUncompVideo or kValueMediaFormatUncompAudio
     *            is supported.
     *          + if (kPropMediaFormat == kValueMediaFormatUncompVideo)
     *            + kPropVideoFrameWidth (UINT32)
     *            + kPropVideoFrameHeight (UINT32)
     *            + kPropVideoColorFormat (UINT32) See ihxtconstants.h for full
     *              list of valid color formats.
     *            + any other properties by the filter found immediately
     *              before the preview sink's registered location.
     *          + if (kPropMediaFormat == kValueMediaFormatUncompAudio)
     *            + any properties by the filter found immediately
     *              before the preview sink's registered location.
     */
     STDMETHOD(OnFormatChanged) (THIS_
                                IHXTPropertyBag* pProps) PURE;


    /************************************************************************
     *	Method:
     *	    IHXTPreviewSink::OnSample
     *	Purpose:
     *	    This is the method that is called when a new media sample is
     *      available.
     *  Parameters:
     *      pSample - the new sample
	 */
     STDMETHOD(OnSample) (THIS_
                         IHXTMediaSample* pSample) PURE;
};






/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXTPreviewSinkControl
 *
 *  Purpose:
 *
 *  This interface used to register preview sinks. It is currently
 *  implemented by the IHXTInput object, and the IHXTAudience object
 *
 *  IID_IHXTPreviewSinkControl:
 *
 *  {F71A6355-0DD6-4f3f-ABC9-9A383258FBD0}
 *
 *
 */
DEFINE_GUID(IID_IHXTPreviewSinkControl, 
0xf71a6355, 0xdd6, 0x4f3f, 0xab, 0xc9, 0x9a, 0x38, 0x32, 0x58, 0xfb, 0xd0);

#undef  INTERFACE
#define INTERFACE   IHXTPreviewSinkControl

DECLARE_INTERFACE_(IHXTPreviewSinkControl, IUnknown)
{
    /***********************************************************************/
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					 REFIID riid,
					 void** ppvObj) PURE;

    STDMETHOD_(UINT32,AddRef)		(THIS) PURE;

    STDMETHOD_(UINT32,Release)		(THIS) PURE;


    /***********************************************************************/
    /*
     *	IHXTPreviewSinkControl methods
     */


    /************************************************************************
     *	Method:
     *	    IHXTPreviewSinkControl::GetOptimalSinkProperties
     *	Purpose:
     *        Method used to get the optimal (the least CPU instensive)
     *        properties to use when registering as a preview sink (by 
     *        calling AddSink). If this call is successful, the
     *        passed in property bag is filled with the relevant property
     *        info.  See below for description of the meaning for these
     *        parameters.
     *	      
     *	      It an invalid type is passed in for kPropPreviewSinkPosition
     *	      it is converted to the appropriate type (e.g. INT32 converted
     *	      to UINT32 in the returned property bag.
     *
     *  Parameters:
     *      ppProps - Points to property bag that caller created that
     *                contains the following properties:
     *
     *          + kPropMediaFormat (string) Currently only 
     *            kValueMediaFormatUncompVideo or kValueMediaFormatUncompAudio
     *            is supported.
     *          + kPropPreviewSinkPosition (UINT32) This is the position in
     *            the prefilter chain for which the caller wishes to insert
     *            a sink. Valid values are kValueBeforeAllPrefilters,
     *            kValueAfterAllPrefilters, or kValueAfterCodec.
     *
     *                
     *                If successful, this method will add the following
     *                properties to the bag:
     *
     *          + if (kPropMediaFormat == kValueMediaFormatUncompVideo)
     *            + kPropVideoFrameWidth (UINT32)
     *            + kPropVideoFrameHeight (UINT32)
     *            + kPropVideoColorFormat (UINT32) See ihxtconstants.h for full
     *              list of valid color formats.
     *            + any other properties by the filter found immediately
     *              before the preview sink's registered location.
     *          + if (kPropMediaFormat == kValueMediaFormatUncompAudio)
     *            + any properties by the filter found immediately
     *              before the preview sink's registered location.
     */

     STDMETHOD(GetOptimalSinkProperties) (THIS_
                                          IHXTPropertyBag** ppProps) PURE;

    /************************************************************************
     *	Method:
     *	    IHXTPreviewSinkControl::AddSink
     *	Purpose:
     *      Method used to register as a preview sink for samples. If this
     *      method return a success code, then as soon as encoding begins,
     *      caller will begin to receive media sample callsbacks (or if the
     *      sink is being added to input, samples will be received as soon
     *      as IHXTInputPreviewControl::Open() is called).
     *
     *
     *      If the types are invalid for either kPropPreviewSinkPosition
     *	    or kPropSinkUpdateInterval the type will be updated in an internal
     *	    cloned copy of the property bag.  Also, this function will
     *	    validate all input parameters are present and throw away properties
     *	    that are not valid for preview.  If a property is not present that
     *	    is necessary for preview, the missing property will be logged as an
     *	    error.
     *
     *	Parameters:
     *      pSink - pointer to the sink interface which is to be called when
     *              new samples are available.
     *      pProps - property bag specifying the properties of the format
     *               which the caller wishes to receive. Currently, setting
     *               properties here that differ from the SDK's internal
     *               format (which can be gotten via 
     *               'GetOptimalSinkProperties' method) will just be ignored
     *               However, eventually they will do any necessary color
     *               converts or resizing.
     *
     *          Here is the list of properties that can be set in the bag:
     *          + kPropMediaFormat (string) Currently only 
     *            kValueMediaFormatUncompVideo or kValueMediaFormatUncompAudio
     *            is supported.
     *          + kPropPreviewSinkPosition (UINT32) This is the position in
     *            the prefilter chain for which the caller wishes to insert
     *            a sink. Valid values are kValueBeforeAllPrefilters,
     *            kValueAfterAllPrefilters, or kValueAfterCodec.
     *          + kPropSinkUpdateInterval (INT32) This how often, in MS stream
     *            time, that the caller wishes to receive a sample. Valid 
     *            values are kValueFirstSample, kValueAllSamples, or an INT32
     *            specifying the time in MS between calls.
     *          + if (kPropMediaFormat == kValueMediaFormatUncompVideo)
     *            + kPropVideoFrameWidth (UINT32)
     *            + kPropVideoFrameHeight (UINT32)
     *            + kPropVideoColorFormat (UINT32) See ihxtconstants.h for full
     *              list of valid color formats.
     * 
     *              NOTE: currently kPropVideoFrameWidth, kPropVideoFrameHeight
     *                    and kPropVideoColorFormat are ignored by the SDK.
     *
     *            + any other properties set will be ignored
     *          + if (kPropMediaFormat == kValueMediaFormatUncompAudio)
     *            + any other properties set will be ignored
     *
     */
     STDMETHOD(AddSink) (THIS_
                         IHXTPreviewSink* pSink, IHXTPropertyBag* pProps) PURE;


    /************************************************************************
     *	Method:
     *	    IHXTPreviewSinkControl::RemoveSink
     *	Purpose:
     *       Method used to unregister preview sink so that samples will no
     *       longer be sent to the passed sink.
     *  Parameters:
     *      pSink - the pointer to the sink which the caller wishes to remove
     */
     STDMETHOD(RemoveSink) (THIS_
                            IHXTPreviewSink* pSink) PURE;
};


/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXTPreviewSinkControl3
 *
 *  Purpose:
 *
 *  This interface used to register preview sinks. It is currently
 *  implemented by the IHXTInput object
 *
 *  IID_IHXTPreviewSinkControl3:
 *
 *  {463A18A1-3D38-47d8-AE8C-92618FD39B58}
 *
 *
 */
// {463A18A1-3D38-47d8-AE8C-92618FD39B58}
DEFINE_GUID(IID_IHXTPreviewSinkControl3, 
0x463a18a1, 0x3d38, 0x47d8, 0xae, 0x8c, 0x92, 0x61, 0x8f, 0xd3, 0x9b, 0x58);

#undef  INTERFACE
#define INTERFACE   IHXTPreviewSinkControl3

DECLARE_INTERFACE_(IHXTPreviewSinkControl3, IHXTPreviewSinkControl)
{
     STDMETHOD(EnableSink)(THIS_ IHXTPreviewSink* pSink) PURE;
     STDMETHOD(DisableSink)(THIS_ IHXTPreviewSink* pSink) PURE;
};



/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXTInputPreviewControl
 *
 *  Purpose:
 *
 *  This interface used to start and stop preview of an input.
 *
 *  IID_IHXTInputPreviewControl:
 *
 *  {5851036C-C40D-4ff6-BB02-3EA73F291516}
 *
 *
 */
DEFINE_GUID(IID_IHXTInputPreviewControl, 
0x5851036c, 0xc40d, 0x4ff6, 0xbb, 0x2, 0x3e, 0xa7, 0x3f, 0x29, 0x15, 0x16);

#undef INTERFACE
#define INTERFACE	IHXTInputPreviewControl

DECLARE_INTERFACE_(IHXTInputPreviewControl, IUnknown)
{
    /***********************************************************************/
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)		(THIS_
					 REFIID riid,
					 void** ppvObj) PURE;

    STDMETHOD_(UINT32,AddRef)		(THIS) PURE;

    STDMETHOD_(UINT32,Release)		(THIS) PURE;


    /***********************************************************************/
    /*
     *	IHXTInputPreviewControl methods
     */
 	
    /************************************************************************
     *	Method:
     *	    IHXTInputPreviewControl::Open
     *	Purpose:
     *	    Builds the input graph for the purposes of preview and begins
	 *		passing samples to registered sinks.
     */
    STDMETHOD (Open) (THIS) PURE;

    /************************************************************************
     *	Method:
     *	    IHXTInputPreviewControl::Close
     *	Purpose:
     *	    Stops passing media samples to the all registered sinks and
     *      tears down the input graph
     */
     STDMETHOD (Close) (THIS) PURE;
};



#endif // _HXTPREVIEWSINK_H
