/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 

#ifndef _HXTINPUTFORMATHELPER_H
#define _HXTINPUTFORMATHELPER_H

#include "ihxtbase.h"
#include "ihxtpropertybag.h"

/****************************************************************************
 *
 *  IHXTInputFormatHelper	(see SPECIFICATION at the bottom of this file for more info)
 *
 *	This is a helper class available through SetFactory within a filter
 *  It is designed to consistently manage handling and display of input properties 
 *  for all input sources- file and capture based.
 *  
 *  By using it you will automatically handle properties in the manner specified 
 *  by the spec (see the sectoin from ihxtconstants.h below which defines the specification.
 *  Your track bags will have the required fields and will be properly reqistered \
 *  so that applications can easily obtain the input information in a consistent manner 
 *
 *  In summary IHXTInputFormatHelper
 *
 *  1) Manages creation of track info properties for video and audio
 *  2) Sets track bags on the ActualPropertyBag of the IHXTCnfigurationAgent 
 *  3) Optionally formats and logs properties
 *  
 *  To use this in an external filter see RSInPCMPlugin   ( set bShowLog = FALSE)
 * 
 *  To use within internal plugins see RSInAVI
 *
 *  NOTES:
 *	 The user is responsible for creating the track bag(s), handing off the actual
 *   property bag, passing in a viable IHXTTime pointer as well as setting the various
 *   fields as specified in the parameter list
 *  
 *   here are a few optional parameters used in the interface
 *  
 *   Some Parameter explanation:
 * 
 *   const char* pkInputPluginType =		one of the following input types from ihxtconstants.h
 *			kValuePluginTypeInputAVFile
 *			kValuePluginTypeInputCapture
 *			kValuePluginTypeInputMediaSink
 *			kValuePluginTypeInputCompressedMediaRM
 *
 *   pAgentBag - the bag returned from GetActualPropertyBag
 *   pkPluginName - kPropPluginName from the actual plugin
 *   pUnsupportedTrackBag - format info about a invalid track
 *   pDeviceName - (just for capture inputs) 
 *   pPortName - (just for capture inputs) 
 */

DECLARE_INTERFACE_( IHXTInputFormatHelper, IUnknown )
{
	STDMETHOD( BeginFormatInputInfo ) (  THIS_	const char* pkInputPluginType, 
												IHXTPropertyBag* pAgentBag, 
												const char* pkPluginName ) PURE;
	
	STDMETHOD( FormatVideoProperties ) ( THIS_	IHXTPropertyBag *pTrackBag,	/* in out */
												IHXTPropertyBag *pAgentBag,	/* in out */
												INT32 nTrackNum,
												UINT32 uWidth,
												UINT32 uHeight,
												float fFPS,
												const char *pszColorFormat,
												IHXTTime* pDuration,
												const char *pszDeviceName = NULL,
												const char *pszPortName = NULL) PURE;

	STDMETHOD( FormatAudioProperties ) ( THIS_	IHXTPropertyBag *pTrackBag,	/* in out */
												IHXTPropertyBag *pAgentBag,	/* in out */
												INT32 nTrackNum,
												UINT32 uChannelFormat,
												UINT32 uSampleFormat,
												UINT32 uSampleRate,
												IHXTTime* pDuration,
												const char *pszDeviceName = NULL,
												const char *pszPortName = NULL) PURE;

	STDMETHOD( FormatUnsupportedTrack ) ( THIS_	const char* pkStreamType,
												IHXTPropertyBag *pUnsupportedTrackBag,	/* in out */
												IHXTPropertyBag *pAgentBag,	/* in out */
												INT32 nTrackNum) PURE;
	
	STDMETHOD( EndFormatInputInfo)   ( THIS	) PURE;	

};

/* {DF964549-6EF1-40a0-AAB6-9B7E50AE4B8E} */
DEFINE_GUID(IID_IHXTInputFormatHelper, 0xdf964549, 0x6ef1, 0x40a0, 0xaa, 0xb6, 0x9b, 0x7e, 0x50, 0xae, 0x4b, 0x8e);

#endif // _HXTINPUTFORMATHELPER_H


/* SPECIFICATION: from the input av source SPEC 
------------------- Input File Properties from %s Reader
Input Filename: %s
File Size:		NN.N MB 
Total Duration: d:h:m:s.xyz 

Audio Track 		
   Device Name: %s (conditional, only set for device tracks) 
   Device Port: %s (conditional, only set for device tracks) 
   Channels:	N 
   Bit Depth:	NN 
   Sample Rate: NN kHz 
   Format:		%s 
   Duration:	d:h:m:s.xyz 

Video Track 
   Device Name: %s (conditional, only set for device tracks) 
   Device Port: %s (conditional, only set for device tracks) 
   Dimensions:	WxH 
   Frame Rate:	%s FPS 
   Format:		%s 
   Duration:	d:h:m:s.xyz
------------------- End Input File Properties

SAMPLE FROM AN AVI FILE

------------------- Input File Properties from Uncompressed AV Reader
Input Filename: c:\media\myfile.avi
File Size:      23.3 MB 
Total Duration: 3:24 

Audio Track
   Channels:	Stereo 
   Bit Depth:   16
   Sample Rate: 44100 kHz
   Format:      Uncompressed Audio
   Duration:    3:24

Video Track
   Dimensions:  352 x 240
   Frame Rate:  30.0 FPS 
   Format:      MPEG 4
   Duration:    3:24
------------------- End Input File Properties

SAMPLE FROM A CAPTURE DEVICE

------------------- End Input Capture Properties
Total Duration: 3:24 

Audio Track
   Device Name: Sound Blaster AWE 64
   Device Port: 1
   Channels:	2
   Bit Depth:   16
   Sample Rate: 44100 kHz
   Format:      Uncompressed Audio
   Duration:    3:24

Video Track
   Device Name: WinNov Video Capture
   Device Port: 2
   Dimensions:  352 x 240
   Frame Rate:  30.0 FPS 
   Format:      MPEG 4
   Duration:    3:24
------------------- End Input Capture Properties
*/


/*
 * ihxtconstants.h -- Requirements for track bag properties 

 Required Input File properties which must be set on the ConfigurationAgent's PropertyBag 
 
	 static const char kPropInputPathname[] =				"filename";					 string 
	 static const char kPropNumTracks[] =					"numTracks";				 UINT32 
	 static const char kPropFileSizeBytes[] =				"fileSizeBytes";			 INT64 
	 static const char kPropDuration[] =					"duration";					 IUnknown 

 a track bag will be created for each significant track in an input file or capture device
   each bag has a name which is independent of type:
		kPropTrackInfo[0..n] :  
   to create the property name for the track bag append a number to the string constant:
	 kPropTrackInfo

  the specific requirements for different track types are listed below
   once the track bag is filled in with the default properties it must be 
   set on the configuration agent's property bag using the SetPropertyBag function
.
  
1) Each track bag must set this property with one of the following values below 
    static const char kPropTrackInfoType[] =				"trackType";				 string 

 types to date -- choose one per track info bag 
	static const char kValueAudioStreamType[] =				"audio";					 string 
	static const char kValueVideoStreamType[] =				"video";					 string 
	static const char kValueTrackTypeEvents[] =				"rmEvents";					 string 
	static const char kValueTrackTypeImage[] =				"image";					 string 
	static const char kValueTrackTypeImageMap[] =			"imageMap";					 string 
	static const char kValueTrackTypeText[] =				"text";						 string 

2) each track bag must also use the kPropDuration field defined above 

3) In addition, Audio track bags must implement the following  
	static const char kPropTrackAudioNumChannels[] =		"audioChannels";			 UINT32 
	static const char kPropTrackAudioBitDepth[] =			"audioBitDepth";			 UINT32 
	static const char kPropTrackAudioSampleRate[] =			"audioSampleRate";			 UINT32 

4) also Audio track bags must also set kPropTrackAudioFormat with one of the following values 
	static const char kPropTrackAudioFormat[] =				"audioFormat";				 string 

   optional values for above field 
	static const char kValueAudioFormatPCM[] =				"pcm";						 string 
	static const char kValueAudioFormatMP3[] =				"mp3";						 string 

5) Video tracks must implement the following properties 
	static const char kPropTrackVideoColorFormat[] =		"videoColorFormat";			 string 
	static const char kPropTrackVideoWidth[] =				"videoWidth";				 UINT32 
	static const char kPropTrackVideoHeight[] =				"videoHeight";				 UINT32 
	static const char kPropTrackVideoFrameRate[] =			"videoFrameRate";			 double 

6) dont forget -- video tracks bags must also set the kPropDuration property

7)  for either the kPropTrackAudioFormat or the kPropTrackVideoColorFormat properties
	the track bag must implement the kValueFormatUnknown if the format is unsupported 
		static const char kValueFormatUnknown[] =				"unknown";					 string 

8) Input Capture devices only must set these additional properties on video and audio track bags 
	static const char kPropTrackDeviceName[] =				"deviceName";				 string 
	static const char kPropTrackDevicePort[] =				"devicePort";				 string 

9) Optional Capture device property 
	static const char kPropTrackDeviceDescription[] =		"deviceDescription";		 string 

End of track bag requirements 
*/





