/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 


#ifndef _IRTAFILEOBSERVER_H
#define _IRTAFILEOBSERVER_H

enum enumLogFormat{
		Detailed,
		Short
};

enum enumRollType{
		Monthly,
		Daily,
		Weekly,
		Hourly
};

// {478D6411-A712-11d5-9374-00D0B749DE42}
DEFINE_GUID(IID_IHXTFileObserver, 
0x478d6411, 0xa712, 0x11d5, 0x93, 0x74, 0x0, 0xd0, 0xb7, 0x49, 0xde, 0x42);

// {3E1AE821-A7B9-11d5-9374-00D0B749DE42}
DEFINE_GUID(CLSID_HXTFileObserver, 
0x3e1ae821, 0xa7b9, 0x11d5, 0x93, 0x74, 0x0, 0xd0, 0xb7, 0x49, 0xde, 0x42);

#undef  INTERFACE
#define INTERFACE   IHXTFileObserver

 /****************************************************************************
 *
 *  Interface:
 *
 *  IHXTFileObserver
 *
 *  Purpose:
 *
 *  Interface for the file observer to the log system, which will write received
 *	log messages to the specified file.
 *
 *	IID_IHXTFileObserver:
 *
 *  // {938F4A21-1327-11d5-9349-00D0B749DE42}
 *
 */

DECLARE_INTERFACE_(IHXTFileObserver, IUnknown)
{
	/*
	 *	IUnknown methods
	 */
	STDMETHOD(QueryInterface)		(THIS_
				REFIID riid,
				void** ppvObj) PURE;

	STDMETHOD_(ULONG32,AddRef)		(THIS) PURE;

	STDMETHOD_(ULONG32,Release)		(THIS) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::Init
	 *	Purpose:
	 *	    Initialize the file observer.
	 *	Parameters:
	 *	    szFilename - [in] Name of the file to write log messages to.
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Could not properly connect to the log system.
	 */
	STDMETHOD(Init)(THIS_ 
		const char*			/*IN*/		szFilename) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::Enable
	 *	Purpose:
	 *	    Enables and disables the observer from writing to the file.
	 *	Parameters:
	 *	    bEnable - [in] Enable/Disable(TRUE/FALSE).
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - State change unsuccessful.
	 */
	STDMETHOD(Enable)(THIS_ 
		BOOL			/*IN*/		bEnable) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::SetCategoryFilter
	 *	Purpose:
	 *	    Tells the log system to only send log messages with log codes which
	 *			pass the bitmask parameter.
	 *	Parameters:
	 *	    nCategoryFilter - [in] Bitmask for the accepted log codes.
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Unable to set category filter.
	 */
	STDMETHOD(SetCategoryFilter)(THIS_ 
		UINT32 			/*IN*/		nCategoryFilter) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::SetFuncAreaFilter
	 *	Purpose:
	 *	    Tells the log system to only send log messages with functional areas 
	 *			listed in the parameter string.
	 *	Parameters:
	 *	    szFuncAreaList - [in] List of accepted functional areas.  Format is:
	 *			"Namespace:FunctionalArea, ..."
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Unable to set functional area filter.
	 */
	STDMETHOD(SetFuncAreaFilter)(THIS_ 
		const char*			/*IN*/		szFuncAreaList) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::SetLanguage
	 *	Purpose:
	 *	    Tells the log system what language to use when translating numeric 
	 *			messages.  **Currently Ignored**
	 *	Parameters:
	 *	    szLanguage - [in] Desired translation language.
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Unable to set language.
	 */
	STDMETHOD(SetLanguage)(THIS_ 
		const char*			/*IN*/		szLanguage) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::SetFormat
	 *	Purpose:
	 *	    Sets that format of how log messages are written to file.
	 *	Parameters:
	 *	    format - [in] The desired format: Short or Detailed.
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Unable to set format.
	 */
	STDMETHOD(SetFormat)(THIS_ 
		enumLogFormat 			/*IN*/		format) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::SetSeparator
	 *	Purpose:
	 *	    Sets that seperator used to separate log message elements per log message.
	 *	Parameters:
	 *	    cSep - [in] The separator character.
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Unable to set separator character.
	 */
	STDMETHOD(SetSeparator)(THIS_ 
		char			/*IN*/		cSep) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::SetSizeRoll
	 *	Purpose:
	 *	    Tells the observer to roll the file it writes to after the specified 
	 *			size is met.
	 *	Parameters:
	 *	    nNumMB - [in] The number of megabytes the file must reach in order 
	 *			to be rolled.
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Unable to set roll value.
	 */
	STDMETHOD(SetSizeRoll)(THIS_ 
		UINT32			/*IN*/		nNumMB) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::SetTimeRoll
	 *	Purpose:
	 *	    Tells the observer to roll the file at specific time intervals.
	 *	Parameters:
	 *	    enumRollType - [in] Period over which the file is rolled.
	 *	    nTime - [in] Ignored.
	 *	    nInterval - [in] Ignored.
	 *	    nTimeZone - [in] Ignored.
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Unable to set roll value.
	 */
	STDMETHOD(SetTimeRoll)(THIS_ 
		enumRollType			/*IN*/		rolltype, 
		UINT32						/*IN*/		nTime, 
		UINT32						/*IN*/		nInterval, 
		INT32							/*IN*/		nTimeZone) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::SetFilename
	 *	Purpose:
	 *	    Sets the filename the observer should write to.
	 *	Parameters:
	 *	    szFilename - [in] Name of the file to be written to.
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Unable to set file.
	 */
	STDMETHOD(SetFilename)(THIS_ 
		const char*			/*IN*/			szFilename) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::SetPreviousFilename
	 *	Purpose:
	 *	    Sets the previous filename value (used in some rolling calculations).
	 *	Parameters:
	 *	    szFilename - [in] Name of the previous file written to.
	 *	Returns:
	 *	    HXR_OK - If success.
	 *	    HXR_FAIL - Unable to set file.
	 */
	STDMETHOD(SetPreviousFilename)(THIS_ 
		const char*			/*IN*/			szFilename) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::GetFilename
	 *	Purpose:
	 *	    Gets the name of the file currently being written to.
	 *	Parameters:
	 *	    NONE.
	 *	Returns:
	 *	    Pointer to the name of the current file.
	 */
	STDMETHOD_(const char*, GetFilename)() PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::GetPreviousFilename
	 *	Purpose:
	 *	    Gets the string being used as the previous file name.
	 *	Parameters:
	 *	    NONE.
	 *	Returns:
	 *	    Pointer to the name of the previous file.
	 */
	STDMETHOD_(const char*, GetPreviousFilename)() PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::Shutdown
	 *	Purpose:
	 *	    Shuts down (unsubscribes and closes out the file) the observer.
	 *	Parameters:
	 *	    NONE
	 *	Returns:
	 *	    HXR_OK - Shutdown succeeded.
	 *	    HXR_FAIL - Shutdown failed.
	 */
	STDMETHOD(Shutdown)( THIS ) PURE;

	/************************************************************************
	 *	Method:
	 *	    IHXTFileObserver::EnableSDKMessages
	 *	Purpose:
	 *	    Tells the observer to accept or reject messages marked as SDK.
	 *	Parameters:
	 *	    bEnable - [in] Enable SDK message reception.
	 *	Returns:
	 *	    NONE
	 */
	STDMETHOD_(void, EnableSDKMessages)(BOOL bEnable) PURE;
};


/****************************************************************************
 *  Function:
 *	CreateFileObserver
 *  Purpose:
 *	Creates a file observer object and return the IHXTFileObserver interface
 *	from the create object on success.
 */
typedef HX_RESULT (STDAPICALLTYPE *FPCREATEFILEOBSERVER)(IHXTFileObserver** ppIFileObserver);


#endif 
