/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _RMAFDUMP_H_
#define _RMAFDUMP_H_

// Prototype to create instance of RMFFDump object and 
// typedef to get a pointer to this function from the dll
typedef HX_RESULT (HXEXPORT_PTR FPCREATEINSTANCE) (IUnknown** /*OUT*/ ppIUnknown);
STDAPI RMACreateRMFFDump(IUnknown**  /*OUT*/	ppIUnknown);


/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXRMDump
 *
 *  Purpose:
 *
 *	Interface to rmff copy module
 *
 *  IHXRMDump
 *
 *  {59514C50-3129-11d2-A1C4-0060083BE563}
 *
 */

DEFINE_GUID(IID_IHXRMFFDump, 
0x59514c50, 0x3129, 0x11d2, 0xa1, 0xc4, 0x0, 0x60, 0x8, 0x3b, 0xe5, 0x63);




#define CLSID_IHXRMFFDump IID_IHXRMFFDump


#undef  INTERFACE
#define INTERFACE   IHXRMDump

DECLARE_INTERFACE_(IHXRMDump, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)	(THIS) PURE;

    STDMETHOD_(ULONG32,Release)	(THIS) PURE;

    // *** IHXRMDump methods ***
 
	// ***	Basic Interface ***
 
	// sets the specified .rm file as the input file
	STDMETHOD(SetInputFile) (THIS_
				const char* szFileName) PURE;  

	// sets the specified .txt file as the output file
	STDMETHOD(SetOutputFile) (THIS_
				const char* szFileName) PURE;  

	// sets the start time for the dump in milliseconds
	STDMETHOD(SetStartTime) (THIS_
				UINT32 ulStartTime) PURE;  

	// sets the end time for the dump in milliseconds. Use 0 to indicate EOF
	STDMETHOD(SetEndTime) (THIS_
				UINT32 ulEndTime) PURE;  

	// process the dump
	STDMETHOD(Process) (THIS) PURE;  
};


#endif //_RMAFDUMP_H_
