/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */
#ifndef _RMAEVNTS_H_
#define _RMAEVNTS_H_

struct IHXProgressSink;


// Prototype to create instance of RMEvents object and 
// typedef to get a pointer to this function from the dll
typedef HX_RESULT (HXEXPORT_PTR FPCREATEINSTANCE) (IUnknown** /*OUT*/ ppIUnknown);
STDAPI RMACreateRMEvents(IUnknown**  /*OUT*/	ppIUnknown);

/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXRMEvents
 *
 *  Purpose:
 *
 *	Interface to rmevents module
 *
 *  IHXRMEvents
 *
 *  {3EE719E0-5307-11d2-A1D1-0060083BE563}
 *
 */

DEFINE_GUID(IID_IHXRMEvents, 
0x3ee719e0, 0x5307, 0x11d2, 0xa1, 0xd1, 0x0, 0x60, 0x8, 0x3b, 0xe5, 0x63);

#define CLSID_IHXRMEvents IID_IHXRMEvents

#undef  INTERFACE
#define INTERFACE   IHXRMEvents

DECLARE_INTERFACE_(IHXRMEvents, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)	(THIS) PURE;

    STDMETHOD_(ULONG32,Release)	(THIS) PURE;

    // *** IHXRMEvents methods ***
 
    /************************************************************************
     *	Method:
     *	    IHXRMEdit::GetErrorString
     *	Purpose:
     *	    returns the error string associated with the specified HX_RESULT
     *
     *	Parameters:
     *	    res - [in] the HX_RESULT you want an error string for
     *		szErrString - [out] a preallocated buffer to hold the error string
     *		unMaxSize - the size of the szErrString buffer
     */
	STDMETHOD(GetErrorString) (THIS_
				HX_RESULT res, char* szErrString, UINT16 unMaxSize) PURE;                   

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetInputFile
     *	Purpose:
     *	    specifies the file name of the input .rm file. 
     *
     *	Parameters:
     *		szFileName - [in] the path to the input file.
	 */	
	STDMETHOD(SetInputFile) (THIS_
				const char* szFileName) PURE;  

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetOutputFile
     *	Purpose:
     *	    specifies the file name of the output file. This .rm file will contain the results
	 *		of the merge operation.
     *
     *	Parameters:
     *		szFileName - [in] the path to the output .rm file. If the file already exists, it 
	 *		will be replaced. If the file does not exist it will be created.
	 */	
	STDMETHOD(SetOutputFile) (THIS_
				const char* szFileName) PURE; 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetEventFile
     *	Purpose:
     *	    specifies the file name of the event text file. 
     *
     *	Parameters:
     *		szFileName - [in] the path to the event text file. 
	 */	
	STDMETHOD(SetEventFile) (THIS_
				const char* szFileName) PURE; 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetImageMapFile
     *	Purpose:
     *	    specifies the file name of the image map text file. 
     *
     *	Parameters:
     *		szFileName - [in] the path to the image map text file. 
	 */	
	STDMETHOD(SetImageMapFile) (THIS_
				const char* szFileName) PURE; 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::SetDumpFile
     *	Purpose:
     *	    specifies the root file name of the Dump file. 
     *		All events in the input file will be dumped into szFileName_evt.txt
     *		All image maps in the input file will be dumped into szFileName_imap.txt
     *
     *	Parameters:
     *		szFileName - [in] the path to dump file root. 
	 */	
	STDMETHOD(SetDumpFile) (THIS_
				const char* szFileName) PURE; 

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetInputFile
     *	Purpose:
     *	     returns the file name of the input file
     *
     *	Parameters:
 	 *		szFileName - [out] the path to the input file. This buffer must be preallocated.
     *		ulMaxBufSize - [in] the size of the buffer szFileName. 
     */
	STDMETHOD(GetInputFile) (THIS_
				char* szFileName, UINT32 ulMaxBufSize) PURE;        

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetOutputFile
     *	Purpose:
     *	     returns the file name of the output file
     *
     *	Parameters:
 	 *		szFileName - [out] the path to the output file. This buffer must be preallocated.
     *		ulMaxBufSize - [in] the size of the buffer szFileName. 
     */
	STDMETHOD(GetOutputFile) (THIS_
				char* szFileName, UINT32 ulMaxBufSize) PURE;        

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetEventFile
     *	Purpose:
     *	     returns the file name of the event text file
     *
     *	Parameters:
 	 *		szFileName - [out] the path to the event text file. This buffer must be preallocated.
     *		ulMaxBufSize - [in] the size of the buffer szFileName. 
     */
	STDMETHOD(GetEventFile) (THIS_
				char* szFileName, UINT32 ulMaxBufSize) PURE;        

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetImageMapFile
     *	Purpose:
     *	     returns the file name of the image map text file
     *
     *	Parameters:
 	 *		szFileName - [out] the path to the image map text file. This buffer must be preallocated.
     *		ulMaxBufSize - [in] the size of the buffer szFileName. 
     */
	STDMETHOD(GetImageMapFile) (THIS_
				char* szFileName, UINT32 ulMaxBufSize) PURE;        

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::GetDumpFile
     *	Purpose:
     *	     returns the name of the dump file root name
     *
     *	Parameters:
 	 *		szFileName - [out] the path to the dump file root name. This buffer must be preallocated.
     *		ulMaxBufSize - [in] the size of the buffer szFileName. 
     */
	STDMETHOD(GetDumpFile) (THIS_
				char* szFileName, UINT32 ulMaxBufSize) PURE;        

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::OpenLogFile
     *	Purpose:
     *		opens the specified file for logging. All status and error messages will be
	 *		logged to this file.
	 *
     *	Parameters:
 	 *		pFileName - [in] the path to the log file.
	 */	
	STDMETHOD(OpenLogFile)	(THIS_
				const char* pFileName) PURE;

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::CloseLogFile
     *	Purpose:
     *		closes the log file
	 *
     *	Parameters:
 	 *		None
	 */	
	STDMETHOD(CloseLogFile)	(THIS) PURE;

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::Log
     *	Purpose:
     *		logs the string to the log file
	 *
     *	Parameters:
 	 *		pLogString - [in] the string to be logged to the log file.
	 */	
	STDMETHOD(Log)	(THIS_ const char* pLogString) PURE;

	/************************************************************************
     *	Method:
     *	    IHXRMEdit::Process
     *	Purpose:
     *		merges the events and image maps with the input file. Create and writes the output file
	 *
     *	Parameters:
 	 *		None
	 */	
	STDMETHOD(Process) (THIS) PURE; 

};

/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXRMEvents2
 *
 *  Purpose:
 *
 *	Interface to rmevents module
 *
 *  {2AF82001-ADC6-11d3-8660-42525E000000}
 *
 */

DEFINE_GUID(IID_IHXRMEvents2, 
0x2af82001, 0xadc6, 0x11d3, 0x86, 0x60, 0x42, 0x52, 0x5e, 0x0, 0x0, 0x0);

#define CLSID_IHXRMEvents2 IID_IHXRMEvents2

#undef  INTERFACE
#define INTERFACE   IHXRMEvents2

DECLARE_INTERFACE_(IHXRMEvents2, IHXRMEvents)
{
	/************************************************************************
     *	Method:
     *	    IHXRMEvents2::AddSaveProgressSink
     *	Purpose:
     *		Add sink which receives callbacks with save progress
	 */	
    STDMETHOD(AddSaveProgressSink)(IHXProgressSink* pProgressSink) PURE;
    
	/************************************************************************
     *	Method:
     *	    IHXRMEvents2::RemoveSaveProgressSink
     *	Purpose:
     *		Remove progress-during-save sink
	 */	
    STDMETHOD(RemoveSaveProgressSink)(IHXProgressSink* pProgressSink) PURE;
};

#endif 
//_RMAEVNTS_H_
