/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */ 



#ifndef _HXTENCODINGJOB_H
#define _HXTENCODINGJOB_H

#include "ihxtbase.h"


_INTERFACE IHXTClassFactory;
_INTERFACE IHXTEncodingJob;
_INTERFACE IHXTInput;
_INTERFACE IHXTPrefilter;
_INTERFACE IHXTPostfilter;
_INTERFACE IHXTMediaProfile;
_INTERFACE IHXTDestination;
_INTERFACE IHXTOutputProfile;
_INTERFACE IHXTOutputProfile2;
_INTERFACE IHXTAudience;
_INTERFACE IHXTStreamConfig;
_INTERFACE IHXTStreamConfig2;
_INTERFACE IHXTPacketizer;
_INTERFACE IHXTAudienceEnumerator;
_INTERFACE IHXTSerializeBuffer;
_INTERFACE IHXTUserConfigFile;
_INTERFACE IHXCommonClassFactory;
_INTERFACE IHXBuffer;
_INTERFACE IHXTStreamControl;
_INTERFACE IHXTInputStream;
_INTERFACE IHXTCodecUpdater;
_INTERFACE IHXSourceHandler;



/****************************************************************************
 *
 *  Function:
 *
 *  SetDLLAccessPath
 *
 *  Purpose:
 *
 *  Module entry point used to specify DLL locations
 *
 */

STDAPI  SetDLLAccessPath(const char* pPathDescriptor);
typedef HX_RESULT (HXEXPORT_PTR FPRMBUILDSETDLLACCESSPATH) (const char*);


/****************************************************************************
 *
 *  Function:
 *
 *  HXTCreateJobFactory
 *
 *  Purpose:
 *
 *  Module entry point used to create IHXTClassFactory
 *
 */
 
STDAPI HXTCreateJobFactory( IHXTClassFactory** ppJobClassFactory );
typedef HX_RESULT (HXEXPORT_PTR FPCREATEJOBFACTORY) ( IHXTClassFactory** ppJobClassFactory );


/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTClassFactory
 *
 *  {F2EFF616-85A4-4e01-B5CF-B73001196C21}
 *
 *  Purpose:
 *
 *  Used to instantiate encoding sdk objects (IHXTEncodingJob, IHXTInput, IHXTAudience, IHXTPropertyBag, etc.). Note
 *  that all interfaces instantiated by the class factory must be released by the time the last IHXTClassFactory
 *  refcount is released (because the class factory will hold certain DLLs in memory, which may contain the 
 *  code pages for some interfaces instantiated by the factory).
 *
 *
 *	Methods:
 *
 *	CreateInstance - Creates an object specified by riid.  Does not perform any sort of initialization.
 *	BuildInstance - Creates and initializes an object.
 *	BuildInstanceFromBuffer - Creates and initializes an object from a buffer containing a chunk of XML.
 *	BuildInstanceFromFile - Creates and initializes an object from a file containing a chunk of XML.
 *	BuildInstanceFromObject - Clones an existing object and optionally replaces params in ppReplaceProps.
 *
 */

DEFINE_GUID(IID_IHXTClassFactory,
0xf2eff616, 0x85a4, 0x4e01, 0xb5, 0xcf, 0xb7, 0x30, 0x1, 0x19, 0x6c, 0x21);

#undef  INTERFACE
#define INTERFACE   IHXTClassFactory


DECLARE_INTERFACE_(IHXTClassFactory, IUnknown)
{   
    STDMETHOD(CreateInstance) (THIS_ REFIID riid, IUnknown** ppNewInstance) PURE; 
    STDMETHOD(BuildInstance) (THIS_ REFIID riid, IHXTPropertyBag* pInitParams, IUnknown** ppNewInstance, BOOL bForceInitialization=FALSE, IHXTPropertyBag** ppInitErrorBag=NULL) PURE;
	STDMETHOD(BuildInstanceFromBuffer) (THIS_ REFIID riid, IHXBuffer* pXmlBuffer, IUnknown** ppNewInstance, BOOL bForceInitialization=FALSE, IHXTPropertyBag** ppInitErrorBag=NULL) PURE;
    STDMETHOD(BuildInstanceFromFile) (THIS_ REFIID riid, const char* szPathname, IUnknown** ppNewInstance, BOOL bForceInitialization=FALSE, IHXTPropertyBag** ppInitErrorBag=NULL) PURE;
    STDMETHOD(BuildInstanceFromObject) (THIS_ REFIID riid, IUnknown* pUnkExistingObj, IUnknown** ppUnkNewInstance, IHXTPropertyBag** ppReplaceProps=NULL, BOOL bForceInitialization=FALSE, IHXTPropertyBag** ppInitErrorBag=NULL) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTEncodingJob
 *
 *  {06ADF590-64C6-48fc-A5FB-DA1AB6FB45F4}
 *
 *  Purpose:
 *
 *  Used to configure an encoding job's configuration properties (see IHXTConfigurationAgent
 *	in ihxtbase.h) and start, stop, or cancel encodes.
 *
 *
 *  Threading model:
 *
 *	In general, the SDK interfaces/methods are not thread-safe.  The caller is responsible 
 *	for serializing all calls into the SDK.  For example, one thread may not use an IHXTEncodingJob 
 *	object while another thread simultaneously calls into that same encoding job object, or another
 *	object associated with the encoding job (such as a media profile, or a destination, etc.).  
 *
 *	The follow methods are thread-safe and may be called simultaneously:
 *		IHXTEncodingJob::StartEncoding, StopEncoding, and CancelEncoding.  For example, it is
 *		possible to call the blocking version of StartEncoding, and call StopEncoding with a
 *		different thread.
 *
 *	It is fine to use multiple threads to make calls into objects that are not associated with each 
 *	other.  For example, if there are two encoding jobs, two different threads may be used to simultaneously 
 *	call into the SDK (one thread per encoding job).
 *
 *	Any callback interface (events, logging, preview, etc.) may call back on separate threads.  For
 *	example, all events for a job may call back to the event sink using one thread while
 *	all log messages for a job may call back using a different thread.  One important consequence of this 
 *	is that if an sdk user's callback handler code ends up calling SDK interfaces/methods, those 
 *	calls must be serialized with all other calls into the SDK.
 *
 *	Calls to callback interfaces will be serialized for a particular job, e.g. an event sink will
 *	never receive more than one event callback from a particular job at a time.  Of course, if a callback
 *	interface is registered for callbacks spanning multiple jobs, it is possible to receive simultaneous callbacks.
 *	SDK users may not release their last refcount on a job in their event handlers.  Doing so will cause the 
 *	job to shutdown and wait for the event thread to exit, which will cause a deadlock.
 *
 *	Blocking a callback thread while waiting for a SDK method to complete may result in 
 *	a deadlock situation.  For example, calls to StopEncoding/CancelEncoding will not return
 *	until the event queue has been flushed.  If the event callback thread is blocked by application code
 *	that is waiting for StopEncoding/CancelEncoding to complete, neither thread will be able to execute
 *	any additional code.
 *
 *	SDK users should stop running jobs prior to releasing their last refcount on the job.  If
 *	a job is running when its last refcount is released, the job will be canceled.
 *	
 *
 *	Methods:
 *  
 *	StartEncoding - Starts encoding.  
 *		If bBlockUntilComplete is TRUE, the call will block until encoding completes.  A SUCCESS 
 *			return code indicates that one or more destinations completed successfully.  A FAIL 
 *			return code indicates that no destinations completed successfully.
 *		If bBlockUntilComplete is FALSE, the call will return once encoding has started.  The return
 *			code indicates whether encoding successfully started or not.
 *	StopEncoding - Stops encode.  Output files will be written with whatever data has already been 
 *		encoded.  Blocks until encoding has stopped.  Note that stopping an encode during the first pass 
 *		of a two-pass encode has the same effect as cancelling the encode since no data has been encoded.
 *	CancelEncoding - Cancels encoding.  Output files will not be created.  Blocks until 
 *		encoding has been canceled.
 *	
 *	GetInput - Gets the current input source
 *	SetInput - Sets the input source
 *	
 * 	AddOutputProfile - Adds an output profile to the back of the output profile list.  Currently, only
 *		a single OutputProfile is supported per EncodingJob.
 *	GetOutputProfile - Retrieves the output profile at ulIndex
 *	RemoveOutputProfile - Removes the output profile at ulIndex
 *	MoveOutputProfile - Moves an output profile from ulOrigIndex to ulDestIndex
 *	GetOutputProfileCount - Returns the number of output profiles in the list
 *
 *	GetMetadata - Gets the current metadata property bag
 *	SetMetadata - Sets the metadata property bag.  Only string and uint properties are currently suppported.
 *
 *	GetEventManager - Gets the event subsystem manager.  Used to subscribe and unsubscribe for events.
 *
 *
 *	Properties (see ihxtconstants.h for further details):
 *
 *	kPropObjectName - Descriptive name of object instance
 *	kPropEnableTwoPass - Enables two-pass encoding
 */

DEFINE_GUID(IID_IHXTEncodingJob,
0x6adf590, 0x64c6, 0x48fc, 0xa5, 0xfb, 0xda, 0x1a, 0xb6, 0xfb, 0x45, 0xf4);

#undef  INTERFACE
#define INTERFACE   IHXTEncodingJob

DECLARE_INTERFACE_(IHXTEncodingJob, IHXTConfigurationAgent)
{
    STDMETHOD(StartEncoding) (THIS_ BOOL bBlockUntilComplete=TRUE) PURE;
    STDMETHOD(StopEncoding) (THIS) PURE;
    STDMETHOD(CancelEncoding) (THIS) PURE;

    STDMETHOD(GetInput) (THIS_ IHXTInput** ppInput) PURE;
    STDMETHOD(SetInput) (THIS_ IHXTInput* pInput) PURE;

    STDMETHOD(AddOutputProfile) (THIS_ IHXTOutputProfile* pOutputProfile) PURE;
    STDMETHOD(GetOutputProfile) (THIS_ UINT32 ulIndex, IHXTOutputProfile** ppOutputProfile) PURE;
    STDMETHOD(RemoveOutputProfile) (THIS_ UINT32 ulIndex) PURE;
    STDMETHOD(MoveOutputProfile)(UINT32 ulOrigIndex, UINT32 ulDestIndex) PURE;
    STDMETHOD_(UINT32, GetOutputProfileCount) (THIS) PURE;

    STDMETHOD(GetMetadata) (THIS_ IHXTPropertyBag** ppMetadata) PURE;
    STDMETHOD(SetMetadata) (THIS_ IHXTPropertyBag* pMetadata) PURE;

	STDMETHOD(GetEventManager)(THIS_ IHXTEventManager **ppEventManager) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTInput
 *
 *  {8EF8B674-85AA-428a-BDAD-125529E74702}
 *
 *  Purpose:
 *
 *  Used to configure an input source's configuration properties (see 
 *	IHXTConfigurationAgent in ihxtbase.h) and manipulate a list of prefilters 
 *	associated with the input.
 *
 *
 *	Methods:
 *
 *	AddPrefilter - Adds a prefilter to the back of the prefilter list
 *	GetPrefilter - Retrieves the prefilter at ulIndex
 *	RemovePrefilter - Removes the prefilter at ulIndex
 *	MovePrefilter - Moves a prefilter from ulOrigIndex to ulDestIndex.  Note that
 *	  during the encode, a/v samples will propagate through prefilters based on their 
 *	  list ordering (from lowest index number to highest).
 *	GetPrefilterCount - Returns the number of prefilters in the list
 *
 *
 *	Properties (see ihxtconstants.h for further details):
 *
 *	All Inputs
 *		kPropObjectName - Descriptive name of object instance
 *		kPropHasAudio - Determines if input contains audio (read-only)
 *		kPropHasVideo - Determines if input contains video (read-only)
 *		kPropInputWidth - If the input contains video, determines input video width (read-only)
 *		kPropInputHeight - If the input contains video, determines input video height (read-only)
 *
 *	AV Readers
 *		kPropPluginType - kValuePluginTypeInputAVFile (required, initialization-only)
 *		kPropPluginName - Name of plugin to load.  Not setting this property allows
 *			the sdk to pick the optimal plugin based on kPropInputPathname. (initialization-only)
 *		kPropInputPathname - Pathname of source file (required, initialization-only)
 *		kPropDuration - Duration of source file (read-only)
 *		kPropNumTracks - Number of tracks available in the source file (read-only)
 *		kPropTrackInfo[0..n] - Bag containing track-based metadata (read-only)
 *		
 *	Capture
 *		kPropPluginType - kValuePluginTypeInputCapture (required, initialization-only)
 *		kPropPluginName - Name of plugin to load.  Not setting this property allows
 *			the sdk to pick the optimal plugin. (initialization-only)
 *		kPropDuration - Length of time to capture a/v
 *		kPropAudioDeviceID - Name of audio device (i.e., which sound card) to capture from
 *		kPropAudioDevicePort - Name of audio port (e.g., mic, line in, etc.) to capture from
 *		kPropAudioMixerID - Name audio mixer device.  
 *		kPropAudioMixerPort - Name of audio mixer port.
 *		kPropVideoDeviceID - Name of video device (i.e., which vcap card) to capture from
 *		kPropVideoDevicePort - Name of video port (e.g., compostive, svideo, etc.) to capture from
 *		kPropVideoFrameWidth - Video frame width to capture
 *		kPropVideoFrameHeight - Video frame height to capture
 *		kPropCaptureDialogControl - IHXTCaptureDialogControl interface pointer used to display custom capture dialogs
 *		
 */

DEFINE_GUID(IID_IHXTInput,
0x8ef8b674, 0x85aa, 0x428a, 0xbd, 0xad, 0x12, 0x55, 0x29, 0xe7, 0x47, 0x2);

#undef  INTERFACE
#define INTERFACE   IHXTInput

DECLARE_INTERFACE_(IHXTInput, IHXTConfigurationAgent)
{
    STDMETHOD(AddPrefilter) (THIS_ IHXTPrefilter* pPrefilter) PURE;
    STDMETHOD(GetPrefilter) (THIS_ UINT32 ulIndex, IHXTPrefilter** ppPrefilter) PURE;
    STDMETHOD(RemovePrefilter) (THIS_ UINT32 ulIndex) PURE;
    STDMETHOD(MovePrefilter)(UINT32 ulOrigIndex, UINT32 ulDestIndex) PURE;
    STDMETHOD_(UINT32, GetPrefilterCount) (THIS) PURE;
};


/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTInput2
 *
 *  Purpose:
 *	This interface is used for par and seq inputs to group inputs
 *	into these container types.
 *
 *  For ParInput Properties supports:
 *	kPropHasAudio,kPropHasVideo,kPropHasEvents,kPropHasImageMaps
 *	kPropIsRealTime
 *	kPropDisableAudio, kPropDisableVideo, kPropDisableEvents, kPropDisableImageMaps
 *	kPropIsRepeatable
 *	Supports kPropDuration as the max of all input durations
 *
 *  {B3079291-D20B-42d6-9351-CC7B3A277543}
 *
 */
// {B3079291-D20B-42d6-9351-CC7B3A277543}
DEFINE_GUID(IID_IHXTInput2, 
0xb3079291, 0xd20b, 0x42d6, 0x93, 0x51, 0xcc, 0x7b, 0x3a, 0x27, 0x75, 0x43);

#undef  INTERFACE
#define INTERFACE   IHXTInput2

DECLARE_INTERFACE_(IHXTInput2, IHXTInput)
{
    // IHXTInput2 methods
    STDMETHOD(AddInput) (THIS_ IHXTInput* pSource) PURE;
    STDMETHOD(RemoveInput) (THIS_ UINT32 ulIndex) PURE;
    STDMETHOD_(UINT32, GetInputCount) (THIS) PURE;
    STDMETHOD(GetInput)(THIS_ UINT32 ulIndex, IHXTInput** ppSource) PURE;
    STDMETHOD(MoveInput)(UINT32 ulOrigIndex, UINT32 ulDestIndex) PURE;
};




/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTPrefilter
 *
 *  {2717FED5-B783-41f9-BC57-79D63EEAA1F1}
 *
 *  Purpose:
 *
 *  Used to configure a prefilter's configuration properties (see IHXTConfigurationAgent
 *	in ihxtbase.h).
 *
 *
 *	Properties (see ihxtconstants.h for further details):
 *
 *	All Prefilters
 *		kPropIsEnabled - Enables or disables the prefilter
 *		kPropObjectName - Descriptive name of object instance
 *
 *	Video cropping
 *		kPropPluginType - kValuePluginTypePrefilterCropping (required, initialization-only)
 *		kPropPluginName - kValuePluginNamePrefilterCropping (initialization-only)
 *		kPropCropLeft - Leftmost value of crop region
 *		kPropCropTop - Top value of crop region
 *		kPropCropWidth - Width of crop region
 *		kPropCropHeight - Height of crop region
 *
 *	Video black level filter
 *		kPropPluginType - kValuePluginTypePrefilterBlackLevel (required, initialization-only)
 *		kPropPluginName - kValuePluginNamePrefilterBlackLevel (initialization-only)
 *
 *	Video noise reduction filter
 *		kPropPluginType - kValuePluginTypePrefilterVideoNoiseReduction (required, initialization-only)
 *		kPropPluginName - kValuePluginNamePrefilterVideoNoiseReduction (initialization-only)
 *		kPropNRLevel - Filter strength
 *
 *	Video de-interlace/inverse telecine filter
 *		kPropPluginType - kValuePluginTypePrefilterDeinterlace (required, initialization-only)
 *		kPropPluginName - kValuePluginNamePrefilterDeinterlace (initialization-only)
 *		kPropDITManual - Determines whether prefilter will attempt to automatically sense if de-interlace/inverse
 *			telecine filters are needed or not
 *		kPropDITDeinterlace - If kPropDITManual is TRUE, turns on the de-interlace filter.  Otherwise ignored.
 *		kPropDITInvTelecine - If kPropDITManual is TRUE, turns on the inverse telecine filter.  Otherwise ignored.
 *
 *	Audio limiter filter
 *		kPropPluginType - kValuePluginTypePrefilterAudioGain (required, initialization-only)
 *		kPropPluginName - kValuePluginNamePrefilterAudioGain (initialization-only)
 *		kPropAudioLimiterGain - Gain (dB)
 *
 *	Audio "watchdog" filter
 *		kPropPluginType - kValuePluginTypePrefilterLevelMeter (required, initialization-only)
 *		kPropPluginName - kValuePluginNamePrefilterLevelMeter (initialization-only)
 */

DEFINE_GUID(IID_IHXTPrefilter,
0x2717fed5, 0xb783, 0x41f9, 0xbc, 0x57, 0x79, 0xd6, 0x3e, 0xea, 0xa1, 0xf1);

#undef  INTERFACE
#define INTERFACE   IHXTPrefilter

DECLARE_INTERFACE_(IHXTPrefilter, IHXTConfigurationAgent)
{
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTPostfilter
 *
 *  {97F7A009-55DB-412d-B5A3-87D0346B6AB3}
 *
 *  Purpose:
 *
 *  Used to configure a postfilter's configuration properties (see IHXTConfigurationAgent
 *	in ihxtbase.h).
 *  
 *
 */


DEFINE_GUID(IID_IHXTPostfilter,
0x97f7a009, 0x55db, 0x412d, 0xb5, 0xa3, 0x87, 0xd0, 0x34, 0x6b, 0x6a, 0xb3);

#undef  INTERFACE
#define INTERFACE   IHXTPostfilter

DECLARE_INTERFACE_(IHXTPostfilter, IHXTConfigurationAgent)
{
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTDestination
 *
 *  {B09208E7-A692-4acf-9E59-7464D7D53489}
 *
 *  Purpose:
 *
 *  Used to configure a destination's configuration properties (see IHXTConfigurationAgent
 *	in ihxtbase.h) and manipulate a list of postfilters.
 *
 *
 *	Methods:
 *  
 *	AddPostfilter - Adds a postfilter to the back of the postfilter list
 *	GetPostfilter - Retrieves the postfilter at ulIndex
 *	RemovePostfilter - Removes the postfilter at ulIndex
 *	MovePostfilter - Moves a postfilter from ulOrigIndex to ulDestIndex.  Note that
 *	  during the encode, a/v samples will propagate through postfilters based on their 
 *	  list ordering (from lowest index number to highest).
 *	GetPostfilterCount - Returns the number of postfilters in the list
 *
 *	AddFailoverDestination - Not implemented yet
 *	GetFailoverDestination - Not implemented yet
 *	RemoveFailoverDestination - Not implemented yet
 *	MoveFailoverDestination - Not implemented yet
 *	GetFailoverDestinationCount - Not implemented yet
 *
 *
 *	Properties (see ihxtconstants.h for further details):
 *
 *	All Destinations
 *		kPropObjectName - Descriptive name of object instance
 *
 *	File writers
 *		kPropPluginType - kValuePluginTypeDestinationFile (required, initialization-only)
 *		kPropPluginName - kValuePluginNameFileDestRealMedia (initialization-only)
 *		kPropOutputPathname - Pathname of destination file
 *		kPropTempDirPath - Pathname of temp dir used for scratch files
 *		kPropFileRollSize - File size limit (in MB) at which rollover should occur
 *		kPropFileRollTime - File time limit at which rollover should occur
 *		kPropMergeWriteSize - 
 *		kPropMergeWriteInterval - 
 *		
 *	G2 push broadcast
 *		kPropPluginType - kValuePluginTypeDestinationG2PushServer (required, initialization-only)
 *		kPropPluginName - kValuePluginNameServerG2Push (initialization-only)
 *		kPropBroadcastAddress - RealServer address (IP address or domain name)
 *		kPropBroadcastPort - RealServer's encoder port that will be receiving broadcast
 *		kPropBroadcastStreamname - Name of live stream
 *		kPropBroadcastUsername - RealServer encoder account username
 *		kPropBroadcastPassword - RealServer encoder account password
 *		kPropBroadcastTransport - Broadcast transport type between encoder and RealServer [kValueUDPUnicast]
 *		
 *	RBS push broadcast ( account-based )
 *		kPropPluginType - kValuePluginTypeDestinationPushServer (required, initialization-only)
 *		kPropPluginName - kValuePluginNameServerRBS (initialization-only)
 *		kPropBroadcastAuthType - kValueAccountBased
 *		kPropBroadcastAddress - RealServer address (IP address or domain name.)
 *		kPropBroadcastPort - RealServer's http port.
 *		kPropBroadcastStreamname - Name of live stream
 *		kPropBroadcastPath - Broadcast path (prepended to stream name)
 *		kPropBroadcastUsername - RealServer encoder account username
 *		kPropBroadcastPassword - RealServer encoder account password
 *		kPropBroadcastTransport - Broadcast transport type between encoder and RealServer [kValueUDPUnicast]
 *		kPropBroadcastListenAddress - encoder ip address.
 *		kPropBroadcastMulticastAddress - Muticast server address used when transport type is udp/muticast.
 *		kPropBroadcastAllowResend - Boolean. Set to true to allow resend of packets from encoder.
 *		kPropBroadcastFecPercent - % of error correction data.
 *		kPropBroadcastFecOffset - Number of seconds to offset redundant packets when FEC is 100%.
 *		kPropBroadcastMulticastTTL - Multicast Time to Live.  
 *		kPropBroadcastMetadataResendInterval - Number of seconds between resending header packets.
 *		kPropBroadcastEnableTCPReconnect - if true then encoder would keep on re-connecting on tcp connection failure.
 *		kPropBroadcastTCPReconnectInterval - Number of seconds the encoder waits before attempting a reconnect after loosing a connection with a RealServer.
 *
 *	RBS push broadcast ( password-based )
 *		kPropPluginType - kValuePluginTypeDestinationPushServer (required, initialization-only)
 *		kPropPluginName - kValuePluginNameServerRBS (initialization-only)
 *		kPropBroadcastAuthType - kValueSinglePassword
 *		kPropBroadcastAddress - RealServer address (IP address or domain name.)
 *		kPropBroadcastPort -  Start port of port range,in receiver configuration on RealServer.
 *		kPropBroadcastEndPort - End port of port range,in receiver configuration on RealServer.
 *		kPropBroadcastStreamname - Name of live stream
 *		kPropBroadcastPath - Broadcast path (prepended to stream name)
 *		kPropBroadcastPassword - RealServer encoder account password
 *		kPropBroadcastTransport - Broadcast transport type between encoder and RealServer [kValueUDPUnicast]
 *		kPropBroadcastListenAddress - encoder ip address.
 *		kPropBroadcastMulticastAddress - Muticast server address used when transport type is udp/muticast.
 *		kPropBroadcastAllowResend - Boolean. Set to true to allow resend of packets from encoder.
 *		kPropBroadcastFecPercent - % of error correction data.
 *		kPropBroadcastFecOffset - Number of seconds to offset redundant packets when FEC is 100%.
 *		kPropBroadcastMulticastTTL - Multicast Time to Live.  
 *		kPropBroadcastMetadataResendInterval - Number of seconds between resending header packets.
 *		kPropBroadcastEnableTCPReconnect - if true then encoder would keep on re-connecting on tcp connection failure.
 *		kPropBroadcastTCPReconnectInterval - Number of seconds the encoder waits before attempting a reconnect after loosing a connection with a RealServer.
 *
 *		
 *	RBS pull broadcast
 *		kPropPluginType - kValuePluginTypeDestinationPullServer (required, initialization-only)
 *		kPropPluginName - kValuePluginNameServerRBS (initialization-only)
 *		kPropBroadcastStreamname - Name of live stream
 *		kPropBroadcastPath - Broadcast path (prepended to stream name)
 *		kPropBroadcastListenAddress - Encoder ip address.
 *		kPropListenPort - Port on which encoder listens for pull request.
 *		kPropBroadcastServerTimeout - Number of seconds encoder will wait for a ping from the RealServer before assuming no clients are connected to the stream and closing connection.
 *		kPropBroadcastEnableTCPReconnect - If true then encoder would keep on re-connecting on tcp connection failure.
 *		kPropBroadcastTCPReconnectInterval - Number of seconds the encoder waits before attempting a reconnect after loosing a connection with a RealServer.
 */

DEFINE_GUID(IID_IHXTDestination,
0xb09208e7, 0xa692, 0x4acf, 0x9e, 0x59, 0x74, 0x64, 0xd7, 0xd5, 0x34, 0x89);

#undef  INTERFACE
#define INTERFACE   IHXTDestination

DECLARE_INTERFACE_(IHXTDestination, IHXTConfigurationAgent)
{
    STDMETHOD(AddPostfilter) (THIS_ IHXTPostfilter* pPostfilter) PURE;
    STDMETHOD(GetPostfilter) (THIS_ UINT32 ulIndex, IHXTPostfilter** ppPostfilter) PURE;
    STDMETHOD(RemovePostfilter) (THIS_ UINT32 ulIndex) PURE;
    STDMETHOD(MovePostfilter)(UINT32 ulOrigIndex, UINT32 ulDestIndex) PURE;
    STDMETHOD_(UINT32, GetPostfilterCount) (THIS) PURE;

    STDMETHOD(AddFailoverDestination) (THIS_ IHXTDestination* pDestination) PURE;
    STDMETHOD(GetFailoverDestination) (THIS_ UINT32 ulIndex, IHXTDestination** ppDestination) PURE;
    STDMETHOD(RemoveFailoverDestination) (THIS_ UINT32 ulIndex) PURE;
    STDMETHOD(MoveFailoverDestination)(UINT32 ulOrigIndex, UINT32 ulDestIndex) PURE;
    STDMETHOD_(UINT32, GetFailoverDestinationCount) (THIS) PURE;
};


/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTOutputProfile
 *
 *  {27F7E0E3-6FD2-11d5-96E7-00D0B7068A6E}
 *
 *  Purpose:
 *
 *  Used to configure an output profile's configuration properties (see IHXTConfigurationAgent
 *	in ihxtbase.h) and manipulate a list of destinations.  The output profile associates
 *	a list of destinations (e.g., file writers or broadcast transmitters) with a media
 *	profile (how something will be encoded).
 *
 *
 *	Methods:
 *  
 *	AddDestination - Adds a destination to the back of the destination list
 *	GetDestination - Retrieves the destination at ulIndex
 *	RemoveDestination - Removes the destination at ulIndex
 *	MoveDestination - Moves a destination from ulOrigIndex to ulDestIndex.  Note that
 *	  during the encode, a/v samples will propagate through destinations based on their 
 *	  list ordering (from lowest index number to highest).
 *	GetDestinationCount - Returns the number of destinations in the list
 *  
 *	GetMediaProfile - Gets the current media profile
 *	SetMediaProfile - Sets the media profile
 *
 *
 *	Properties (see ihxtconstants.h for further details):
 *
 *	kPropObjectName - Descriptive name of object instance
 *
 */

DEFINE_GUID(IID_IHXTOutputProfile,
0x27f7e0e3, 0x6fd2, 0x11d5, 0x96, 0xe7, 0x0, 0xd0, 0xb7, 0x6, 0x8a, 0x6e);


#undef  INTERFACE
#define INTERFACE   IHXTOutputProfile

DECLARE_INTERFACE_(IHXTOutputProfile, IHXTConfigurationAgent)
{
    STDMETHOD(AddDestination) (THIS_ IHXTDestination* pDestination) PURE;
    STDMETHOD(GetDestination) (THIS_ UINT32 ulIndex, IHXTDestination** ppDestination) PURE;
    STDMETHOD(RemoveDestination) (THIS_ UINT32 ulIndex) PURE;
    STDMETHOD(MoveDestination)(UINT32 ulOrigIndex, UINT32 ulDestIndex) PURE;
    STDMETHOD_(UINT32, GetDestinationCount) (THIS) PURE;

    STDMETHOD(GetMediaProfile) (THIS_ IHXTMediaProfile** ppMediaProfile) PURE;
    STDMETHOD(SetMediaProfile) (THIS_ IHXTMediaProfile* pMediaProfile) PURE;

};


// {3BAF5D7C-6715-437a-94BD-8114CE565592}
DEFINE_GUID(IID_IHXTOutputProfile2, 
0x3baf5d7c, 0x6715, 0x437a, 0x94, 0xbd, 0x81, 0x14, 0xce, 0x56, 0x55, 0x92);


#undef  INTERFACE
#define INTERFACE   IHXTOutputProfile2

DECLARE_INTERFACE_(IHXTOutputProfile2, IHXTOutputProfile)
{
    STDMETHOD(GetMetadata)(THIS_ IHXTPropertyBag** ppMetadata) PURE;
    STDMETHOD(SetMetadata)(THIS_ IHXTPropertyBag* pMetadata) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTMediaProfile
 *
 *  {ACAB0452-6FED-11d5-96E7-00D0B7068A6E}
 *
 *  Purpose:
 *
 *  Used to configure a media profile's configuration properties (see IHXTConfigurationAgent
 *	in ihxtbase.h) and manipulate a list of audiences.
 *
 *
 *	Methods:
 *  
 *	AddAudience - Adds an audience to the back of the audience list
 *	GetAudience - Retrieves the audience at ulIndex
 *	RemoveAudience - Removes the audience at ulIndex
 *	MoveAudience - Moves an audience from ulOrigIndex to ulDestIndex
 *	GetAudienceCount - Returns the number of audiences in the list
 *  
 *
 *	Properties (see ihxtconstants.h for further details):
 *
 *	kPropObjectName - Descriptive name of object instance
 *	kPropVideoMode - Video encoding mode
 *	kPropDisableAudio - Disables the encoding of audio
 *	kPropDisableVideo - Disables the encoding of video
 *	kPropDisableEvents - Disables the encoding of events
 *	kPropDisableImageMaps - Disables the encoding of imagemaps
 *	kPropAudioMode - Type of audio content being encoded
 *	kPropAudioResamplingQuality - Resampler quality setting
 *	kPropOutputWidth - Playback width of encoded video
 *	kPropOutputHeight - Playback height of encoded video
 *	kPropResizeQuality - Video resize quality setting
 *	
 *
 */

DEFINE_GUID(IID_IHXTMediaProfile,
0xacab0452, 0x6fed, 0x11d5, 0x96, 0xe7, 0x0, 0xd0, 0xb7, 0x6, 0x8a, 0x6e);


#undef  INTERFACE
#define INTERFACE   IHXTMediaProfile

DECLARE_INTERFACE_(IHXTMediaProfile, IHXTConfigurationAgent)
{

    STDMETHOD(AddAudience) (THIS_ IHXTAudience* pAudience) PURE;
    STDMETHOD(GetAudience) (THIS_ UINT32 ulIndex, IHXTAudience** ppAudience) PURE;
    STDMETHOD(RemoveAudience) (THIS_ UINT32 ulIndex) PURE;
    STDMETHOD(MoveAudience)(UINT32 ulOrigIndex, UINT32 ulDestIndex) PURE;
    STDMETHOD_(UINT32, GetAudienceCount) (THIS) PURE;


};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTStreamConfig
 *
 *  {2BAAECD2-7482-11d5-96E7-00D0B7068A6E}
 *
 *  Purpose:
 *
 *  Used to configure a stream's configuration properties (see IHXTConfigurationAgent
 *	in ihxtbase.h).  A stream typically represents an audio codec or video codec.
 *
 *	Properties (see ihxtconstants.h for further details):
 *
 *	All StreamConfigs
 *		kPropObjectName - Descriptive name of object instance
 *		kPropEncodingType - Type of encode (CBR/VBR bitrate/VBR quality)
 *
 *	Audio codecs
 *		kPropPluginType - kValuePluginTypeAudioStream (required, initialization-only)
 *		kPropPluginName - kValuePluginNameCodecRealAudio (initialization-only)
 *		kPropCodecName - Codec name (cook, sipro, etc.)
 *		kPropCodecFlavor - Codec flavor
 *		kPropStreamContext - Property bag used by sdk to select audio stream if audience contains multiple
 *			audio streams
 *		kPropAvgBitrate - Average bitrate. (read-only)
 *		kPropMaxBitrate - Max bitrate. (read-only)
 *
 *	Video codecs
 *		kPropPluginType - kValuePluginTypeVideoStream (required, initialization-only)
 *		kPropPluginName - kValuePluginNameCodecRealVideo (initialization-only)
 *		kPropAvgBitrate - Average bitrate.  Must be zero.  Zero means that the sdk will calculate
 *			the bitrate based on the audience average bitrate and other active stream within in audience.
 *		kPropMaxBitrate - Max bitrate.  Must be zero.  Zero means that the sdk will calculate
 *			the bitrate based on the audience max bitrate and other active stream within in audience.
 *		kPropCodecName - Codec name (rv8, rv9, etc.)
 *		kPropEncodingQuality - VBR quality mode setting
 *		kPropMaxStartupLatency - Max video preroll (initial buffering on playback)
 *		kPropLossProtection - Adds error correction codes
 *		kPropMaxOutputFrameRate - Max encoded frame rate
 *		kPropMaxTimeBetweenKeyFrames - Max amount of time between keyframes
 *
 */

DEFINE_GUID(IID_IHXTStreamConfig,
0x2baaecd2, 0x7482, 0x11d5, 0x96, 0xe7, 0x0, 0xd0, 0xb7, 0x6, 0x8a, 0x6e);


#undef  INTERFACE
#define INTERFACE   IHXTStreamConfig

DECLARE_INTERFACE_(IHXTStreamConfig, IHXTConfigurationAgent)
{
};







/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTAudience
 *
 *  {DBE83632-6FED-11d5-96E7-00D0B7068A6E}
 *
 *  Purpose:
 *
 *  Used to configure an audience's configuration properties (see IHXTConfigurationAgent
 *	in ihxtbase.h) and manipulate a list of stream configs (typically a/v codecs).
 *
 *
 *	Methods:
 *  
 *	AddStreamConfig - Adds a stream config to the back of the stream config list
 *	GetStreamConfig - Retrieves the stream config at ulIndex
 *	RemoveStreamConfig - Removes the stream config at ulIndex
 *	MoveStreamConfig - Moves a stream config from ulOrigIndex to ulDestIndex
 *	GetStreamConfigCount - Returns the number of stream configs in the list
 *
 *
 *	Properties (see ihxtconstants.h for further details):
 *
 *	kPropObjectName - Descriptive name of object instance
 *	kPropAvgBitrate - Average bitrate.  Used for CBR and VBR target bitrate encodes.
 *	kPropMaxBitrate - Max bitrate.  Used for VBR target bitrate and VBR quality mode encodes.
 */

DEFINE_GUID(IID_IHXTAudience,
0xdbe83632, 0x6fed, 0x11d5, 0x96, 0xe7, 0x0, 0xd0, 0xb7, 0x6, 0x8a, 0x6e);


#undef  INTERFACE
#define INTERFACE   IHXTAudience

DECLARE_INTERFACE_(IHXTAudience, IHXTConfigurationAgent)
{
    STDMETHOD(AddStreamConfig) (THIS_ IHXTStreamConfig* pStreamDef) PURE;
    STDMETHOD(GetStreamConfig) (THIS_ UINT32 ulIndex, IHXTStreamConfig** ppStreamDef) PURE;
    STDMETHOD(RemoveStreamConfig) (THIS_ UINT32 ulIndex) PURE;
    STDMETHOD(MoveStreamConfig)(UINT32 ulOrigIndex, UINT32 ulDestIndex) PURE;
    STDMETHOD_(UINT32, GetStreamConfigCount) (THIS) PURE;
    
};






/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTSerializationCallback
 *
 *  Purpose:
 *
 */
// {4737414F-4422-49ed-86E9-F294BA134C84}
DEFINE_GUID(IID_IHXTSerializationCallback, 
0x4737414f, 0x4422, 0x49ed, 0x86, 0xe9, 0xf2, 0x94, 0xba, 0x13, 0x4c, 0x84);

#undef  INTERFACE
#define INTERFACE   IHXTSerializationCallback

DECLARE_INTERFACE_(IHXTSerializationCallback, IUnknown)
{
    STDMETHOD(OnSerializeObject) (THIS_ const IUnknown* pObject, IHXTPropertyBag* pClonedBag, BOOL* pbIsOkToSerialize ) PURE;
};




/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTSerializeBuffer
 *
 *  Purpose:
 *
 */
DEFINE_GUID(IID_IHXTSerializeBuffer,
0xef39f51d, 0x8df1, 0x4621, 0xa5, 0xdb, 0x66, 0xfc, 0x2d, 0x64, 0xa7, 0x1e);

#undef  INTERFACE
#define INTERFACE   IHXTSerializeBuffer

DECLARE_INTERFACE_(IHXTSerializeBuffer, IUnknown)
{
    STDMETHOD(ReadFromBuffer) (THIS_ IHXBuffer* pszXmlBody, BOOL bForceInitialization=FALSE, IHXTPropertyBag** ppInitErrorBag=NULL) PURE;
    STDMETHOD(WriteToBuffer) (THIS_ IHXBuffer* pszXmlBody, IHXTSerializationCallback* pSerialCallback=NULL ) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTUserConfigFile
 *
 *  Purpose:
 *
 *  
 *
 * {7ACD9979-3B6A-11d6-8A1E-00D0B7100250}
 *
 */

// {7ACD9979-3B6A-11d6-8A1E-00D0B7100250}
DEFINE_GUID(IID_IHXTUserConfigFile, 
0x7acd9979, 0x3b6a, 0x11d6, 0x8a, 0x1e, 0x0, 0xd0, 0xb7, 0x10, 0x2, 0x50);


#undef  INTERFACE
#define INTERFACE   IHXTUserConfigFile

DECLARE_INTERFACE_(IHXTUserConfigFile, IUnknown)
{
    STDMETHOD(WriteToFile) (THIS_ const char* szPathname, IHXTSerializationCallback* pSerialCallback=NULL ) PURE;
    STDMETHOD(ReadFromFile) (THIS_ const char* szPathname, BOOL bForceInitialization=FALSE, IHXTPropertyBag** ppInitErrorBag=NULL) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTAudienceEnumerator
 *
 *  Purpose:
 *
 *  
 *
 *  {45D2135C-6B46-4d02-B7EC-E27891BC751A}
 *
 */


DEFINE_GUID(IID_IHXTAudienceEnumerator,
0x45d2135c, 0x6b46, 0x4d02, 0xb7, 0xec, 0xe2, 0x78, 0x91, 0xbc, 0x75, 0x1a);

#undef  INTERFACE
#define INTERFACE   IHXTAudienceEnumerator

DECLARE_INTERFACE_(IHXTAudienceEnumerator, IUnknown)
{
    STDMETHOD(SetProfileDirectory) (THIS_ const char* szDirectoryPath) PURE;
    STDMETHOD(SetProfileExtension) (THIS_ const char* szProfileExtension) PURE;
    
    STDMETHOD(GetAudience) (THIS_ UINT32 ulIndex, IHXTAudience** ppAudience, const char** ppszFilename) PURE;
    STDMETHOD_(UINT32, GetAudienceCount) (THIS) PURE;
};




/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTAudienceEnumerator2
 *
 *  Purpose:
 *
 *  
 *
 *  {45D2135C-6B46-4d02-B7EC-E27891BC751A}
 *
 */

// {EF8C1F0B-010A-492e-9C34-CC9260B5A6B8}
DEFINE_GUID(IID_IHXTAudienceEnumerator2, 
0xef8c1f0b, 0x10a, 0x492e, 0x9c, 0x34, 0xcc, 0x92, 0x60, 0xb5, 0xa6, 0xb8);


#undef  INTERFACE
#define INTERFACE   IHXTAudienceEnumerator2

DECLARE_INTERFACE_(IHXTAudienceEnumerator2, IHXTAudienceEnumerator)
{
    /*
    Get methods corresponding to set methods on the audienceenumerator interface
    */
    STDMETHOD(GetProfileDirectory) (THIS_ const char** cpszDirectoryPath) PURE;
    STDMETHOD(GetProfileExtension) (THIS_ const char** cpszProfileExtension) PURE;
    
    /*
    Allows for Forcing Initialization to deserialize audience files that contain
    non-existent codecs (e.g. old).  This defaults to false.
    */
    STDMETHOD(GetForceInitialize)(THIS_ BOOL* pbForceInitialize) PURE;
    STDMETHOD(SetForceInitialize)(THIS_ BOOL bForceInitialize) PURE;

    /*
    By supplying the codec updater object, all audiences contained in the
    audience enumerator will be updated prior to retrieving.
    */
    STDMETHOD(GetCodecUpdater) (THIS_ IHXTCodecUpdater** ppCodecUpdater) PURE;
    STDMETHOD(SetCodecUpdater) (THIS_ IHXTCodecUpdater* pCodecUpdater) PURE;
};



/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTDestinationEnumerator
 *
 *  Purpose:
 *
 *  
 *
 *  {3EEFE8D2-6FEE-4c34-A193-C6FDB2B2565C}
 *
 */


DEFINE_GUID(IID_IHXTDestinationEnumerator,
0x3eefe8d2, 0x6fee, 0x4c34, 0xa1, 0x93, 0xc6, 0xfd, 0xb2, 0xb2, 0x56, 0x5c);

#undef  INTERFACE
#define INTERFACE   IHXTDestinationEnumerator

DECLARE_INTERFACE_(IHXTDestinationEnumerator, IUnknown)
{
    STDMETHOD(SetProfileDirectory) (THIS_ const char* szDirectoryPath) PURE;
    STDMETHOD(SetProfileExtension) (THIS_ const char* szProfileExtension) PURE;
    
    STDMETHOD(GetDestination) (THIS_ UINT32 ulIndex, IHXTDestination** ppBroadcastDef, const char** pszFilename) PURE;
    STDMETHOD_(UINT32, GetDestinationCount) (THIS) PURE;
};





/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTPluginInfoManager
 *
 *  Purpose:
 *
 *  Gets Module enumerator.
 *
 *  {71FBEBC2-D36B-4765-8BBB-B3875408FB31}
 *
 *
 */
// 

DEFINE_GUID(IID_IHXTPluginInfoManager, 
0x71fbebc2, 0xd36b, 0x4765, 0x8b, 0xbb, 0xb3, 0x87, 0x54, 0x8, 0xfb, 0x31);

#undef  INTERFACE
#define INTERFACE   IHXTPluginInfoManager

DECLARE_INTERFACE_( IHXTPluginInfoManager, IUnknown )
{
	STDMETHOD ( GetPluginInfoEnum )( IHXTPropertyBag *pIQueryPropertyBag, IHXTPluginInfoEnum ** ppIPluginInfoEnum ) PURE;
};


// {733901C8-D59E-4437-B938-34C25A94C9E0}
DEFINE_GUID(CLSID_IHXTCaptureDeviceInfoManager, 
0x733901c8, 0xd59e, 0x4437, 0xb9, 0x38, 0x34, 0xc2, 0x5a, 0x94, 0xc9, 0xe0);

// {5FB23733-B6CD-4a9f-A1C4-FE624CCE6A56}
DEFINE_GUID(CLSID_IHXTCodecInfoManager, 
0x5fb23733, 0xb6cd, 0x4a9f, 0xa1, 0xc4, 0xfe, 0x62, 0x4c, 0xce, 0x6a, 0x56);




/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTCodecUpdater
 *
 *  Purpose:
 *
 *  This is a utility interface that enables a user to specify the location
 *  of a mapping file that is the source for upgrading codecs.  The user can
 *  have all audiences for a job updated or can select individual audiences
 *  to update.
 *
 *  {571F9DD8-D2CC-4719-BFEB-EA56BE994189}
 *
 *
 */

// {571F9DD8-D2CC-4719-BFEB-EA56BE994189}
DEFINE_GUID(IID_IHXTCodecUpdater, 
0x571f9dd8, 0xd2cc, 0x4719, 0xbf, 0xeb, 0xea, 0x56, 0xbe, 0x99, 0x41, 0x89);


#undef  INTERFACE
#define INTERFACE   IHXTCodecUpdater

DECLARE_INTERFACE_(IHXTCodecUpdater, IUnknown)
{
    /******
    	Get/Set the mapping file name and location
    	When set, the file will be parsed and errors reported as applicable.
    *******/
    STDMETHOD(GetCodecMappingFile)(THIS_ const char** ppszMappingFile) PURE;
    STDMETHOD(SetCodecMappingFile)(THIS_ const char* pszMappingFile) PURE;

    /******
    	Update a single audience based on the mappings provided in the
    	file.  If no mappings are specified, an unexpected error will be returned.
	If any stream update fails in the audience, then the entire method fails.
	The in audience is unaltered and the new updated job is returned as an out param
	If the new audience has been modified from the original audience then the 
	change is reflected by setting the pbAudienceUpdated value to TRUE.  pbAudienceUpdated
	can be null and then no value is returned.
    *******/
    STDMETHOD(UpdateAudience)(THIS_ IHXTAudience* pAudience, IHXTAudience** ppNewAudience, BOOL* pbAudienceUpdated = NULL) PURE;

    /******
    	Update all audiences contained in a job based on the mappings provided in the
    	file.  If no mappings are specified, an unexpected error will be returned.
	If any stream update fails in the audience, then the entire method fails.
	If and of the audiences have been modified from the original audiences then the 
	change is reflected by setting the pbAudienceUpdated value to TRUE.  pbAudienceUpdated
	can be null and then no value is returned.
    *******/
    STDMETHOD(UpdateJob)(THIS_ IHXTEncodingJob* pEncodingJob, BOOL* pbAudienceUpdated = NULL) PURE;
};





/****************************************************************************
 *
 *  Interface:
 *
 *  IHXTPacketSource
 *
 *  Purpose:
 *
 *  Supports receiving IHXPackets out of the producersdk
 *
 *  {285B879B-26BD-4a6a-92EF-2CA29942D69E}
 *
 *
 */

// {285B879B-26BD-4a6a-92EF-2CA29942D69E}
DEFINE_GUID(IID_IHXTPacketSource, 
0x285b879b, 0x26bd, 0x4a6a, 0x92, 0xef, 0x2c, 0xa2, 0x99, 0x42, 0xd6, 0x9e);

#undef  INTERFACE
#define INTERFACE   IHXTPacketSource

DECLARE_INTERFACE_(IHXTPacketSource, IUnknown)
{
    //	IHXTPacketSource
    STDMETHOD(GetSourceHandler)(THIS_ IHXSourceHandler** ppSourceHandler) PURE;
    STDMETHOD(SetSourceHandler)(THIS_ IHXSourceHandler* pSourceHandler) PURE;
};


#endif // _HXTENCODINGJOB_H


