/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved. 
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s): 
 *  
 * ***** END LICENSE BLOCK ***** */

#ifndef _RMAEDIT2_H_
#define _RMAEDIT2_H_

struct IHXValues;

/****************************************************************************
 *  Function:
 *		RMACreateRMEdit2
 *
 *  Purpose:
 *		Creates an instance of a G2 RMEditor2 object. 
 */
STDAPI RMACreateRMEdit2(IUnknown**  /*OUT*/	ppIUnknown);

typedef HX_RESULT (HXEXPORT_PTR FPCREATEINSTANCE) (IUnknown** /*OUT*/ ppIUnknown);

/****************************************************************************
 * 
 *  Interface:
 *
 *	IHXRMEdit2
 *
 *  Purpose:
 *
 *	Interface to rmeditor2 module
 *
 *  IHXRMEdit2
 *
 *  {D01CE590-B155-11d2-A1E7-0060083BE563}
 *
 */

DEFINE_GUID(IID_IHXRMEdit2, 
0xd01ce590, 0xb155, 0x11d2, 0xa1, 0xe7, 0x0, 0x60, 0x8, 0x3b, 0xe5, 0x63);

#define CLSID_IRMARMEdit2 IID_IHXRMEdit2

#undef  INTERFACE
#define INTERFACE   IHXRMEdit2

DECLARE_INTERFACE_(IHXRMEdit2, IUnknown)
{
    /***********************************************************************/
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)	(THIS) PURE;

    STDMETHOD_(ULONG32,Release)	(THIS) PURE;

    /***********************************************************************/
    /*
     *	IHXRMEdit2 methods
     */
 
    /************************************************************************
     *	Method:
     *	    IHXRMEdit2::HasAudio
     *	Purpose:
     *	    returns if the current .rm file contains audio. 
     *
     *	Parameters:
     *	    pbHasAudio - [out] sets pbHasAudio to TRUE if the file contains audio
     */
	STDMETHOD(HasAudio) (THIS_
				BOOL* pbHasAudio) PURE;        

    /************************************************************************
     *	Method:
     *	    IHXRMEdit2::HasVideo
     *	Purpose:
     *	    returns if the current .rm file contains video. 
     *
     *	Parameters:
     *	    pbHasVideo - [out] sets pbHasVideo to TRUE if the file contains video
     */
	STDMETHOD(HasVideo) (THIS_
				BOOL* pbHasVideo) PURE;        

    /************************************************************************
     *	Method:
     *	    IHXRMEdit2::HasEvents
     *	Purpose:
     *	    returns if the current .rm file contains events. 
     *
     *	Parameters:
     *	    pbHasEvents - [out] sets pbHasEvents to TRUE if the file contains events
     */
	STDMETHOD(HasEvents) (THIS_
				BOOL* pbHasEvents) PURE;        

    /************************************************************************
     *	Method:
     *	    IHXRMEdit2::HasImageMaps
     *	Purpose:
     *	    returns if the current .rm file contains image maps. 
     *
     *	Parameters:
     *	    HasImageMaps - [out] sets HasImageMaps to TRUE if the file contains image maps
     */
	STDMETHOD(HasImageMaps) (THIS_
				BOOL* pbHasImageMaps) PURE;        

    /************************************************************************
     *	Method:
     *	    IHXRMEdit2::GetVideoSize
     *	Purpose:
     *	    returns the height and width of the video in pixels
     *
     *	Parameters:
     *	    pHeight - [out] contains the height of the video
     *	    pWidth - [out] contains the width of the video
     */
	STDMETHOD(GetVideoSize) (THIS_
				UINT16* pHeight, UINT16* pWidth) PURE;        

    /************************************************************************
     *	Method:
     *	    IHXRMMetaInformation::GetMetaInformation
     *	Purpose:
     *	    Get the Meta Information currently stored in the active input file
     *	    This returns a pointer to the IHXValues that contains all of the 
     *	    properties. You can then change the meta information fields in the 
     *		returned IRMAValues. 
     *	Parameters:
     *	    ppValues - [out] IHXValues pointer to get the existing values
     */
    STDMETHOD(GetMetaInformation) (THIS_
			IHXValues** ppValues) PURE;
};


#endif
//_RMAEDIT2_H_
